/*******************************************************************************
 * Copyright (c) 2009, 2011 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.openhealthtools.mdht.uml.hl7.vocab;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Act Class Observation</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see org.openhealthtools.mdht.uml.hl7.vocab.VocabPackage#getActClassObservation()
 * @model
 * @generated
 */
public enum ActClassObservation implements Enumerator {
	/**
	 * The '<em><b>ALRT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ALRT_VALUE
	 * @generated
	 * @ordered
	 */
	ALRT(0, "ALRT", "ALRT"),

	/**
	 * The '<em><b>CASE</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #CASE_VALUE
	 * @generated
	 * @ordered
	 */
	CASE(1, "CASE", "CASE"),

	/**
	 * The '<em><b>CLNTRL</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #CLNTRL_VALUE
	 * @generated
	 * @ordered
	 */
	CLNTRL(2, "CLNTRL", "CLNTRL"),

	/**
	 * The '<em><b>CNOD</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #CNOD_VALUE
	 * @generated
	 * @ordered
	 */
	CNOD(3, "CNOD", "CNOD"),

	/**
	 * The '<em><b>COND</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #COND_VALUE
	 * @generated
	 * @ordered
	 */
	COND(4, "COND", "COND"),

	/**
	 * The '<em><b>DGIMG</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #DGIMG_VALUE
	 * @generated
	 * @ordered
	 */
	DGIMG(5, "DGIMG", "DGIMG"),

	/**
	 * The '<em><b>INVSTG</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #INVSTG_VALUE
	 * @generated
	 * @ordered
	 */
	INVSTG(6, "INVSTG", "INVSTG"),

	/**
	 * The '<em><b>OBS</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #OBS_VALUE
	 * @generated
	 * @ordered
	 */
	OBS(7, "OBS", "OBS"),

	/**
	 * The '<em><b>OBSCOR</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #OBSCOR_VALUE
	 * @generated
	 * @ordered
	 */
	OBSCOR(8, "OBSCOR", "OBSCOR"),

	/**
	 * The '<em><b>OBSSER</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #OBSSER_VALUE
	 * @generated
	 * @ordered
	 */
	OBSSER(9, "OBSSER", "OBSSER"),

	/**
	 * The '<em><b>OUTB</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #OUTB_VALUE
	 * @generated
	 * @ordered
	 */
	OUTB(10, "OUTB", "OUTB"),

	/**
	 * The '<em><b>ROIBND</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ROIBND_VALUE
	 * @generated
	 * @ordered
	 */
	ROIBND(11, "ROIBND", "ROIBND"),

	/**
	 * The '<em><b>ROIOVL</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ROIOVL_VALUE
	 * @generated
	 * @ordered
	 */
	ROIOVL(12, "ROIOVL", "ROIOVL"),

	/**
	 * The '<em><b>SPCOBS</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SPCOBS_VALUE
	 * @generated
	 * @ordered
	 */
	SPCOBS(13, "SPCOBS", "SPCOBS");

	/**
	 * The '<em><b>ALRT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>ALRT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ALRT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int ALRT_VALUE = 0;

	/**
	 * The '<em><b>CASE</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>CASE</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #CASE
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int CASE_VALUE = 1;

	/**
	 * The '<em><b>CLNTRL</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>CLNTRL</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #CLNTRL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int CLNTRL_VALUE = 2;

	/**
	 * The '<em><b>CNOD</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>CNOD</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #CNOD
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int CNOD_VALUE = 3;

	/**
	 * The '<em><b>COND</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>COND</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #COND
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int COND_VALUE = 4;

	/**
	 * The '<em><b>DGIMG</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>DGIMG</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #DGIMG
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int DGIMG_VALUE = 5;

	/**
	 * The '<em><b>INVSTG</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>INVSTG</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #INVSTG
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int INVSTG_VALUE = 6;

	/**
	 * The '<em><b>OBS</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>OBS</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #OBS
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int OBS_VALUE = 7;

	/**
	 * The '<em><b>OBSCOR</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>OBSCOR</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #OBSCOR
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int OBSCOR_VALUE = 8;

	/**
	 * The '<em><b>OBSSER</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>OBSSER</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #OBSSER
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int OBSSER_VALUE = 9;

	/**
	 * The '<em><b>OUTB</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>OUTB</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #OUTB
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int OUTB_VALUE = 10;

	/**
	 * The '<em><b>ROIBND</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>ROIBND</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ROIBND
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int ROIBND_VALUE = 11;

	/**
	 * The '<em><b>ROIOVL</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>ROIOVL</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ROIOVL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int ROIOVL_VALUE = 12;

	/**
	 * The '<em><b>SPCOBS</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>SPCOBS</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #SPCOBS
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int SPCOBS_VALUE = 13;

	/**
	 * An array of all the '<em><b>Act Class Observation</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final ActClassObservation[] VALUES_ARRAY = new ActClassObservation[] {
			ALRT, CASE, CLNTRL, CNOD, COND, DGIMG, INVSTG, OBS, OBSCOR, OBSSER, OUTB, ROIBND, ROIOVL, SPCOBS, };

	/**
	 * A public read-only list of all the '<em><b>Act Class Observation</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<ActClassObservation> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Act Class Observation</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static ActClassObservation get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ActClassObservation result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Act Class Observation</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static ActClassObservation getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ActClassObservation result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Act Class Observation</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static ActClassObservation get(int value) {
		switch (value) {
			case ALRT_VALUE:
				return ALRT;
			case CASE_VALUE:
				return CASE;
			case CLNTRL_VALUE:
				return CLNTRL;
			case CNOD_VALUE:
				return CNOD;
			case COND_VALUE:
				return COND;
			case DGIMG_VALUE:
				return DGIMG;
			case INVSTG_VALUE:
				return INVSTG;
			case OBS_VALUE:
				return OBS;
			case OBSCOR_VALUE:
				return OBSCOR;
			case OBSSER_VALUE:
				return OBSSER;
			case OUTB_VALUE:
				return OUTB;
			case ROIBND_VALUE:
				return ROIBND;
			case ROIOVL_VALUE:
				return ROIOVL;
			case SPCOBS_VALUE:
				return SPCOBS;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private ActClassObservation(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getValue() {
		return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getLiteral() {
		return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}

} // ActClassObservation
