/*******************************************************************************
 * Copyright (c) 2009, 2011 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.openhealthtools.mdht.uml.hl7.vocab;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Entity Class Root</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see org.openhealthtools.mdht.uml.hl7.vocab.VocabPackage#getEntityClassRoot()
 * @model
 * @generated
 */
public enum EntityClassRoot implements Enumerator {
	/**
	 * The '<em><b>ANM</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ANM_VALUE
	 * @generated
	 * @ordered
	 */
	ANM(0, "ANM", "ANM"),

	/**
	 * The '<em><b>CER</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #CER_VALUE
	 * @generated
	 * @ordered
	 */
	CER(1, "CER", "CER"),

	/**
	 * The '<em><b>CHEM</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #CHEM_VALUE
	 * @generated
	 * @ordered
	 */
	CHEM(2, "CHEM", "CHEM"),

	/**
	 * The '<em><b>CITY</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #CITY_VALUE
	 * @generated
	 * @ordered
	 */
	CITY(3, "CITY", "CITY"),

	/**
	 * The '<em><b>CONT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #CONT_VALUE
	 * @generated
	 * @ordered
	 */
	CONT(4, "CONT", "CONT"),

	/**
	 * The '<em><b>COUNTRY</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #COUNTRY_VALUE
	 * @generated
	 * @ordered
	 */
	COUNTRY(5, "COUNTRY", "COUNTRY"),

	/**
	 * The '<em><b>COUNTY</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #COUNTY_VALUE
	 * @generated
	 * @ordered
	 */
	COUNTY(6, "COUNTY", "COUNTY"),

	/**
	 * The '<em><b>DEV</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #DEV_VALUE
	 * @generated
	 * @ordered
	 */
	DEV(7, "DEV", "DEV"),

	/**
	 * The '<em><b>ENT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENT_VALUE
	 * @generated
	 * @ordered
	 */
	ENT(8, "ENT", "ENT"),

	/**
	 * The '<em><b>FOOD</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #FOOD_VALUE
	 * @generated
	 * @ordered
	 */
	FOOD(9, "FOOD", "FOOD"),

	/**
	 * The '<em><b>HCE</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #HCE_VALUE
	 * @generated
	 * @ordered
	 */
	HCE(10, "HCE", "HCE"),

	/**
	 * The '<em><b>HOLD</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #HOLD_VALUE
	 * @generated
	 * @ordered
	 */
	HOLD(11, "HOLD", "HOLD"),

	/**
	 * The '<em><b>LIV</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #LIV_VALUE
	 * @generated
	 * @ordered
	 */
	LIV(12, "LIV", "LIV"),

	/**
	 * The '<em><b>MAT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #MAT_VALUE
	 * @generated
	 * @ordered
	 */
	MAT(13, "MAT", "MAT"),

	/**
	 * The '<em><b>MIC</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #MIC_VALUE
	 * @generated
	 * @ordered
	 */
	MIC(14, "MIC", "MIC"),

	/**
	 * The '<em><b>MMAT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #MMAT_VALUE
	 * @generated
	 * @ordered
	 */
	MMAT(15, "MMAT", "MMAT"),

	/**
	 * The '<em><b>MODDV</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #MODDV_VALUE
	 * @generated
	 * @ordered
	 */
	MODDV(16, "MODDV", "MODDV"),

	/**
	 * The '<em><b>NAT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #NAT_VALUE
	 * @generated
	 * @ordered
	 */
	NAT(17, "NAT", "NAT"),

	/**
	 * The '<em><b>NLIV</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #NLIV_VALUE
	 * @generated
	 * @ordered
	 */
	NLIV(18, "NLIV", "NLIV"),

	/**
	 * The '<em><b>ORG</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ORG_VALUE
	 * @generated
	 * @ordered
	 */
	ORG(19, "ORG", "ORG"),

	/**
	 * The '<em><b>PLC</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PLC_VALUE
	 * @generated
	 * @ordered
	 */
	PLC(20, "PLC", "PLC"),

	/**
	 * The '<em><b>PLNT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PLNT_VALUE
	 * @generated
	 * @ordered
	 */
	PLNT(21, "PLNT", "PLNT"),

	/**
	 * The '<em><b>PROVINCE</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PROVINCE_VALUE
	 * @generated
	 * @ordered
	 */
	PROVINCE(22, "PROVINCE", "PROVINCE"),

	/**
	 * The '<em><b>PSN</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PSN_VALUE
	 * @generated
	 * @ordered
	 */
	PSN(23, "PSN", "PSN"),

	/**
	 * The '<em><b>PUB</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PUB_VALUE
	 * @generated
	 * @ordered
	 */
	PUB(24, "PUB", "PUB"),

	/**
	 * The '<em><b>RGRP</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #RGRP_VALUE
	 * @generated
	 * @ordered
	 */
	RGRP(25, "RGRP", "RGRP"),

	/**
	 * The '<em><b>STATE</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #STATE_VALUE
	 * @generated
	 * @ordered
	 */
	STATE(26, "STATE", "STATE");

	/**
	 * The '<em><b>ANM</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>ANM</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ANM
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int ANM_VALUE = 0;

	/**
	 * The '<em><b>CER</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>CER</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #CER
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int CER_VALUE = 1;

	/**
	 * The '<em><b>CHEM</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>CHEM</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #CHEM
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int CHEM_VALUE = 2;

	/**
	 * The '<em><b>CITY</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>CITY</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #CITY
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int CITY_VALUE = 3;

	/**
	 * The '<em><b>CONT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>CONT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #CONT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int CONT_VALUE = 4;

	/**
	 * The '<em><b>COUNTRY</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>COUNTRY</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #COUNTRY
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int COUNTRY_VALUE = 5;

	/**
	 * The '<em><b>COUNTY</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>COUNTY</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #COUNTY
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int COUNTY_VALUE = 6;

	/**
	 * The '<em><b>DEV</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>DEV</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #DEV
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int DEV_VALUE = 7;

	/**
	 * The '<em><b>ENT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>ENT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ENT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int ENT_VALUE = 8;

	/**
	 * The '<em><b>FOOD</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>FOOD</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #FOOD
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int FOOD_VALUE = 9;

	/**
	 * The '<em><b>HCE</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>HCE</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #HCE
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int HCE_VALUE = 10;

	/**
	 * The '<em><b>HOLD</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>HOLD</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #HOLD
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int HOLD_VALUE = 11;

	/**
	 * The '<em><b>LIV</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>LIV</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #LIV
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int LIV_VALUE = 12;

	/**
	 * The '<em><b>MAT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>MAT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #MAT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int MAT_VALUE = 13;

	/**
	 * The '<em><b>MIC</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>MIC</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #MIC
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int MIC_VALUE = 14;

	/**
	 * The '<em><b>MMAT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>MMAT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #MMAT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int MMAT_VALUE = 15;

	/**
	 * The '<em><b>MODDV</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>MODDV</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #MODDV
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int MODDV_VALUE = 16;

	/**
	 * The '<em><b>NAT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>NAT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #NAT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int NAT_VALUE = 17;

	/**
	 * The '<em><b>NLIV</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>NLIV</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #NLIV
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int NLIV_VALUE = 18;

	/**
	 * The '<em><b>ORG</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>ORG</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ORG
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int ORG_VALUE = 19;

	/**
	 * The '<em><b>PLC</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>PLC</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #PLC
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int PLC_VALUE = 20;

	/**
	 * The '<em><b>PLNT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>PLNT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #PLNT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int PLNT_VALUE = 21;

	/**
	 * The '<em><b>PROVINCE</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>PROVINCE</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #PROVINCE
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int PROVINCE_VALUE = 22;

	/**
	 * The '<em><b>PSN</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>PSN</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #PSN
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int PSN_VALUE = 23;

	/**
	 * The '<em><b>PUB</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>PUB</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #PUB
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int PUB_VALUE = 24;

	/**
	 * The '<em><b>RGRP</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>RGRP</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #RGRP
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int RGRP_VALUE = 25;

	/**
	 * The '<em><b>STATE</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>STATE</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #STATE
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int STATE_VALUE = 26;

	/**
	 * An array of all the '<em><b>Entity Class Root</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final EntityClassRoot[] VALUES_ARRAY = new EntityClassRoot[] {
			ANM, CER, CHEM, CITY, CONT, COUNTRY, COUNTY, DEV, ENT, FOOD, HCE, HOLD, LIV, MAT, MIC, MMAT, MODDV, NAT,
			NLIV, ORG, PLC, PLNT, PROVINCE, PSN, PUB, RGRP, STATE, };

	/**
	 * A public read-only list of all the '<em><b>Entity Class Root</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<EntityClassRoot> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Entity Class Root</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static EntityClassRoot get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			EntityClassRoot result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Entity Class Root</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static EntityClassRoot getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			EntityClassRoot result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Entity Class Root</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static EntityClassRoot get(int value) {
		switch (value) {
			case ANM_VALUE:
				return ANM;
			case CER_VALUE:
				return CER;
			case CHEM_VALUE:
				return CHEM;
			case CITY_VALUE:
				return CITY;
			case CONT_VALUE:
				return CONT;
			case COUNTRY_VALUE:
				return COUNTRY;
			case COUNTY_VALUE:
				return COUNTY;
			case DEV_VALUE:
				return DEV;
			case ENT_VALUE:
				return ENT;
			case FOOD_VALUE:
				return FOOD;
			case HCE_VALUE:
				return HCE;
			case HOLD_VALUE:
				return HOLD;
			case LIV_VALUE:
				return LIV;
			case MAT_VALUE:
				return MAT;
			case MIC_VALUE:
				return MIC;
			case MMAT_VALUE:
				return MMAT;
			case MODDV_VALUE:
				return MODDV;
			case NAT_VALUE:
				return NAT;
			case NLIV_VALUE:
				return NLIV;
			case ORG_VALUE:
				return ORG;
			case PLC_VALUE:
				return PLC;
			case PLNT_VALUE:
				return PLNT;
			case PROVINCE_VALUE:
				return PROVINCE;
			case PSN_VALUE:
				return PSN;
			case PUB_VALUE:
				return PUB;
			case RGRP_VALUE:
				return RGRP;
			case STATE_VALUE:
				return STATE;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EntityClassRoot(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getValue() {
		return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getLiteral() {
		return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}

} // EntityClassRoot
