/*******************************************************************************
 * Copyright (c) 2009, 2011 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.openhealthtools.mdht.uml.hl7.vocab;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Role Class</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see org.openhealthtools.mdht.uml.hl7.vocab.VocabPackage#getRoleClass()
 * @model
 * @generated
 */
public enum RoleClass implements Enumerator {
	/**
	 * The '<em><b>ACCESS</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ACCESS_VALUE
	 * @generated
	 * @ordered
	 */
	ACCESS(0, "ACCESS", "ACCESS"),

	/**
	 * The '<em><b>ACTI</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ACTI_VALUE
	 * @generated
	 * @ordered
	 */
	ACTI(1, "ACTI", "ACTI"),

	/**
	 * The '<em><b>ACTM</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ACTM_VALUE
	 * @generated
	 * @ordered
	 */
	ACTM(2, "ACTM", "ACTM"),

	/**
	 * The '<em><b>ADTV</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ADTV_VALUE
	 * @generated
	 * @ordered
	 */
	ADTV(3, "ADTV", "ADTV"),

	/**
	 * The '<em><b>AGNT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #AGNT_VALUE
	 * @generated
	 * @ordered
	 */
	AGNT(4, "AGNT", "AGNT"),

	/**
	 * The '<em><b>ALQT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ALQT_VALUE
	 * @generated
	 * @ordered
	 */
	ALQT(5, "ALQT", "ALQT"),

	/**
	 * The '<em><b>ASSIGNED</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ASSIGNED_VALUE
	 * @generated
	 * @ordered
	 */
	ASSIGNED(6, "ASSIGNED", "ASSIGNED"),

	/**
	 * The '<em><b>BASE</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #BASE_VALUE
	 * @generated
	 * @ordered
	 */
	BASE(7, "BASE", "BASE"),

	/**
	 * The '<em><b>BIRTHPL</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #BIRTHPL_VALUE
	 * @generated
	 * @ordered
	 */
	BIRTHPL(8, "BIRTHPL", "BIRTHPL"),

	/**
	 * The '<em><b>CAREGIVER</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #CAREGIVER_VALUE
	 * @generated
	 * @ordered
	 */
	CAREGIVER(9, "CAREGIVER", "CAREGIVER"),

	/**
	 * The '<em><b>CASESBJ</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #CASESBJ_VALUE
	 * @generated
	 * @ordered
	 */
	CASESBJ(10, "CASESBJ", "CASESBJ"), /**
										* The '<em><b>CIT</b></em>' literal object.
										* <!-- begin-user-doc -->
										* <!-- end-user-doc -->
										* @see #CIT_VALUE
										* @generated
										* @ordered
										*/
	CIT(11, "CIT", "CIT"),

	/**
	 * The '<em><b>COLR</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #COLR_VALUE
	 * @generated
	 * @ordered
	 */
	COLR(12, "COLR", "COLR"),

	/**
	 * The '<em><b>COMPAR</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #COMPAR_VALUE
	 * @generated
	 * @ordered
	 */
	COMPAR(13, "COMPAR", "COMPAR"),

	/**
	 * The '<em><b>CON</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #CON_VALUE
	 * @generated
	 * @ordered
	 */
	CON(14, "CON", "CON"),

	/**
	 * The '<em><b>CONT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #CONT_VALUE
	 * @generated
	 * @ordered
	 */
	CONT(15, "CONT", "CONT"),

	/**
	 * The '<em><b>COVPTY</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #COVPTY_VALUE
	 * @generated
	 * @ordered
	 */
	COVPTY(16, "COVPTY", "COVPTY"),

	/**
	 * The '<em><b>CRINV</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #CRINV_VALUE
	 * @generated
	 * @ordered
	 */
	CRINV(17, "CRINV", "CRINV"),

	/**
	 * The '<em><b>CRSPNSR</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #CRSPNSR_VALUE
	 * @generated
	 * @ordered
	 */
	CRSPNSR(18, "CRSPNSR", "CRSPNSR"),

	/**
	 * The '<em><b>DSDLOC</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #DSDLOC_VALUE
	 * @generated
	 * @ordered
	 */
	DSDLOC(19, "DSDLOC", "DSDLOC"),

	/**
	 * The '<em><b>DST</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #DST_VALUE
	 * @generated
	 * @ordered
	 */
	DST(20, "DST", "DST"),

	/**
	 * The '<em><b>ECON</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ECON_VALUE
	 * @generated
	 * @ordered
	 */
	ECON(21, "ECON", "ECON"),

	/**
	 * The '<em><b>EMP</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #EMP_VALUE
	 * @generated
	 * @ordered
	 */
	EMP(22, "EMP", "EMP"),

	/**
	 * The '<em><b>EXPR</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #EXPR_VALUE
	 * @generated
	 * @ordered
	 */
	EXPR(23, "EXPR", "EXPR"),

	/**
	 * The '<em><b>FLVR</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #FLVR_VALUE
	 * @generated
	 * @ordered
	 */
	FLVR(24, "FLVR", "FLVR"),

	/**
	 * The '<em><b>GEN</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #GEN_VALUE
	 * @generated
	 * @ordered
	 */
	GEN(25, "GEN", "GEN"),

	/**
	 * The '<em><b>GRIC</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #GRIC_VALUE
	 * @generated
	 * @ordered
	 */
	GRIC(26, "GRIC", "GRIC"),

	/**
	 * The '<em><b>GUAR</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #GUAR_VALUE
	 * @generated
	 * @ordered
	 */
	GUAR(27, "GUAR", "GUAR"),

	/**
	 * The '<em><b>GUARD</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #GUARD_VALUE
	 * @generated
	 * @ordered
	 */
	GUARD(28, "GUARD", "GUARD"),

	/**
	 * The '<em><b>HLD</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #HLD_VALUE
	 * @generated
	 * @ordered
	 */
	HLD(29, "HLD", "HLD"),

	/**
	 * The '<em><b>HLTHCHRT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #HLTHCHRT_VALUE
	 * @generated
	 * @ordered
	 */
	HLTHCHRT(30, "HLTHCHRT", "HLTHCHRT"),

	/**
	 * The '<em><b>IACT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #IACT_VALUE
	 * @generated
	 * @ordered
	 */
	IACT(31, "IACT", "IACT"),

	/**
	 * The '<em><b>IDENT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #IDENT_VALUE
	 * @generated
	 * @ordered
	 */
	IDENT(32, "IDENT", "IDENT"),

	/**
	 * The '<em><b>INGR</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #INGR_VALUE
	 * @generated
	 * @ordered
	 */
	INGR(33, "INGR", "INGR"),

	/**
	 * The '<em><b>INST</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #INST_VALUE
	 * @generated
	 * @ordered
	 */
	INST(34, "INST", "INST"),

	/**
	 * The '<em><b>INVSBJ</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #INVSBJ_VALUE
	 * @generated
	 * @ordered
	 */
	INVSBJ(35, "INVSBJ", "INVSBJ"),

	/**
	 * The '<em><b>ISDLOC</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ISDLOC_VALUE
	 * @generated
	 * @ordered
	 */
	ISDLOC(36, "ISDLOC", "ISDLOC"),

	/**
	 * The '<em><b>ISLT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ISLT_VALUE
	 * @generated
	 * @ordered
	 */
	ISLT(37, "ISLT", "ISLT"),

	/**
	 * The '<em><b>LIC</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #LIC_VALUE
	 * @generated
	 * @ordered
	 */
	LIC(38, "LIC", "LIC"),

	/**
	 * The '<em><b>LOCE</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #LOCE_VALUE
	 * @generated
	 * @ordered
	 */
	LOCE(39, "LOCE", "LOCE"),

	/**
	 * The '<em><b>MANU</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #MANU_VALUE
	 * @generated
	 * @ordered
	 */
	MANU(40, "MANU", "MANU"),

	/**
	 * The '<em><b>MBR</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #MBR_VALUE
	 * @generated
	 * @ordered
	 */
	MBR(41, "MBR", "MBR"),

	/**
	 * The '<em><b>MIL</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #MIL_VALUE
	 * @generated
	 * @ordered
	 */
	MIL(42, "MIL", "MIL"),

	/**
	 * The '<em><b>MNT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #MNT_VALUE
	 * @generated
	 * @ordered
	 */
	MNT(43, "MNT", "MNT"),

	/**
	 * The '<em><b>NOK</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #NOK_VALUE
	 * @generated
	 * @ordered
	 */
	NOK(44, "NOK", "NOK"),

	/**
	 * The '<em><b>NOT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #NOT_VALUE
	 * @generated
	 * @ordered
	 */
	NOT(45, "NOT", "NOT"),

	/**
	 * The '<em><b>OWN</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #OWN_VALUE
	 * @generated
	 * @ordered
	 */
	OWN(46, "OWN", "OWN"),

	/**
	 * The '<em><b>PART</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PART_VALUE
	 * @generated
	 * @ordered
	 */
	PART(47, "PART", "PART"),

	/**
	 * The '<em><b>PAT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PAT_VALUE
	 * @generated
	 * @ordered
	 */
	PAT(48, "PAT", "PAT"),

	/**
	 * The '<em><b>PAYEE</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PAYEE_VALUE
	 * @generated
	 * @ordered
	 */
	PAYEE(49, "PAYEE", "PAYEE"),

	/**
	 * The '<em><b>PAYOR</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PAYOR_VALUE
	 * @generated
	 * @ordered
	 */
	PAYOR(50, "PAYOR", "PAYOR"),

	/**
	 * The '<em><b>POLHOLD</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #POLHOLD_VALUE
	 * @generated
	 * @ordered
	 */
	POLHOLD(51, "POLHOLD", "POLHOLD"),

	/**
	 * The '<em><b>PROV</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PROV_VALUE
	 * @generated
	 * @ordered
	 */
	PROV(52, "PROV", "PROV"),

	/**
	 * The '<em><b>PRS</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PRS_VALUE
	 * @generated
	 * @ordered
	 */
	PRS(53, "PRS", "PRS"),

	/**
	 * The '<em><b>PRSV</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PRSV_VALUE
	 * @generated
	 * @ordered
	 */
	PRSV(54, "PRSV", "PRSV"),

	/**
	 * The '<em><b>QUAL</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #QUAL_VALUE
	 * @generated
	 * @ordered
	 */
	QUAL(55, "QUAL", "QUAL"),

	/**
	 * The '<em><b>RESBJ</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #RESBJ_VALUE
	 * @generated
	 * @ordered
	 */
	RESBJ(56, "RESBJ", "RESBJ"),

	/**
	 * The '<em><b>RET</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #RET_VALUE
	 * @generated
	 * @ordered
	 */
	RET(57, "RET", "RET"),

	/**
	 * The '<em><b>RGPR</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #RGPR_VALUE
	 * @generated
	 * @ordered
	 */
	RGPR(58, "RGPR", "RGPR"),

	/**
	 * The '<em><b>ROL</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ROL_VALUE
	 * @generated
	 * @ordered
	 */
	ROL(59, "ROL", "ROL"),

	/**
	 * The '<em><b>SDLOC</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SDLOC_VALUE
	 * @generated
	 * @ordered
	 */
	SDLOC(60, "SDLOC", "SDLOC"),

	/**
	 * The '<em><b>SGNOFF</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SGNOFF_VALUE
	 * @generated
	 * @ordered
	 */
	SGNOFF(61, "SGNOFF", "SGNOFF"),

	/**
	 * The '<em><b>SPEC</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SPEC_VALUE
	 * @generated
	 * @ordered
	 */
	SPEC(62, "SPEC", "SPEC"),

	/**
	 * The '<em><b>SPNSR</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SPNSR_VALUE
	 * @generated
	 * @ordered
	 */
	SPNSR(63, "SPNSR", "SPNSR"),

	/**
	 * The '<em><b>STBL</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #STBL_VALUE
	 * @generated
	 * @ordered
	 */
	STBL(64, "STBL", "STBL"),

	/**
	 * The '<em><b>STD</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #STD_VALUE
	 * @generated
	 * @ordered
	 */
	STD(65, "STD", "STD"),

	/**
	 * The '<em><b>STOR</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #STOR_VALUE
	 * @generated
	 * @ordered
	 */
	STOR(66, "STOR", "STOR"),

	/**
	 * The '<em><b>SUBS</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SUBS_VALUE
	 * @generated
	 * @ordered
	 */
	SUBS(67, "SUBS", "SUBS"),

	/**
	 * The '<em><b>SUBY</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SUBY_VALUE
	 * @generated
	 * @ordered
	 */
	SUBY(68, "SUBY", "SUBY"),

	/**
	 * The '<em><b>TERR</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #TERR_VALUE
	 * @generated
	 * @ordered
	 */
	TERR(69, "TERR", "TERR"),

	/**
	 * The '<em><b>THER</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #THER_VALUE
	 * @generated
	 * @ordered
	 */
	THER(70, "THER", "THER"),

	/**
	 * The '<em><b>UNDWRT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #UNDWRT_VALUE
	 * @generated
	 * @ordered
	 */
	UNDWRT(71, "UNDWRT", "UNDWRT"),

	/**
	 * The '<em><b>WRTE</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #WRTE_VALUE
	 * @generated
	 * @ordered
	 */
	WRTE(72, "WRTE", "WRTE");

	/**
	 * The '<em><b>ACCESS</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>ACCESS</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ACCESS
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int ACCESS_VALUE = 0;

	/**
	 * The '<em><b>ACTI</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>ACTI</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ACTI
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int ACTI_VALUE = 1;

	/**
	 * The '<em><b>ACTM</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>ACTM</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ACTM
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int ACTM_VALUE = 2;

	/**
	 * The '<em><b>ADTV</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>ADTV</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ADTV
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int ADTV_VALUE = 3;

	/**
	 * The '<em><b>AGNT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>AGNT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #AGNT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int AGNT_VALUE = 4;

	/**
	 * The '<em><b>ALQT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>ALQT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ALQT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int ALQT_VALUE = 5;

	/**
	 * The '<em><b>ASSIGNED</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>ASSIGNED</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ASSIGNED
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int ASSIGNED_VALUE = 6;

	/**
	 * The '<em><b>BASE</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>BASE</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #BASE
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int BASE_VALUE = 7;

	/**
	 * The '<em><b>BIRTHPL</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>BIRTHPL</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #BIRTHPL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int BIRTHPL_VALUE = 8;

	/**
	 * The '<em><b>CAREGIVER</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>CAREGIVER</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #CAREGIVER
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int CAREGIVER_VALUE = 9;

	/**
	 * The '<em><b>CASESBJ</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>CASESBJ</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #CASESBJ
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int CASESBJ_VALUE = 10;

	/**
	 * The '<em><b>CIT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>CIT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #CIT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int CIT_VALUE = 11;

	/**
	 * The '<em><b>COLR</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>COLR</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #COLR
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int COLR_VALUE = 12;

	/**
	 * The '<em><b>COMPAR</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>COMPAR</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #COMPAR
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int COMPAR_VALUE = 13;

	/**
	 * The '<em><b>CON</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>CON</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #CON
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int CON_VALUE = 14;

	/**
	 * The '<em><b>CONT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>CONT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #CONT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int CONT_VALUE = 15;

	/**
	 * The '<em><b>COVPTY</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>COVPTY</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #COVPTY
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int COVPTY_VALUE = 16;

	/**
	 * The '<em><b>CRINV</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>CRINV</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #CRINV
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int CRINV_VALUE = 17;

	/**
	 * The '<em><b>CRSPNSR</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>CRSPNSR</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #CRSPNSR
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int CRSPNSR_VALUE = 18;

	/**
	 * The '<em><b>DSDLOC</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>DSDLOC</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #DSDLOC
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int DSDLOC_VALUE = 19;

	/**
	 * The '<em><b>DST</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>DST</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #DST
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int DST_VALUE = 20;

	/**
	 * The '<em><b>ECON</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>ECON</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ECON
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int ECON_VALUE = 21;

	/**
	 * The '<em><b>EMP</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>EMP</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #EMP
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int EMP_VALUE = 22;

	/**
	 * The '<em><b>EXPR</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>EXPR</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #EXPR
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int EXPR_VALUE = 23;

	/**
	 * The '<em><b>FLVR</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>FLVR</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #FLVR
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int FLVR_VALUE = 24;

	/**
	 * The '<em><b>GEN</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>GEN</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #GEN
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int GEN_VALUE = 25;

	/**
	 * The '<em><b>GRIC</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>GRIC</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #GRIC
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int GRIC_VALUE = 26;

	/**
	 * The '<em><b>GUAR</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>GUAR</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #GUAR
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int GUAR_VALUE = 27;

	/**
	 * The '<em><b>GUARD</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>GUARD</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #GUARD
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int GUARD_VALUE = 28;

	/**
	 * The '<em><b>HLD</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>HLD</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #HLD
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int HLD_VALUE = 29;

	/**
	 * The '<em><b>HLTHCHRT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>HLTHCHRT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #HLTHCHRT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int HLTHCHRT_VALUE = 30;

	/**
	 * The '<em><b>IACT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>IACT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #IACT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int IACT_VALUE = 31;

	/**
	 * The '<em><b>IDENT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>IDENT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #IDENT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int IDENT_VALUE = 32;

	/**
	 * The '<em><b>INGR</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>INGR</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #INGR
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int INGR_VALUE = 33;

	/**
	 * The '<em><b>INST</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>INST</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #INST
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int INST_VALUE = 34;

	/**
	 * The '<em><b>INVSBJ</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>INVSBJ</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #INVSBJ
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int INVSBJ_VALUE = 35;

	/**
	 * The '<em><b>ISDLOC</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>ISDLOC</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ISDLOC
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int ISDLOC_VALUE = 36;

	/**
	 * The '<em><b>ISLT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>ISLT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ISLT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int ISLT_VALUE = 37;

	/**
	 * The '<em><b>LIC</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>LIC</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #LIC
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int LIC_VALUE = 38;

	/**
	 * The '<em><b>LOCE</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>LOCE</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #LOCE
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int LOCE_VALUE = 39;

	/**
	 * The '<em><b>MANU</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>MANU</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #MANU
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int MANU_VALUE = 40;

	/**
	 * The '<em><b>MBR</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>MBR</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #MBR
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int MBR_VALUE = 41;

	/**
	 * The '<em><b>MIL</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>MIL</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #MIL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int MIL_VALUE = 42;

	/**
	 * The '<em><b>MNT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>MNT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #MNT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int MNT_VALUE = 43;

	/**
	 * The '<em><b>NOK</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>NOK</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #NOK
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int NOK_VALUE = 44;

	/**
	 * The '<em><b>NOT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>NOT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #NOT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int NOT_VALUE = 45;

	/**
	 * The '<em><b>OWN</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>OWN</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #OWN
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int OWN_VALUE = 46;

	/**
	 * The '<em><b>PART</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>PART</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #PART
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int PART_VALUE = 47;

	/**
	 * The '<em><b>PAT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>PAT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #PAT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int PAT_VALUE = 48;

	/**
	 * The '<em><b>PAYEE</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>PAYEE</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #PAYEE
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int PAYEE_VALUE = 49;

	/**
	 * The '<em><b>PAYOR</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>PAYOR</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #PAYOR
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int PAYOR_VALUE = 50;

	/**
	 * The '<em><b>POLHOLD</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>POLHOLD</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #POLHOLD
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int POLHOLD_VALUE = 51;

	/**
	 * The '<em><b>PROV</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>PROV</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #PROV
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int PROV_VALUE = 52;

	/**
	 * The '<em><b>PRS</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>PRS</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #PRS
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int PRS_VALUE = 53;

	/**
	 * The '<em><b>PRSV</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>PRSV</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #PRSV
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int PRSV_VALUE = 54;

	/**
	 * The '<em><b>QUAL</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>QUAL</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #QUAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int QUAL_VALUE = 55;

	/**
	 * The '<em><b>RESBJ</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>RESBJ</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #RESBJ
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int RESBJ_VALUE = 56;

	/**
	 * The '<em><b>RET</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>RET</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #RET
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int RET_VALUE = 57;

	/**
	 * The '<em><b>RGPR</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>RGPR</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #RGPR
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int RGPR_VALUE = 58;

	/**
	 * The '<em><b>ROL</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>ROL</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ROL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int ROL_VALUE = 59;

	/**
	 * The '<em><b>SDLOC</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>SDLOC</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #SDLOC
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int SDLOC_VALUE = 60;

	/**
	 * The '<em><b>SGNOFF</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>SGNOFF</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #SGNOFF
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int SGNOFF_VALUE = 61;

	/**
	 * The '<em><b>SPEC</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>SPEC</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #SPEC
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int SPEC_VALUE = 62;

	/**
	 * The '<em><b>SPNSR</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>SPNSR</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #SPNSR
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int SPNSR_VALUE = 63;

	/**
	 * The '<em><b>STBL</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>STBL</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #STBL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int STBL_VALUE = 64;

	/**
	 * The '<em><b>STD</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>STD</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #STD
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int STD_VALUE = 65;

	/**
	 * The '<em><b>STOR</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>STOR</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #STOR
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int STOR_VALUE = 66;

	/**
	 * The '<em><b>SUBS</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>SUBS</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #SUBS
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int SUBS_VALUE = 67;

	/**
	 * The '<em><b>SUBY</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>SUBY</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #SUBY
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int SUBY_VALUE = 68;

	/**
	 * The '<em><b>TERR</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>TERR</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #TERR
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int TERR_VALUE = 69;

	/**
	 * The '<em><b>THER</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>THER</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #THER
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int THER_VALUE = 70;

	/**
	 * The '<em><b>UNDWRT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>UNDWRT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #UNDWRT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int UNDWRT_VALUE = 71;

	/**
	 * The '<em><b>WRTE</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>WRTE</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #WRTE
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int WRTE_VALUE = 72;

	/**
	 * An array of all the '<em><b>Role Class</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final RoleClass[] VALUES_ARRAY = new RoleClass[] {
			ACCESS, ACTI, ACTM, ADTV, AGNT, ALQT, ASSIGNED, BASE, BIRTHPL, CAREGIVER, CASESBJ, CIT, COLR, COMPAR, CON,
			CONT, COVPTY, CRINV, CRSPNSR, DSDLOC, DST, ECON, EMP, EXPR, FLVR, GEN, GRIC, GUAR, GUARD, HLD, HLTHCHRT,
			IACT, IDENT, INGR, INST, INVSBJ, ISDLOC, ISLT, LIC, LOCE, MANU, MBR, MIL, MNT, NOK, NOT, OWN, PART, PAT,
			PAYEE, PAYOR, POLHOLD, PROV, PRS, PRSV, QUAL, RESBJ, RET, RGPR, ROL, SDLOC, SGNOFF, SPEC, SPNSR, STBL, STD,
			STOR, SUBS, SUBY, TERR, THER, UNDWRT, WRTE, };

	/**
	 * A public read-only list of all the '<em><b>Role Class</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<RoleClass> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Role Class</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static RoleClass get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			RoleClass result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Role Class</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static RoleClass getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			RoleClass result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Role Class</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static RoleClass get(int value) {
		switch (value) {
			case ACCESS_VALUE:
				return ACCESS;
			case ACTI_VALUE:
				return ACTI;
			case ACTM_VALUE:
				return ACTM;
			case ADTV_VALUE:
				return ADTV;
			case AGNT_VALUE:
				return AGNT;
			case ALQT_VALUE:
				return ALQT;
			case ASSIGNED_VALUE:
				return ASSIGNED;
			case BASE_VALUE:
				return BASE;
			case BIRTHPL_VALUE:
				return BIRTHPL;
			case CAREGIVER_VALUE:
				return CAREGIVER;
			case CASESBJ_VALUE:
				return CASESBJ;
			case CIT_VALUE:
				return CIT;
			case COLR_VALUE:
				return COLR;
			case COMPAR_VALUE:
				return COMPAR;
			case CON_VALUE:
				return CON;
			case CONT_VALUE:
				return CONT;
			case COVPTY_VALUE:
				return COVPTY;
			case CRINV_VALUE:
				return CRINV;
			case CRSPNSR_VALUE:
				return CRSPNSR;
			case DSDLOC_VALUE:
				return DSDLOC;
			case DST_VALUE:
				return DST;
			case ECON_VALUE:
				return ECON;
			case EMP_VALUE:
				return EMP;
			case EXPR_VALUE:
				return EXPR;
			case FLVR_VALUE:
				return FLVR;
			case GEN_VALUE:
				return GEN;
			case GRIC_VALUE:
				return GRIC;
			case GUAR_VALUE:
				return GUAR;
			case GUARD_VALUE:
				return GUARD;
			case HLD_VALUE:
				return HLD;
			case HLTHCHRT_VALUE:
				return HLTHCHRT;
			case IACT_VALUE:
				return IACT;
			case IDENT_VALUE:
				return IDENT;
			case INGR_VALUE:
				return INGR;
			case INST_VALUE:
				return INST;
			case INVSBJ_VALUE:
				return INVSBJ;
			case ISDLOC_VALUE:
				return ISDLOC;
			case ISLT_VALUE:
				return ISLT;
			case LIC_VALUE:
				return LIC;
			case LOCE_VALUE:
				return LOCE;
			case MANU_VALUE:
				return MANU;
			case MBR_VALUE:
				return MBR;
			case MIL_VALUE:
				return MIL;
			case MNT_VALUE:
				return MNT;
			case NOK_VALUE:
				return NOK;
			case NOT_VALUE:
				return NOT;
			case OWN_VALUE:
				return OWN;
			case PART_VALUE:
				return PART;
			case PAT_VALUE:
				return PAT;
			case PAYEE_VALUE:
				return PAYEE;
			case PAYOR_VALUE:
				return PAYOR;
			case POLHOLD_VALUE:
				return POLHOLD;
			case PROV_VALUE:
				return PROV;
			case PRS_VALUE:
				return PRS;
			case PRSV_VALUE:
				return PRSV;
			case QUAL_VALUE:
				return QUAL;
			case RESBJ_VALUE:
				return RESBJ;
			case RET_VALUE:
				return RET;
			case RGPR_VALUE:
				return RGPR;
			case ROL_VALUE:
				return ROL;
			case SDLOC_VALUE:
				return SDLOC;
			case SGNOFF_VALUE:
				return SGNOFF;
			case SPEC_VALUE:
				return SPEC;
			case SPNSR_VALUE:
				return SPNSR;
			case STBL_VALUE:
				return STBL;
			case STD_VALUE:
				return STD;
			case STOR_VALUE:
				return STOR;
			case SUBS_VALUE:
				return SUBS;
			case SUBY_VALUE:
				return SUBY;
			case TERR_VALUE:
				return TERR;
			case THER_VALUE:
				return THER;
			case UNDWRT_VALUE:
				return UNDWRT;
			case WRTE_VALUE:
				return WRTE;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private RoleClass(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getValue() {
		return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getLiteral() {
		return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}

} // RoleClass
