/*******************************************************************************
 * Copyright (c) 2009, 2011 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.openhealthtools.mdht.uml.hl7.vocab;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Role Class Associative</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see org.openhealthtools.mdht.uml.hl7.vocab.VocabPackage#getRoleClassAssociative()
 * @model
 * @generated
 */
public enum RoleClassAssociative implements Enumerator {
	/**
	 * The '<em><b>ACCESS</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ACCESS_VALUE
	 * @generated
	 * @ordered
	 */
	ACCESS(0, "ACCESS", "ACCESS"),

	/**
	 * The '<em><b>AGNT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #AGNT_VALUE
	 * @generated
	 * @ordered
	 */
	AGNT(1, "AGNT", "AGNT"),

	/**
	 * The '<em><b>ASSIGNED</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ASSIGNED_VALUE
	 * @generated
	 * @ordered
	 */
	ASSIGNED(2, "ASSIGNED", "ASSIGNED"),

	/**
	 * The '<em><b>BIRTHPL</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #BIRTHPL_VALUE
	 * @generated
	 * @ordered
	 */
	BIRTHPL(3, "BIRTHPL", "BIRTHPL"),

	/**
	 * The '<em><b>CAREGIVER</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #CAREGIVER_VALUE
	 * @generated
	 * @ordered
	 */
	CAREGIVER(4, "CAREGIVER", "CAREGIVER"),

	/**
	 * The '<em><b>CASESBJ</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #CASESBJ_VALUE
	 * @generated
	 * @ordered
	 */
	CASESBJ(5, "CASESBJ", "CASESBJ"), /**
										* The '<em><b>CIT</b></em>' literal object.
										* <!-- begin-user-doc -->
										* <!-- end-user-doc -->
										* @see #CIT_VALUE
										* @generated
										* @ordered
										*/
	CIT(6, "CIT", "CIT"),

	/**
	 * The '<em><b>COMPAR</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #COMPAR_VALUE
	 * @generated
	 * @ordered
	 */
	COMPAR(7, "COMPAR", "COMPAR"),

	/**
	 * The '<em><b>CON</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #CON_VALUE
	 * @generated
	 * @ordered
	 */
	CON(8, "CON", "CON"),

	/**
	 * The '<em><b>COVPTY</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #COVPTY_VALUE
	 * @generated
	 * @ordered
	 */
	COVPTY(9, "COVPTY", "COVPTY"),

	/**
	 * The '<em><b>CRINV</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #CRINV_VALUE
	 * @generated
	 * @ordered
	 */
	CRINV(10, "CRINV", "CRINV"),

	/**
	 * The '<em><b>CRSPNSR</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #CRSPNSR_VALUE
	 * @generated
	 * @ordered
	 */
	CRSPNSR(11, "CRSPNSR", "CRSPNSR"),

	/**
	 * The '<em><b>DSDLOC</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #DSDLOC_VALUE
	 * @generated
	 * @ordered
	 */
	DSDLOC(12, "DSDLOC", "DSDLOC"),

	/**
	 * The '<em><b>DST</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #DST_VALUE
	 * @generated
	 * @ordered
	 */
	DST(13, "DST", "DST"),

	/**
	 * The '<em><b>ECON</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ECON_VALUE
	 * @generated
	 * @ordered
	 */
	ECON(14, "ECON", "ECON"),

	/**
	 * The '<em><b>EMP</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #EMP_VALUE
	 * @generated
	 * @ordered
	 */
	EMP(15, "EMP", "EMP"),

	/**
	 * The '<em><b>EXPR</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #EXPR_VALUE
	 * @generated
	 * @ordered
	 */
	EXPR(16, "EXPR", "EXPR"),

	/**
	 * The '<em><b>GUAR</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #GUAR_VALUE
	 * @generated
	 * @ordered
	 */
	GUAR(17, "GUAR", "GUAR"),

	/**
	 * The '<em><b>GUARD</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #GUARD_VALUE
	 * @generated
	 * @ordered
	 */
	GUARD(18, "GUARD", "GUARD"),

	/**
	 * The '<em><b>HLD</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #HLD_VALUE
	 * @generated
	 * @ordered
	 */
	HLD(19, "HLD", "HLD"),

	/**
	 * The '<em><b>HLTHCHRT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #HLTHCHRT_VALUE
	 * @generated
	 * @ordered
	 */
	HLTHCHRT(20, "HLTHCHRT", "HLTHCHRT"),

	/**
	 * The '<em><b>IDENT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #IDENT_VALUE
	 * @generated
	 * @ordered
	 */
	IDENT(21, "IDENT", "IDENT"),

	/**
	 * The '<em><b>INVSBJ</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #INVSBJ_VALUE
	 * @generated
	 * @ordered
	 */
	INVSBJ(22, "INVSBJ", "INVSBJ"),

	/**
	 * The '<em><b>ISDLOC</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ISDLOC_VALUE
	 * @generated
	 * @ordered
	 */
	ISDLOC(23, "ISDLOC", "ISDLOC"),

	/**
	 * The '<em><b>LIC</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #LIC_VALUE
	 * @generated
	 * @ordered
	 */
	LIC(24, "LIC", "LIC"),

	/**
	 * The '<em><b>MANU</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #MANU_VALUE
	 * @generated
	 * @ordered
	 */
	MANU(25, "MANU", "MANU"),

	/**
	 * The '<em><b>MIL</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #MIL_VALUE
	 * @generated
	 * @ordered
	 */
	MIL(26, "MIL", "MIL"),

	/**
	 * The '<em><b>MNT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #MNT_VALUE
	 * @generated
	 * @ordered
	 */
	MNT(27, "MNT", "MNT"),

	/**
	 * The '<em><b>NOK</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #NOK_VALUE
	 * @generated
	 * @ordered
	 */
	NOK(28, "NOK", "NOK"),

	/**
	 * The '<em><b>NOT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #NOT_VALUE
	 * @generated
	 * @ordered
	 */
	NOT(29, "NOT", "NOT"),

	/**
	 * The '<em><b>OWN</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #OWN_VALUE
	 * @generated
	 * @ordered
	 */
	OWN(30, "OWN", "OWN"),

	/**
	 * The '<em><b>PAT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PAT_VALUE
	 * @generated
	 * @ordered
	 */
	PAT(31, "PAT", "PAT"),

	/**
	 * The '<em><b>PAYEE</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PAYEE_VALUE
	 * @generated
	 * @ordered
	 */
	PAYEE(32, "PAYEE", "PAYEE"),

	/**
	 * The '<em><b>PAYOR</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PAYOR_VALUE
	 * @generated
	 * @ordered
	 */
	PAYOR(33, "PAYOR", "PAYOR"),

	/**
	 * The '<em><b>POLHOLD</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #POLHOLD_VALUE
	 * @generated
	 * @ordered
	 */
	POLHOLD(34, "POLHOLD", "POLHOLD"),

	/**
	 * The '<em><b>PROV</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PROV_VALUE
	 * @generated
	 * @ordered
	 */
	PROV(35, "PROV", "PROV"),

	/**
	 * The '<em><b>PRS</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PRS_VALUE
	 * @generated
	 * @ordered
	 */
	PRS(36, "PRS", "PRS"),

	/**
	 * The '<em><b>QUAL</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #QUAL_VALUE
	 * @generated
	 * @ordered
	 */
	QUAL(37, "QUAL", "QUAL"),

	/**
	 * The '<em><b>RESBJ</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #RESBJ_VALUE
	 * @generated
	 * @ordered
	 */
	RESBJ(38, "RESBJ", "RESBJ"),

	/**
	 * The '<em><b>RET</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #RET_VALUE
	 * @generated
	 * @ordered
	 */
	RET(39, "RET", "RET"),

	/**
	 * The '<em><b>RGPR</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #RGPR_VALUE
	 * @generated
	 * @ordered
	 */
	RGPR(40, "RGPR", "RGPR"),

	/**
	 * The '<em><b>SDLOC</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SDLOC_VALUE
	 * @generated
	 * @ordered
	 */
	SDLOC(41, "SDLOC", "SDLOC"),

	/**
	 * The '<em><b>SGNOFF</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SGNOFF_VALUE
	 * @generated
	 * @ordered
	 */
	SGNOFF(42, "SGNOFF", "SGNOFF"),

	/**
	 * The '<em><b>SPNSR</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SPNSR_VALUE
	 * @generated
	 * @ordered
	 */
	SPNSR(43, "SPNSR", "SPNSR"),

	/**
	 * The '<em><b>STD</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #STD_VALUE
	 * @generated
	 * @ordered
	 */
	STD(44, "STD", "STD"),

	/**
	 * The '<em><b>TERR</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #TERR_VALUE
	 * @generated
	 * @ordered
	 */
	TERR(45, "TERR", "TERR"),

	/**
	 * The '<em><b>THER</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #THER_VALUE
	 * @generated
	 * @ordered
	 */
	THER(46, "THER", "THER"),

	/**
	 * The '<em><b>UNDWRT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #UNDWRT_VALUE
	 * @generated
	 * @ordered
	 */
	UNDWRT(47, "UNDWRT", "UNDWRT"),

	/**
	 * The '<em><b>WRTE</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #WRTE_VALUE
	 * @generated
	 * @ordered
	 */
	WRTE(48, "WRTE", "WRTE");

	/**
	 * The '<em><b>ACCESS</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>ACCESS</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ACCESS
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int ACCESS_VALUE = 0;

	/**
	 * The '<em><b>AGNT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>AGNT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #AGNT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int AGNT_VALUE = 1;

	/**
	 * The '<em><b>ASSIGNED</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>ASSIGNED</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ASSIGNED
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int ASSIGNED_VALUE = 2;

	/**
	 * The '<em><b>BIRTHPL</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>BIRTHPL</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #BIRTHPL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int BIRTHPL_VALUE = 3;

	/**
	 * The '<em><b>CAREGIVER</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>CAREGIVER</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #CAREGIVER
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int CAREGIVER_VALUE = 4;

	/**
	 * The '<em><b>CASESBJ</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>CASESBJ</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #CASESBJ
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int CASESBJ_VALUE = 5;

	/**
	 * The '<em><b>CIT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>CIT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #CIT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int CIT_VALUE = 6;

	/**
	 * The '<em><b>COMPAR</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>COMPAR</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #COMPAR
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int COMPAR_VALUE = 7;

	/**
	 * The '<em><b>CON</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>CON</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #CON
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int CON_VALUE = 8;

	/**
	 * The '<em><b>COVPTY</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>COVPTY</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #COVPTY
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int COVPTY_VALUE = 9;

	/**
	 * The '<em><b>CRINV</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>CRINV</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #CRINV
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int CRINV_VALUE = 10;

	/**
	 * The '<em><b>CRSPNSR</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>CRSPNSR</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #CRSPNSR
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int CRSPNSR_VALUE = 11;

	/**
	 * The '<em><b>DSDLOC</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>DSDLOC</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #DSDLOC
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int DSDLOC_VALUE = 12;

	/**
	 * The '<em><b>DST</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>DST</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #DST
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int DST_VALUE = 13;

	/**
	 * The '<em><b>ECON</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>ECON</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ECON
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int ECON_VALUE = 14;

	/**
	 * The '<em><b>EMP</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>EMP</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #EMP
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int EMP_VALUE = 15;

	/**
	 * The '<em><b>EXPR</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>EXPR</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #EXPR
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int EXPR_VALUE = 16;

	/**
	 * The '<em><b>GUAR</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>GUAR</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #GUAR
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int GUAR_VALUE = 17;

	/**
	 * The '<em><b>GUARD</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>GUARD</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #GUARD
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int GUARD_VALUE = 18;

	/**
	 * The '<em><b>HLD</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>HLD</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #HLD
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int HLD_VALUE = 19;

	/**
	 * The '<em><b>HLTHCHRT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>HLTHCHRT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #HLTHCHRT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int HLTHCHRT_VALUE = 20;

	/**
	 * The '<em><b>IDENT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>IDENT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #IDENT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int IDENT_VALUE = 21;

	/**
	 * The '<em><b>INVSBJ</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>INVSBJ</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #INVSBJ
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int INVSBJ_VALUE = 22;

	/**
	 * The '<em><b>ISDLOC</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>ISDLOC</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ISDLOC
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int ISDLOC_VALUE = 23;

	/**
	 * The '<em><b>LIC</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>LIC</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #LIC
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int LIC_VALUE = 24;

	/**
	 * The '<em><b>MANU</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>MANU</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #MANU
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int MANU_VALUE = 25;

	/**
	 * The '<em><b>MIL</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>MIL</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #MIL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int MIL_VALUE = 26;

	/**
	 * The '<em><b>MNT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>MNT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #MNT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int MNT_VALUE = 27;

	/**
	 * The '<em><b>NOK</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>NOK</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #NOK
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int NOK_VALUE = 28;

	/**
	 * The '<em><b>NOT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>NOT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #NOT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int NOT_VALUE = 29;

	/**
	 * The '<em><b>OWN</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>OWN</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #OWN
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int OWN_VALUE = 30;

	/**
	 * The '<em><b>PAT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>PAT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #PAT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int PAT_VALUE = 31;

	/**
	 * The '<em><b>PAYEE</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>PAYEE</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #PAYEE
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int PAYEE_VALUE = 32;

	/**
	 * The '<em><b>PAYOR</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>PAYOR</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #PAYOR
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int PAYOR_VALUE = 33;

	/**
	 * The '<em><b>POLHOLD</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>POLHOLD</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #POLHOLD
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int POLHOLD_VALUE = 34;

	/**
	 * The '<em><b>PROV</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>PROV</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #PROV
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int PROV_VALUE = 35;

	/**
	 * The '<em><b>PRS</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>PRS</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #PRS
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int PRS_VALUE = 36;

	/**
	 * The '<em><b>QUAL</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>QUAL</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #QUAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int QUAL_VALUE = 37;

	/**
	 * The '<em><b>RESBJ</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>RESBJ</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #RESBJ
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int RESBJ_VALUE = 38;

	/**
	 * The '<em><b>RET</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>RET</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #RET
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int RET_VALUE = 39;

	/**
	 * The '<em><b>RGPR</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>RGPR</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #RGPR
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int RGPR_VALUE = 40;

	/**
	 * The '<em><b>SDLOC</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>SDLOC</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #SDLOC
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int SDLOC_VALUE = 41;

	/**
	 * The '<em><b>SGNOFF</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>SGNOFF</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #SGNOFF
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int SGNOFF_VALUE = 42;

	/**
	 * The '<em><b>SPNSR</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>SPNSR</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #SPNSR
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int SPNSR_VALUE = 43;

	/**
	 * The '<em><b>STD</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>STD</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #STD
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int STD_VALUE = 44;

	/**
	 * The '<em><b>TERR</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>TERR</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #TERR
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int TERR_VALUE = 45;

	/**
	 * The '<em><b>THER</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>THER</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #THER
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int THER_VALUE = 46;

	/**
	 * The '<em><b>UNDWRT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>UNDWRT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #UNDWRT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int UNDWRT_VALUE = 47;

	/**
	 * The '<em><b>WRTE</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>WRTE</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #WRTE
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int WRTE_VALUE = 48;

	/**
	 * An array of all the '<em><b>Role Class Associative</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final RoleClassAssociative[] VALUES_ARRAY = new RoleClassAssociative[] {
			ACCESS, AGNT, ASSIGNED, BIRTHPL, CAREGIVER, CASESBJ, CIT, COMPAR, CON, COVPTY, CRINV, CRSPNSR, DSDLOC, DST,
			ECON, EMP, EXPR, GUAR, GUARD, HLD, HLTHCHRT, IDENT, INVSBJ, ISDLOC, LIC, MANU, MIL, MNT, NOK, NOT, OWN,
			PAT, PAYEE, PAYOR, POLHOLD, PROV, PRS, QUAL, RESBJ, RET, RGPR, SDLOC, SGNOFF, SPNSR, STD, TERR, THER,
			UNDWRT, WRTE, };

	/**
	 * A public read-only list of all the '<em><b>Role Class Associative</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<RoleClassAssociative> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Role Class Associative</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static RoleClassAssociative get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			RoleClassAssociative result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Role Class Associative</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static RoleClassAssociative getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			RoleClassAssociative result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Role Class Associative</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static RoleClassAssociative get(int value) {
		switch (value) {
			case ACCESS_VALUE:
				return ACCESS;
			case AGNT_VALUE:
				return AGNT;
			case ASSIGNED_VALUE:
				return ASSIGNED;
			case BIRTHPL_VALUE:
				return BIRTHPL;
			case CAREGIVER_VALUE:
				return CAREGIVER;
			case CASESBJ_VALUE:
				return CASESBJ;
			case CIT_VALUE:
				return CIT;
			case COMPAR_VALUE:
				return COMPAR;
			case CON_VALUE:
				return CON;
			case COVPTY_VALUE:
				return COVPTY;
			case CRINV_VALUE:
				return CRINV;
			case CRSPNSR_VALUE:
				return CRSPNSR;
			case DSDLOC_VALUE:
				return DSDLOC;
			case DST_VALUE:
				return DST;
			case ECON_VALUE:
				return ECON;
			case EMP_VALUE:
				return EMP;
			case EXPR_VALUE:
				return EXPR;
			case GUAR_VALUE:
				return GUAR;
			case GUARD_VALUE:
				return GUARD;
			case HLD_VALUE:
				return HLD;
			case HLTHCHRT_VALUE:
				return HLTHCHRT;
			case IDENT_VALUE:
				return IDENT;
			case INVSBJ_VALUE:
				return INVSBJ;
			case ISDLOC_VALUE:
				return ISDLOC;
			case LIC_VALUE:
				return LIC;
			case MANU_VALUE:
				return MANU;
			case MIL_VALUE:
				return MIL;
			case MNT_VALUE:
				return MNT;
			case NOK_VALUE:
				return NOK;
			case NOT_VALUE:
				return NOT;
			case OWN_VALUE:
				return OWN;
			case PAT_VALUE:
				return PAT;
			case PAYEE_VALUE:
				return PAYEE;
			case PAYOR_VALUE:
				return PAYOR;
			case POLHOLD_VALUE:
				return POLHOLD;
			case PROV_VALUE:
				return PROV;
			case PRS_VALUE:
				return PRS;
			case QUAL_VALUE:
				return QUAL;
			case RESBJ_VALUE:
				return RESBJ;
			case RET_VALUE:
				return RET;
			case RGPR_VALUE:
				return RGPR;
			case SDLOC_VALUE:
				return SDLOC;
			case SGNOFF_VALUE:
				return SGNOFF;
			case SPNSR_VALUE:
				return SPNSR;
			case STD_VALUE:
				return STD;
			case TERR_VALUE:
				return TERR;
			case THER_VALUE:
				return THER;
			case UNDWRT_VALUE:
				return UNDWRT;
			case WRTE_VALUE:
				return WRTE;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private RoleClassAssociative(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getValue() {
		return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getLiteral() {
		return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}

} // RoleClassAssociative
