/*******************************************************************************
 * Copyright (c) 2009, 2011 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.openhealthtools.mdht.uml.hl7.vocab;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Role Class Mutual Relationship</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see org.openhealthtools.mdht.uml.hl7.vocab.VocabPackage#getRoleClassMutualRelationship()
 * @model
 * @generated
 */
public enum RoleClassMutualRelationship implements Enumerator {
	/**
	 * The '<em><b>AGNT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #AGNT_VALUE
	 * @generated
	 * @ordered
	 */
	AGNT(0, "AGNT", "AGNT"),

	/**
	 * The '<em><b>ASSIGNED</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ASSIGNED_VALUE
	 * @generated
	 * @ordered
	 */
	ASSIGNED(1, "ASSIGNED", "ASSIGNED"),

	/**
	 * The '<em><b>CAREGIVER</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #CAREGIVER_VALUE
	 * @generated
	 * @ordered
	 */
	CAREGIVER(2, "CAREGIVER", "CAREGIVER"),

	/**
	 * The '<em><b>CASESBJ</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #CASESBJ_VALUE
	 * @generated
	 * @ordered
	 */
	CASESBJ(3, "CASESBJ", "CASESBJ"), /**
										* The '<em><b>CIT</b></em>' literal object.
										* <!-- begin-user-doc -->
										* <!-- end-user-doc -->
										* @see #CIT_VALUE
										* @generated
										* @ordered
										*/
	CIT(4, "CIT", "CIT"),

	/**
	 * The '<em><b>COMPAR</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #COMPAR_VALUE
	 * @generated
	 * @ordered
	 */
	COMPAR(5, "COMPAR", "COMPAR"),

	/**
	 * The '<em><b>CON</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #CON_VALUE
	 * @generated
	 * @ordered
	 */
	CON(6, "CON", "CON"),

	/**
	 * The '<em><b>COVPTY</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #COVPTY_VALUE
	 * @generated
	 * @ordered
	 */
	COVPTY(7, "COVPTY", "COVPTY"),

	/**
	 * The '<em><b>CRINV</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #CRINV_VALUE
	 * @generated
	 * @ordered
	 */
	CRINV(8, "CRINV", "CRINV"),

	/**
	 * The '<em><b>CRSPNSR</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #CRSPNSR_VALUE
	 * @generated
	 * @ordered
	 */
	CRSPNSR(9, "CRSPNSR", "CRSPNSR"),

	/**
	 * The '<em><b>ECON</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ECON_VALUE
	 * @generated
	 * @ordered
	 */
	ECON(10, "ECON", "ECON"),

	/**
	 * The '<em><b>EMP</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #EMP_VALUE
	 * @generated
	 * @ordered
	 */
	EMP(11, "EMP", "EMP"),

	/**
	 * The '<em><b>GUAR</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #GUAR_VALUE
	 * @generated
	 * @ordered
	 */
	GUAR(12, "GUAR", "GUAR"),

	/**
	 * The '<em><b>GUARD</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #GUARD_VALUE
	 * @generated
	 * @ordered
	 */
	GUARD(13, "GUARD", "GUARD"),

	/**
	 * The '<em><b>INVSBJ</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #INVSBJ_VALUE
	 * @generated
	 * @ordered
	 */
	INVSBJ(14, "INVSBJ", "INVSBJ"),

	/**
	 * The '<em><b>LIC</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #LIC_VALUE
	 * @generated
	 * @ordered
	 */
	LIC(15, "LIC", "LIC"),

	/**
	 * The '<em><b>MIL</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #MIL_VALUE
	 * @generated
	 * @ordered
	 */
	MIL(16, "MIL", "MIL"),

	/**
	 * The '<em><b>NOK</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #NOK_VALUE
	 * @generated
	 * @ordered
	 */
	NOK(17, "NOK", "NOK"),

	/**
	 * The '<em><b>NOT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #NOT_VALUE
	 * @generated
	 * @ordered
	 */
	NOT(18, "NOT", "NOT"),

	/**
	 * The '<em><b>PAT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PAT_VALUE
	 * @generated
	 * @ordered
	 */
	PAT(19, "PAT", "PAT"),

	/**
	 * The '<em><b>PAYEE</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PAYEE_VALUE
	 * @generated
	 * @ordered
	 */
	PAYEE(20, "PAYEE", "PAYEE"),

	/**
	 * The '<em><b>PAYOR</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PAYOR_VALUE
	 * @generated
	 * @ordered
	 */
	PAYOR(21, "PAYOR", "PAYOR"),

	/**
	 * The '<em><b>POLHOLD</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #POLHOLD_VALUE
	 * @generated
	 * @ordered
	 */
	POLHOLD(22, "POLHOLD", "POLHOLD"),

	/**
	 * The '<em><b>PROV</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PROV_VALUE
	 * @generated
	 * @ordered
	 */
	PROV(23, "PROV", "PROV"),

	/**
	 * The '<em><b>PRS</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PRS_VALUE
	 * @generated
	 * @ordered
	 */
	PRS(24, "PRS", "PRS"),

	/**
	 * The '<em><b>QUAL</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #QUAL_VALUE
	 * @generated
	 * @ordered
	 */
	QUAL(25, "QUAL", "QUAL"),

	/**
	 * The '<em><b>RESBJ</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #RESBJ_VALUE
	 * @generated
	 * @ordered
	 */
	RESBJ(26, "RESBJ", "RESBJ"),

	/**
	 * The '<em><b>SGNOFF</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SGNOFF_VALUE
	 * @generated
	 * @ordered
	 */
	SGNOFF(27, "SGNOFF", "SGNOFF"),

	/**
	 * The '<em><b>SPNSR</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SPNSR_VALUE
	 * @generated
	 * @ordered
	 */
	SPNSR(28, "SPNSR", "SPNSR"),

	/**
	 * The '<em><b>STD</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #STD_VALUE
	 * @generated
	 * @ordered
	 */
	STD(29, "STD", "STD"),

	/**
	 * The '<em><b>UNDWRT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #UNDWRT_VALUE
	 * @generated
	 * @ordered
	 */
	UNDWRT(30, "UNDWRT", "UNDWRT");

	/**
	 * The '<em><b>AGNT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>AGNT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #AGNT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int AGNT_VALUE = 0;

	/**
	 * The '<em><b>ASSIGNED</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>ASSIGNED</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ASSIGNED
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int ASSIGNED_VALUE = 1;

	/**
	 * The '<em><b>CAREGIVER</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>CAREGIVER</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #CAREGIVER
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int CAREGIVER_VALUE = 2;

	/**
	 * The '<em><b>CASESBJ</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>CASESBJ</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #CASESBJ
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int CASESBJ_VALUE = 3;

	/**
	 * The '<em><b>CIT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>CIT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #CIT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int CIT_VALUE = 4;

	/**
	 * The '<em><b>COMPAR</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>COMPAR</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #COMPAR
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int COMPAR_VALUE = 5;

	/**
	 * The '<em><b>CON</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>CON</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #CON
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int CON_VALUE = 6;

	/**
	 * The '<em><b>COVPTY</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>COVPTY</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #COVPTY
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int COVPTY_VALUE = 7;

	/**
	 * The '<em><b>CRINV</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>CRINV</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #CRINV
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int CRINV_VALUE = 8;

	/**
	 * The '<em><b>CRSPNSR</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>CRSPNSR</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #CRSPNSR
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int CRSPNSR_VALUE = 9;

	/**
	 * The '<em><b>ECON</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>ECON</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ECON
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int ECON_VALUE = 10;

	/**
	 * The '<em><b>EMP</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>EMP</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #EMP
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int EMP_VALUE = 11;

	/**
	 * The '<em><b>GUAR</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>GUAR</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #GUAR
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int GUAR_VALUE = 12;

	/**
	 * The '<em><b>GUARD</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>GUARD</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #GUARD
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int GUARD_VALUE = 13;

	/**
	 * The '<em><b>INVSBJ</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>INVSBJ</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #INVSBJ
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int INVSBJ_VALUE = 14;

	/**
	 * The '<em><b>LIC</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>LIC</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #LIC
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int LIC_VALUE = 15;

	/**
	 * The '<em><b>MIL</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>MIL</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #MIL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int MIL_VALUE = 16;

	/**
	 * The '<em><b>NOK</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>NOK</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #NOK
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int NOK_VALUE = 17;

	/**
	 * The '<em><b>NOT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>NOT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #NOT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int NOT_VALUE = 18;

	/**
	 * The '<em><b>PAT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>PAT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #PAT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int PAT_VALUE = 19;

	/**
	 * The '<em><b>PAYEE</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>PAYEE</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #PAYEE
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int PAYEE_VALUE = 20;

	/**
	 * The '<em><b>PAYOR</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>PAYOR</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #PAYOR
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int PAYOR_VALUE = 21;

	/**
	 * The '<em><b>POLHOLD</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>POLHOLD</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #POLHOLD
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int POLHOLD_VALUE = 22;

	/**
	 * The '<em><b>PROV</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>PROV</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #PROV
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int PROV_VALUE = 23;

	/**
	 * The '<em><b>PRS</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>PRS</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #PRS
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int PRS_VALUE = 24;

	/**
	 * The '<em><b>QUAL</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>QUAL</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #QUAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int QUAL_VALUE = 25;

	/**
	 * The '<em><b>RESBJ</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>RESBJ</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #RESBJ
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int RESBJ_VALUE = 26;

	/**
	 * The '<em><b>SGNOFF</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>SGNOFF</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #SGNOFF
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int SGNOFF_VALUE = 27;

	/**
	 * The '<em><b>SPNSR</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>SPNSR</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #SPNSR
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int SPNSR_VALUE = 28;

	/**
	 * The '<em><b>STD</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>STD</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #STD
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int STD_VALUE = 29;

	/**
	 * The '<em><b>UNDWRT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>UNDWRT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #UNDWRT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int UNDWRT_VALUE = 30;

	/**
	 * An array of all the '<em><b>Role Class Mutual Relationship</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final RoleClassMutualRelationship[] VALUES_ARRAY = new RoleClassMutualRelationship[] {
			AGNT, ASSIGNED, CAREGIVER, CASESBJ, CIT, COMPAR, CON, COVPTY, CRINV, CRSPNSR, ECON, EMP, GUAR, GUARD,
			INVSBJ, LIC, MIL, NOK, NOT, PAT, PAYEE, PAYOR, POLHOLD, PROV, PRS, QUAL, RESBJ, SGNOFF, SPNSR, STD, UNDWRT, };

	/**
	 * A public read-only list of all the '<em><b>Role Class Mutual Relationship</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<RoleClassMutualRelationship> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Role Class Mutual Relationship</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static RoleClassMutualRelationship get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			RoleClassMutualRelationship result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Role Class Mutual Relationship</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static RoleClassMutualRelationship getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			RoleClassMutualRelationship result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Role Class Mutual Relationship</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static RoleClassMutualRelationship get(int value) {
		switch (value) {
			case AGNT_VALUE:
				return AGNT;
			case ASSIGNED_VALUE:
				return ASSIGNED;
			case CAREGIVER_VALUE:
				return CAREGIVER;
			case CASESBJ_VALUE:
				return CASESBJ;
			case CIT_VALUE:
				return CIT;
			case COMPAR_VALUE:
				return COMPAR;
			case CON_VALUE:
				return CON;
			case COVPTY_VALUE:
				return COVPTY;
			case CRINV_VALUE:
				return CRINV;
			case CRSPNSR_VALUE:
				return CRSPNSR;
			case ECON_VALUE:
				return ECON;
			case EMP_VALUE:
				return EMP;
			case GUAR_VALUE:
				return GUAR;
			case GUARD_VALUE:
				return GUARD;
			case INVSBJ_VALUE:
				return INVSBJ;
			case LIC_VALUE:
				return LIC;
			case MIL_VALUE:
				return MIL;
			case NOK_VALUE:
				return NOK;
			case NOT_VALUE:
				return NOT;
			case PAT_VALUE:
				return PAT;
			case PAYEE_VALUE:
				return PAYEE;
			case PAYOR_VALUE:
				return PAYOR;
			case POLHOLD_VALUE:
				return POLHOLD;
			case PROV_VALUE:
				return PROV;
			case PRS_VALUE:
				return PRS;
			case QUAL_VALUE:
				return QUAL;
			case RESBJ_VALUE:
				return RESBJ;
			case SGNOFF_VALUE:
				return SGNOFF;
			case SPNSR_VALUE:
				return SPNSR;
			case STD_VALUE:
				return STD;
			case UNDWRT_VALUE:
				return UNDWRT;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private RoleClassMutualRelationship(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getValue() {
		return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getLiteral() {
		return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}

} // RoleClassMutualRelationship
