/*******************************************************************************
 * Copyright (c) 2009, 2011 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.openhealthtools.mdht.uml.hl7.vocab;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>xAct Class Document Entry Act</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see org.openhealthtools.mdht.uml.hl7.vocab.VocabPackage#getx_ActClassDocumentEntryAct()
 * @model
 * @generated
 */
public enum x_ActClassDocumentEntryAct implements Enumerator {
	/**
	 * The '<em><b>ACCM</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ACCM_VALUE
	 * @generated
	 * @ordered
	 */
	ACCM(0, "ACCM", "ACCM"),

	/**
	 * The '<em><b>ACT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ACT_VALUE
	 * @generated
	 * @ordered
	 */
	ACT(1, "ACT", "ACT"),

	/**
	 * The '<em><b>CONS</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #CONS_VALUE
	 * @generated
	 * @ordered
	 */
	CONS(2, "CONS", "CONS"),

	/**
	 * The '<em><b>CTTEVENT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #CTTEVENT_VALUE
	 * @generated
	 * @ordered
	 */
	CTTEVENT(3, "CTTEVENT", "CTTEVENT"),

	/**
	 * The '<em><b>INC</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #INC_VALUE
	 * @generated
	 * @ordered
	 */
	INC(4, "INC", "INC"),

	/**
	 * The '<em><b>INFRM</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #INFRM_VALUE
	 * @generated
	 * @ordered
	 */
	INFRM(5, "INFRM", "INFRM"),

	/**
	 * The '<em><b>PCPR</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PCPR_VALUE
	 * @generated
	 * @ordered
	 */
	PCPR(6, "PCPR", "PCPR"),

	/**
	 * The '<em><b>REG</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #REG_VALUE
	 * @generated
	 * @ordered
	 */
	REG(7, "REG", "REG"),

	/**
	 * The '<em><b>SPCTRT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SPCTRT_VALUE
	 * @generated
	 * @ordered
	 */
	SPCTRT(8, "SPCTRT", "SPCTRT");

	/**
	 * The '<em><b>ACCM</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>ACCM</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ACCM
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int ACCM_VALUE = 0;

	/**
	 * The '<em><b>ACT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>ACT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ACT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int ACT_VALUE = 1;

	/**
	 * The '<em><b>CONS</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>CONS</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #CONS
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int CONS_VALUE = 2;

	/**
	 * The '<em><b>CTTEVENT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>CTTEVENT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #CTTEVENT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int CTTEVENT_VALUE = 3;

	/**
	 * The '<em><b>INC</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>INC</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #INC
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int INC_VALUE = 4;

	/**
	 * The '<em><b>INFRM</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>INFRM</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #INFRM
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int INFRM_VALUE = 5;

	/**
	 * The '<em><b>PCPR</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>PCPR</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #PCPR
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int PCPR_VALUE = 6;

	/**
	 * The '<em><b>REG</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>REG</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #REG
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int REG_VALUE = 7;

	/**
	 * The '<em><b>SPCTRT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>SPCTRT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #SPCTRT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int SPCTRT_VALUE = 8;

	/**
	 * An array of all the '<em><b>xAct Class Document Entry Act</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final x_ActClassDocumentEntryAct[] VALUES_ARRAY = new x_ActClassDocumentEntryAct[] {
			ACCM, ACT, CONS, CTTEVENT, INC, INFRM, PCPR, REG, SPCTRT, };

	/**
	 * A public read-only list of all the '<em><b>xAct Class Document Entry Act</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<x_ActClassDocumentEntryAct> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>xAct Class Document Entry Act</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static x_ActClassDocumentEntryAct get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			x_ActClassDocumentEntryAct result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>xAct Class Document Entry Act</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static x_ActClassDocumentEntryAct getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			x_ActClassDocumentEntryAct result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>xAct Class Document Entry Act</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static x_ActClassDocumentEntryAct get(int value) {
		switch (value) {
			case ACCM_VALUE:
				return ACCM;
			case ACT_VALUE:
				return ACT;
			case CONS_VALUE:
				return CONS;
			case CTTEVENT_VALUE:
				return CTTEVENT;
			case INC_VALUE:
				return INC;
			case INFRM_VALUE:
				return INFRM;
			case PCPR_VALUE:
				return PCPR;
			case REG_VALUE:
				return REG;
			case SPCTRT_VALUE:
				return SPCTRT;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private x_ActClassDocumentEntryAct(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getValue() {
		return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getLiteral() {
		return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}

} // x_ActClassDocumentEntryAct
