/*
 * Decompiled with CFR 0.152.
 */
package org.openehr.am.template;

import java.math.BigInteger;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import openEHR.v1.template.ACTION;
import openEHR.v1.template.ADMINENTRY;
import openEHR.v1.template.Archetyped;
import openEHR.v1.template.COMPOSITION;
import openEHR.v1.template.ContentItem;
import openEHR.v1.template.ENTRY;
import openEHR.v1.template.EVALUATION;
import openEHR.v1.template.INSTRUCTION;
import openEHR.v1.template.ITEM;
import openEHR.v1.template.ITEMSTRUCTURE;
import openEHR.v1.template.MultipleConstraint;
import openEHR.v1.template.OBSERVATION;
import openEHR.v1.template.QuantityConstraint;
import openEHR.v1.template.QuantityUnitConstraint;
import openEHR.v1.template.SECTION;
import openEHR.v1.template.Statement;
import openEHR.v1.template.TEMPLATE;
import openEHR.v1.template.TextConstraint;
import openEHR.v1.template.ValueConstraint;
import org.apache.log4j.Logger;
import org.openehr.am.archetype.Archetype;
import org.openehr.am.archetype.constraintmodel.ArchetypeConstraint;
import org.openehr.am.archetype.constraintmodel.ArchetypeSlot;
import org.openehr.am.archetype.constraintmodel.CAttribute;
import org.openehr.am.archetype.constraintmodel.CComplexObject;
import org.openehr.am.archetype.constraintmodel.CMultipleAttribute;
import org.openehr.am.archetype.constraintmodel.CObject;
import org.openehr.am.archetype.constraintmodel.CPrimitiveObject;
import org.openehr.am.archetype.constraintmodel.CSingleAttribute;
import org.openehr.am.archetype.constraintmodel.Cardinality;
import org.openehr.am.archetype.constraintmodel.primitive.CPrimitive;
import org.openehr.am.archetype.constraintmodel.primitive.CString;
import org.openehr.am.openehrprofile.datatypes.quantity.CDvQuantity;
import org.openehr.am.openehrprofile.datatypes.quantity.CDvQuantityItem;
import org.openehr.am.openehrprofile.datatypes.text.CCodePhrase;
import org.openehr.am.template.FlatteningException;
import org.openehr.am.template.TermMap;
import org.openehr.am.template.UnknownArchetypeException;
import org.openehr.am.template.UnknownTemplateException;
import org.openehr.rm.common.archetyped.Locatable;
import org.openehr.rm.datatypes.text.CodePhrase;
import org.openehr.rm.support.basic.Interval;

public class Flattener {
    private static final String DV_TEXT = "DV_TEXT";
    private static final String DV_CODED_TEXT = "DV_CODED_TEXT";
    private static final String ELEMENT = "ELEMENT";
    private static final String NAME = "name";
    private static final String VALUE = "value";
    private static final String ITEMS = "items";
    private static final String CONTENT = "content";
    private static final String DESCRIPTION = "description";
    private static final String DEFINING_CODE = "defining_code";
    private static final String AT = "at";
    private static final String DATA_TYPES_PREFIX = "DV_";
    private static DecimalFormat format = new DecimalFormat("####");
    private static Logger log;
    private Map<String, Archetype> archetypeMap = new HashMap<String, Archetype>();
    private Map<String, TEMPLATE> templateMap;
    private TermMap termMap = new TermMap();
    private long nodeCount;

    public Archetype toFlattenedArchetype(TEMPLATE template, Map<String, Archetype> archetypeMap) throws FlatteningException {
        return this.toFlattenedArchetype(template, archetypeMap, new HashMap<String, TEMPLATE>());
    }

    public Archetype toFlattenedArchetype(TEMPLATE template, Map<String, Archetype> archetypeMap, Map<String, TEMPLATE> templateMap) throws FlatteningException {
        if (archetypeMap == null) {
            throw new FlatteningException("null archetypeMap");
        }
        this.archetypeMap.clear();
        for (Map.Entry<String, Archetype> entry : archetypeMap.entrySet()) {
            Archetype a = entry.getValue();
            if (a == null) continue;
            a = a.copy();
            this.archetypeMap.put(entry.getKey(), a);
        }
        this.templateMap = templateMap;
        log.debug((Object)("Loaded archetype/template maps, total archetypes: " + archetypeMap.size() + ", total templates: " + (templateMap == null ? 0 : templateMap.size())));
        return this.toFlattenedArchetype(template);
    }

    private Archetype toFlattenedArchetype(TEMPLATE template) throws FlatteningException {
        log.debug((Object)"Flattening template.. STARTED");
        Archetyped definition = template.getDefinition();
        Archetype flattended = this.flattenArchetyped(definition);
        flattended.reloadNodeMaps();
        log.debug((Object)"Flattening template DONE");
        return flattended;
    }

    private Archetype flattenArchetyped(Archetyped definition) throws FlatteningException {
        log.debug((Object)("flattening archetyped on archetype: " + definition.getArchetypeId()));
        if (definition instanceof COMPOSITION) {
            return this.flattenComposition((COMPOSITION)definition);
        }
        if (definition instanceof ITEMSTRUCTURE) {
            return this.flattenItemStructure(null, (ITEMSTRUCTURE)definition);
        }
        if (definition instanceof ContentItem) {
            return this.flattenContentItem(null, (ContentItem)definition);
        }
        if (definition instanceof ITEM) {
            return this.flattenItem(null, (ITEM)definition);
        }
        throw new FlatteningException("Unkown archetyped sub-type");
    }

    private Archetype flattenItem(Archetype parentArchetype, ITEM item) throws FlatteningException {
        String aid = parentArchetype == null ? "null" : parentArchetype.getArchetypeId().toString();
        log.debug((Object)("flattening item on parentArchetype " + aid + " at path " + item.getPath()));
        Archetype archetype = this.retrieveArchetype(item.getArchetypeId());
        this.applyTemplateConstraints(archetype, item);
        this.fillArchetypeSlot(parentArchetype, archetype, item.getPath(), item.getName());
        return archetype;
    }

    private Archetype flattenComposition(COMPOSITION composition) throws FlatteningException {
        log.debug((Object)("flattening composition on archetype: " + composition.getArchetypeId()));
        Archetype archetype = this.retrieveArchetype(composition.getArchetypeId());
        CComplexObject root = archetype.getDefinition();
        CAttribute contentAttribute = root.getAttribute(CONTENT);
        this.removeArchetypeSlots(contentAttribute);
        ContentItem[] items = composition.getContentArray();
        if (items != null && items.length > 0) {
            String path = "/content";
            if (contentAttribute == null) {
                ArrayList alternatives = new ArrayList();
                contentAttribute = new CMultipleAttribute(path, CONTENT, CAttribute.Existence.OPTIONAL, Cardinality.LIST, alternatives);
                archetype.getDefinition().addAttribute(contentAttribute);
            }
            for (ContentItem item : items) {
                log.debug((Object)"flattening composition.content..");
                this.flattenContentItem(archetype, item);
            }
        }
        this.applyRules(archetype, composition.getRuleArray());
        this.applyNameConstraint(archetype, (ArchetypeConstraint)archetype.getDefinition(), composition.getName(), "/");
        return archetype;
    }

    private Archetype flattenContentItem(Archetype parentArchetype, ContentItem definition) throws FlatteningException {
        log.debug((Object)("flattening content_item on archetype: " + definition.getArchetypeId() + " on path: " + definition.getPath()));
        Archetype archetype = null;
        String templateId = definition.getTemplateId();
        if (templateId == null) {
            archetype = this.retrieveArchetype(definition.getArchetypeId());
        } else {
            TEMPLATE template = this.retrieveTemplate(templateId);
            archetype = this.toFlattenedArchetype(template);
        }
        this.applyTemplateConstraints(archetype, definition);
        if (definition instanceof ENTRY) {
            this.flattenEntry(parentArchetype, archetype, (ENTRY)definition);
        } else if (definition instanceof SECTION) {
            this.flattenSection(parentArchetype, archetype, (SECTION)definition);
        } else {
            throw new FlatteningException("Unexpected subtype of ContentItem: " + definition);
        }
        return archetype;
    }

    private void applyTemplateConstraints(Archetype archetype, Archetyped definition) throws FlatteningException {
        log.debug((Object)"applying common template constraints.. ");
        if (archetype == null) {
            return;
        }
        String name = null;
        Statement[] rules = null;
        BigInteger max = null;
        BigInteger min = null;
        boolean hideOnForm = false;
        String annotation = null;
        if (definition instanceof ContentItem) {
            ContentItem item = (ContentItem)definition;
            name = item.getName();
            rules = item.getRuleArray();
            max = item.getMax();
            min = item.getMin();
            hideOnForm = item.getHideOnForm();
            annotation = item.getAnnotation();
        } else if (definition instanceof ITEMSTRUCTURE) {
            ITEMSTRUCTURE item = (ITEMSTRUCTURE)definition;
            name = item.getName();
            rules = item.getRuleArray();
            max = item.getMax();
            min = item.getMin();
            hideOnForm = item.getHideOnForm();
            annotation = item.getAnnotation();
        } else if (definition instanceof ITEM) {
            ITEM item = (ITEM)definition;
            name = item.getName();
            rules = item.getRuleArray();
            max = item.getMax();
            min = item.getMin();
            hideOnForm = item.getHideOnForm();
            annotation = item.getAnnotation();
        } else {
            log.warn((Object)("unsupported definition type: " + definition));
        }
        this.applyNameConstraint(archetype, (ArchetypeConstraint)archetype.getDefinition(), name, "/");
        this.applyRules(archetype, rules);
        this.applyOccurrencesConstraint(archetype, (CObject)archetype.getDefinition(), max, min);
        this.applyHideOnFormConstraint((ArchetypeConstraint)archetype.getDefinition(), hideOnForm);
        this.applyAnnotationConstraint((ArchetypeConstraint)archetype.getDefinition(), annotation);
    }

    private void setPathPrefixOnCObjectTree(CObject cobj, String prefix) throws FlatteningException {
        if (cobj == null) {
            log.warn((Object)("null cobj encountered at setPathPrefix(): " + prefix));
            return;
        }
        String path = cobj.path();
        path = "/".equals(path) ? prefix : prefix + path;
        cobj.setPath(path);
        if (path.endsWith(VALUE)) {
            // empty if block
        }
        if (cobj instanceof CComplexObject) {
            CComplexObject ccobj = (CComplexObject)cobj;
            for (CAttribute cattr : ccobj.getAttributes()) {
                path = cattr.path();
                cattr.setPath(prefix + path);
                Iterator it = cattr.getChildren().iterator();
                while (it.hasNext()) {
                    CObject child = (CObject)it.next();
                    if (child == null) {
                        it.remove();
                        log.warn((Object)"null child encountered remove in setPathPrefix()..");
                    }
                    this.setPathPrefixOnCObjectTree(child, prefix);
                }
            }
        }
    }

    private void updatePathWithNamedNodeOnCObjectTree(CObject cobj, String nodeId, String name) throws FlatteningException {
        if (cobj == null) {
            log.warn((Object)("null cobj in updatePathWithNamedNodeOnCObjectTree(): " + nodeId + "/" + name));
            return;
        }
        String path = cobj.path();
        path = this.replaceNodeIdWithNamedNode(path, nodeId, name);
        cobj.setPath(path);
        if (cobj instanceof CComplexObject) {
            CComplexObject ccobj = (CComplexObject)cobj;
            for (CAttribute cattr : ccobj.getAttributes()) {
                path = cattr.path();
                path = this.replaceNodeIdWithNamedNode(path, nodeId, name);
                cattr.setPath(path);
                Iterator it = cattr.getChildren().iterator();
                while (it.hasNext()) {
                    CObject child = (CObject)it.next();
                    if (child == null) {
                        it.remove();
                        log.warn((Object)"null child encountered remove in setPathPrefix()..");
                    }
                    this.updatePathWithNamedNodeOnCObjectTree(child, nodeId, name);
                }
            }
        }
    }

    private String replaceNodeIdWithNamedNode(String path, String nodeId, String name) {
        return path.replaceFirst("\\[" + nodeId + "\\]", "\\[" + this.namedNodeSegment(nodeId, name) + "\\]");
    }

    private String namedNodeSegment(String nodeId, String name) {
        return nodeId + " and name/value='" + name + "'";
    }

    private Archetype flattenSection(Archetype parentArchetype, Archetype archetype, SECTION section) throws FlatteningException {
        log.debug((Object)("flattening section on archetype " + section.getArchetypeId() + " at path " + section.getPath()));
        ContentItem[] items = section.getItemArray();
        String path = section.getPath();
        CComplexObject root = archetype.getDefinition();
        this.fillArchetypeSlot(parentArchetype, archetype, path, section.getName());
        CAttribute itemsAttribute = root.getAttribute(ITEMS);
        if (items != null && items.length > 0) {
            if (itemsAttribute == null) {
                path = parentArchetype == null ? "" : root.path();
                path = path + "/items";
                ArrayList alternatives = new ArrayList();
                itemsAttribute = new CMultipleAttribute(path, ITEMS, CAttribute.Existence.OPTIONAL, Cardinality.LIST, alternatives);
                root.addAttribute(itemsAttribute);
            }
            for (ContentItem item : items) {
                log.debug((Object)"flattening section.items.. ");
                this.flattenContentItem(archetype, item);
            }
        }
        return archetype;
    }

    private void checkSiblingNodeIdAndName(CAttribute parent, String nodeId, String name) throws FlatteningException {
        for (CObject cobj : parent.getChildren()) {
            if (!nodeId.equals(cobj.path()) || !name.equals(cobj.getNodeId())) continue;
            throw new FlatteningException("duplicated node_id/name: " + nodeId + "/" + name + "at path: " + parent.path());
        }
    }

    private int countChildOfArchetypeId(CAttribute cattr, String archetypeId) {
        int count = 0;
        for (CObject cobj : cattr.getChildren()) {
            String nodeId = cobj.getNodeId();
            if (nodeId == null || !nodeId.startsWith(archetypeId)) continue;
            ++count;
        }
        return count;
    }

    protected long adjustNodeIds(CObject cobj, long count) throws FlatteningException {
        if (cobj.getNodeId() != null) {
            cobj.setNodeId(this.formatNodeId(++count));
        }
        if (cobj instanceof CComplexObject) {
            for (CAttribute attr : ((CComplexObject)cobj).getAttributes()) {
                for (CObject child : attr.getChildren()) {
                    count = this.adjustNodeIds(child, count);
                }
            }
        }
        return count;
    }

    protected void adjustNodeIds(CObject root) throws FlatteningException {
        this.nodeCount = this.adjustNodeIds(root, this.nodeCount);
    }

    private String lastAttribute(String path) {
        int i = path.lastIndexOf("/");
        String attr = path.substring(i + 1, path.length());
        if ((i = attr.indexOf("[")) >= 0) {
            attr = attr.substring(0, i);
        }
        log.debug((Object)("attribute name: " + attr));
        return attr;
    }

    private Archetype flattenEntry(Archetype parentArchetype, Archetype archetype, ENTRY definition) throws FlatteningException {
        log.debug((Object)("flattening entry on archetype: " + definition.getArchetypeId() + ", path: " + definition.getPath()));
        String path = definition.getPath();
        this.fillArchetypeSlot(parentArchetype, archetype, path, definition.getName());
        ENTRY entry = definition;
        ITEM[] items = entry.getItemsArray();
        if (items != null) {
            for (ITEM item : items) {
                this.flattenItem(archetype, item);
            }
        }
        if (!(definition instanceof EVALUATION) && !(definition instanceof OBSERVATION)) {
            if (definition instanceof ACTION) {
                ACTION action = (ACTION)definition;
                ITEMSTRUCTURE description = action.getDescription();
                if (description != null) {
                    this.flattenItemStructure(archetype, description);
                }
            } else if (definition instanceof INSTRUCTION) {
                this.flattenInstruction(parentArchetype, archetype, (INSTRUCTION)definition);
            } else if (definition instanceof ADMINENTRY) {
                // empty if block
            }
        }
        return archetype;
    }

    private void fillArchetypeSlot(Archetype parentArchetype, Archetype archetype, String path, String name) throws FlatteningException {
        String archetypeId = archetype.getArchetypeId().toString();
        CComplexObject root = archetype.getDefinition();
        if (parentArchetype != null) {
            CAttribute attribute;
            int hybridStart = path.indexOf(" and name/value='");
            if (hybridStart > 0) {
                int i = path.indexOf("]");
                path = path.substring(0, hybridStart) + path.substring(i);
                log.debug((Object)("hybrid path detected, converted physical path: " + path));
            }
            if ((attribute = this.getParentAttribute(parentArchetype, path)) == null) {
                throw new FlatteningException("CAttribute not found at " + path);
            }
            this.removeArchetypeSlots(attribute);
            root.setNodeId(archetypeId);
            String pathSegment = archetypeId;
            if (name != null) {
                this.checkSiblingNodeIdAndName(attribute, archetypeId, name);
                pathSegment = this.namedNodeSegment(archetypeId, name);
            }
            this.setPathPrefixOnCObjectTree((CObject)root, attribute.path() + "[" + pathSegment + "]");
            attribute.addChild((CObject)root);
        }
    }

    private CAttribute getParentAttribute(Archetype archetype, String path) throws FlatteningException {
        String parentPath = Locatable.parentPath((String)path);
        ArchetypeConstraint ac = archetype.node(parentPath);
        if (!(ac instanceof CComplexObject)) {
            throw new FlatteningException("Parent node not found at " + path + ", computed parentPath: " + parentPath);
        }
        CComplexObject parentNode = (CComplexObject)ac;
        String attributeName = this.lastAttribute(path);
        CAttribute attribute = parentNode.getAttribute(attributeName);
        return attribute;
    }

    private void flattenInstruction(Archetype parentArchetype, Archetype archetype, INSTRUCTION instruction) throws FlatteningException {
        log.debug((Object)("flattening instruction on archetype: " + instruction.getArchetypeId() + ", path: " + instruction.getPath()));
        ITEMSTRUCTURE[] descriptions = instruction.getActivityDescriptionArray();
        if (descriptions != null) {
            for (ITEMSTRUCTURE item : descriptions) {
                this.flattenItemStructure(archetype, item);
            }
        }
    }

    private void removeArchetypeSlots(CAttribute cattr) {
        if (cattr == null) {
            return;
        }
        Iterator it = cattr.getChildren().iterator();
        while (it.hasNext()) {
            CObject cobj = (CObject)it.next();
            if (!(cobj instanceof ArchetypeSlot)) continue;
            it.remove();
            log.debug((Object)("archetype_slot removed from attribute " + cattr.getRmAttributeName()));
        }
    }

    private Archetype flattenItemStructure(Archetype parentArchetype, ITEMSTRUCTURE structure) throws FlatteningException {
        log.debug((Object)("flattening item_structure on archetype: " + structure.getArchetypeId() + " on path: " + structure.getPath()));
        Archetype archetype = this.retrieveArchetype(structure.getArchetypeId());
        this.applyTemplateConstraints(archetype, structure);
        this.fillArchetypeSlot(parentArchetype, archetype, structure.getPath(), structure.getName());
        ITEM[] items = structure.getItemsArray();
        if (items != null) {
            for (ITEM item : items) {
                this.flattenItem(archetype, item);
            }
        }
        return archetype;
    }

    void applyRules(Archetype archetype, Statement[] rules) throws FlatteningException {
        if (rules == null) {
            return;
        }
        String name = null;
        String leadingPath = null;
        for (Statement rule : rules) {
            if (rule.getName() == null) continue;
            if (name == null) {
                name = rule.getName();
                leadingPath = rule.getPath();
                continue;
            }
            if (!rule.getPath().equals(leadingPath)) continue;
            log.debug((Object)("more than one named node [" + name + "] on path: " + leadingPath));
            name = null;
            break;
        }
        for (Statement rule : rules) {
            if (name != null && rule.getPath().startsWith(leadingPath) && rule.getPath().length() > leadingPath.length()) {
                int len = leadingPath.length();
                String path = rule.getPath();
                path = path.substring(0, len - 1) + " and name/value='" + name + "'" + path.substring(len - 1);
                rule.setPath(path);
                log.debug((Object)("rewrote path with named node: " + path));
            }
            this.applyRule(archetype, rule);
        }
    }

    void applyRule(Archetype archetype, Statement rule) throws FlatteningException {
        log.debug((Object)("apply rule [" + rule + "] on archetype: " + archetype.getArchetypeId().toString()));
        String path = rule.getPath();
        ArchetypeConstraint constraint = archetype.node(rule.getPath());
        if (constraint == null) {
            throw new FlatteningException("no constraint on path: " + path + " of " + archetype.getArchetypeId());
        }
        constraint = this.applyNameConstraint(archetype, constraint, rule.getName(), path);
        this.applyOccurrencesConstraints(archetype, constraint, rule);
        this.applyDefaultValueConstraint(constraint, rule.getDefault());
        this.applyHideOnFormConstraint(constraint, rule.getHideOnForm());
        this.applyAnnotationConstraint(constraint, rule.getAnnotation());
        this.applyValueConstraint(archetype, constraint, rule);
        archetype.updatePathNodeMap((CObject)constraint);
    }

    protected void applyHideOnFormConstraint(ArchetypeConstraint constraint, boolean hideOnForm) {
    }

    protected void applyAnnotationConstraint(ArchetypeConstraint constraint, String annotation) {
        if (annotation == null || annotation.length() == 0) {
            return;
        }
        constraint.setAnnotation(annotation);
    }

    protected void applyDefaultValueConstraint(ArchetypeConstraint constraint, String defaultValue) throws FlatteningException {
        String path;
        CComplexObject childCCObj;
        String rmType;
        CObject child;
        if (defaultValue == null) {
            return;
        }
        log.debug((Object)("applying default value on path: " + constraint.path()));
        if (!(constraint instanceof CComplexObject)) {
            throw new FlatteningException("failed to apply default constraint,unexpected constraint node: " + constraint.getClass());
        }
        CComplexObject ccobj = (CComplexObject)constraint;
        if (!ccobj.getRmTypeName().equalsIgnoreCase(ELEMENT)) {
            throw new FlatteningException("failed to apply default constraint,unexpected rmType[" + ccobj.getRmTypeName() + "] on node: " + ccobj.path());
        }
        CAttribute cattr = ccobj.getAttribute(VALUE);
        if (cattr == null) {
            cattr = new CSingleAttribute(ccobj.path() + "/" + VALUE, VALUE, CAttribute.Existence.REQUIRED);
        } else if (cattr.getChildren().size() == 1 && (child = (CObject)cattr.getChildren().get(0)) instanceof CComplexObject && (DV_TEXT.equals(rmType = (childCCObj = (CComplexObject)child).getRmTypeName()) || DV_CODED_TEXT.equals(rmType))) {
            cattr.removeChild(child);
        }
        Interval occurrences = new Interval((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(1));
        if (defaultValue.indexOf("::") < 0) {
            path = cattr.path() + "/" + VALUE;
            CComplexObject valueObj = CComplexObject.createSingleRequired((String)path, (String)DV_TEXT);
            CSingleAttribute valueAttr = CSingleAttribute.createRequired((String)path, (String)VALUE);
            cattr.addChild((CObject)valueObj);
            valueObj.addAttribute((CAttribute)valueAttr);
            CString cstring = new CString(null, null, null, defaultValue);
            CPrimitiveObject cpo = CPrimitiveObject.createSingleRequired((String)path, (CPrimitive)cstring);
            valueAttr.addChild((CObject)cpo);
            log.debug((Object)("c_string applied on path: " + constraint.path()));
        } else {
            path = ccobj.path() + "/" + VALUE;
            CodePhrase codePhrase = this.parseCodePhraseAndCollectText(defaultValue, path);
            CCodePhrase ccp = new CCodePhrase(path, occurrences, null, cattr, null, null, codePhrase, null);
            cattr.addChild((CObject)ccp);
            log.debug((Object)("c_code_phrase constraint applied on path: " + constraint.path()));
        }
    }

    protected void applyOccurrencesConstraints(Archetype archetype, ArchetypeConstraint constraint, Statement rule) throws FlatteningException {
        BigInteger max = rule.getMax();
        BigInteger min = rule.getMin();
        if ((max != null || min != null) && constraint instanceof CObject) {
            this.applyOccurrencesConstraint(archetype, (CObject)constraint, rule.getMax(), rule.getMin());
        }
    }

    protected void applyOccurrencesConstraint(Archetype archetype, CObject cobj, BigInteger max, BigInteger min) throws FlatteningException {
        log.debug((Object)("applyOccurrencesConstraint, min: " + min + ", max: " + max + ", at: " + cobj.path()));
        if (!cobj.isRoot()) {
            // empty if block
        }
        String path = cobj.path();
        Interval occurrences = cobj.getOccurrences();
        if (!"/".equals(path) && occurrences == null) {
            log.warn((Object)("try to set occurrences constraint on default(null) occurrences: " + cobj.path()));
            return;
        }
        if (max != null && occurrences.getUpper() != null && max.intValue() > (Integer)occurrences.getUpper()) {
            throw new FlatteningException("more permissive max occurrences, " + path);
        }
        if (max != null && occurrences.getLower() != null && max.intValue() < (Integer)occurrences.getLower()) {
            throw new FlatteningException("contradicting max occurrences [max: " + max.intValue() + ", occurrences.lower: " + (Integer)occurrences.getLower() + "] at path: " + path);
        }
        if (min != null && occurrences.getLower() != null && min.intValue() < (Integer)occurrences.getLower()) {
            throw new FlatteningException("more permissive min occurrences, " + path);
        }
        if (min != null && occurrences.getUpper() != null && min.intValue() > (Integer)occurrences.getUpper()) {
            throw new FlatteningException("contradicting min occurrences, " + path);
        }
        if (!"/".equals(path) && occurrences.getUpper() != null && occurrences.getLower() != null && (Integer)occurrences.getUpper() == 1 && (Integer)occurrences.getLower() == 1) {
            log.warn((Object)("try to set occurrences constraint on required node: " + cobj.path()));
            return;
        }
        if (min == null && max != null) {
            min = BigInteger.valueOf(0L);
        }
        Integer lower = null;
        Integer upper = null;
        if (occurrences != null) {
            lower = (Integer)occurrences.getLower();
            upper = (Integer)occurrences.getUpper();
        }
        if (min != null) {
            lower = min.intValue();
            if (upper != null && lower > upper) {
                upper = lower;
            }
        }
        if (max != null) {
            upper = max.intValue();
            if (lower != null && lower > upper) {
                lower = upper;
            }
        }
        Interval newOccurrences = new Interval((Comparable)lower, (Comparable)upper, lower != null, upper != null);
        log.debug((Object)("newOccurrences: " + newOccurrences));
        if (newOccurrences.getLower() != null && (Integer)newOccurrences.getLower() > 0 && !"/".equals(path)) {
            CAttribute parent = this.getParentAttribute(archetype, path);
            if (parent instanceof CMultipleAttribute) {
                CMultipleAttribute cma = (CMultipleAttribute)parent;
                log.debug((Object)("setting parent.cardinality: " + cma.getCardinality()));
                cma.getCardinality().getInterval().setLower(newOccurrences.getLower());
                log.debug((Object)("AFTER parent.cardinality: " + cma.getCardinality()));
            } else if (parent == null) {
                log.debug((Object)("parent null at " + cobj.path()));
            }
        }
        cobj.setOccurrences(newOccurrences);
    }

    protected CComplexObject applyNameConstraint(Archetype archetype, ArchetypeConstraint constraint, String name, String localPath) throws FlatteningException {
        log.debug((Object)("applying name constraint [" + name + "] on path: " + localPath + "constraint: " + constraint.path()));
        assert (constraint instanceof CComplexObject);
        CComplexObject ccobj = (CComplexObject)constraint;
        if (name == null) {
            return ccobj;
        }
        String path = localPath;
        if (!"/".equals(path)) {
            CAttribute parent = this.getParentAttribute(archetype, path);
            assert (parent != null);
            if (this.hasSiblingNodeWithNodeId(parent, ccobj.getNodeId())) {
                this.removeUnnamedSiblingNode(archetype, parent, ccobj.getNodeId());
                ccobj = (CComplexObject)ccobj.copy();
                parent.addChild((CObject)ccobj);
                ccobj.setParent(parent);
                this.checkSiblingNodeIdAndName(parent, ccobj.getNodeId(), name);
                log.debug((Object)("sibling node with same node_id added, " + name));
            }
        }
        path = ccobj.path();
        log.debug((Object)("applyNameConstraint - middle ccobj.path: " + ccobj.path()));
        CAttribute nameAttr = ccobj.getAttribute(NAME);
        CPrimitiveObject cpo = null;
        if (nameAttr == null) {
            CString cstring = this.cString(name);
            path = "/".equals(path) ? path + NAME : path + "/" + NAME;
            CComplexObject nameObj = CComplexObject.createSingleRequired((String)path, (String)DV_TEXT);
            nameAttr = CSingleAttribute.createRequired((String)path, (String)NAME);
            nameAttr.addChild((CObject)nameObj);
            path = path + "/" + VALUE;
            CSingleAttribute valueAttr = CSingleAttribute.createRequired((String)path, (String)VALUE);
            nameObj.addAttribute((CAttribute)valueAttr);
            cpo = CPrimitiveObject.createSingleRequired((String)path, (CPrimitive)cstring);
            valueAttr.addChild((CObject)cpo);
        }
        ccobj.addAttribute(nameAttr);
        this.updatePathWithNamedNodeOnCObjectTree((CObject)ccobj, ccobj.getNodeId(), name);
        archetype.updatePathNodeMapRecursively((CObject)ccobj);
        log.debug((Object)("after setting name, cobj.path: " + ccobj.path()));
        return ccobj;
    }

    private void removeUnnamedSiblingNode(Archetype archetype, CAttribute parent, String nodeId) throws FlatteningException {
        Iterator it = parent.getChildren().iterator();
        while (it.hasNext()) {
            CObject cobj = (CObject)it.next();
            if (!nodeId.equals(cobj.getNodeId())) continue;
            if (!(cobj instanceof CComplexObject)) {
                throw new FlatteningException("unexpected constraint type: " + cobj.getClass() + " for node_id[" + nodeId + "] at " + parent.path());
            }
            CComplexObject ccobj = (CComplexObject)cobj;
            if (ccobj.hasAttribute(NAME)) continue;
            it.remove();
            log.debug((Object)("Unnamed sibling node[" + nodeId + "] removed.."));
            break;
        }
    }

    private boolean isHybridPath(String path) {
        return path.indexOf(" and name") > 0;
    }

    protected void __applyNameConstraint(ArchetypeConstraint constraint, String name) throws FlatteningException {
    }

    private boolean hasSiblingNodeWithNodeId(CAttribute parent, String nodeId) {
        for (CObject cobj : parent.getChildren()) {
            if (!nodeId.equals(cobj.getNodeId())) continue;
            return true;
        }
        return false;
    }

    protected void applyValueConstraint(Archetype archetype, ArchetypeConstraint constraint, Statement rule) throws FlatteningException {
        ValueConstraint tc;
        if (rule.getConstraint() == null) {
            return;
        }
        log.debug((Object)("applying value constraint on path: " + constraint.path()));
        if (!(constraint instanceof CComplexObject)) {
            throw new FlatteningException("Unexpected constraint type: " + constraint.getClass());
        }
        CComplexObject ccobj = (CComplexObject)constraint;
        if (!ccobj.getRmTypeName().equalsIgnoreCase(ELEMENT)) {
            throw new FlatteningException("Unexpected constraint rmType: " + ccobj.getRmTypeName());
        }
        ValueConstraint vc = rule.getConstraint();
        if (vc instanceof TextConstraint) {
            tc = (TextConstraint)vc;
            this.applyTextConstraint(ccobj, (TextConstraint)tc);
        }
        if (vc instanceof QuantityConstraint) {
            tc = (QuantityConstraint)vc;
            this.applyQuantityConstraint(ccobj, (QuantityConstraint)tc);
            archetype.updatePathNodeMapRecursively((CObject)ccobj);
        } else if (vc instanceof MultipleConstraint) {
            MultipleConstraint mc = (MultipleConstraint)vc;
            this.applyMultipleConstraint(ccobj, mc);
        }
    }

    protected void applyQuantityConstraint(CComplexObject ccobj, QuantityConstraint qc) throws FlatteningException {
        log.debug((Object)("applying quantity constraint on path: " + ccobj.path()));
        String[] includedUnits = qc.getIncludedUnitsArray();
        String[] excludedUnits = qc.getExcludedUnitsArray();
        QuantityUnitConstraint[] magnitudeUnits = qc.getUnitMagnitudeArray();
        CDvQuantityItem item = null;
        CAttribute valueAttr = ccobj.getAttribute(VALUE);
        String valuePath = ccobj.path() + "/" + VALUE;
        if (magnitudeUnits != null && magnitudeUnits.length == 1) {
            log.debug((Object)"setting unit_magnitude quantity constraint");
            QuantityUnitConstraint quc = magnitudeUnits[0];
            Interval magnitude = new Interval((Comparable)Double.valueOf(quc.getMinMagnitude()), (Comparable)Double.valueOf(quc.getMaxMagnitude()), quc.getIncludesMinimum(), quc.getIncludesMaximum());
            item = new CDvQuantityItem(magnitude, quc.getUnit());
            if (valueAttr != null) {
                valueAttr.removeAllChildren();
                CDvQuantity cdq = CDvQuantity.singleRequired((String)valuePath, (CDvQuantityItem)item);
                valueAttr.addChild((CObject)cdq);
            }
        } else if (includedUnits != null && includedUnits.length == 1) {
            log.debug((Object)"setting included_units quantity constraint");
            item = new CDvQuantityItem(includedUnits[0]);
        } else {
            if (excludedUnits != null && excludedUnits.length > 0) {
                log.debug((Object)"setting excluded_units quantity constraint");
                if (valueAttr == null) {
                    throw new FlatteningException("Missing value attribute for quantityConstraint.excludedUnits");
                }
                if (valueAttr.getChildren() == null || valueAttr.getChildren().isEmpty()) {
                    throw new FlatteningException("Missing child obj for quantityConstraint.excludedUnits");
                }
                if (valueAttr.getChildren().size() > 1) {
                    throw new FlatteningException("More than one child obj for quantityConstraint.excludedUnits");
                }
                CObject child = (CObject)valueAttr.getChildren().get(0);
                if (!(child instanceof CDvQuantity)) {
                    throw new FlatteningException("Non-CDvQuantity child obj for quantityConstraint.excludedUnits");
                }
                CDvQuantity cdq = (CDvQuantity)child;
                if (cdq.getList() == null || cdq.getList().isEmpty()) {
                    throw new FlatteningException("Empty CDvQuantity.list for quantityConstraint.excludedUnits");
                }
                cdq.removeItemByUnitsList(excludedUnits);
                return;
            }
            throw new FlatteningException("Unsupported quantityConstraint in Template: " + qc);
        }
        if (valueAttr == null) {
            valueAttr = new CSingleAttribute(valuePath, VALUE, CAttribute.Existence.REQUIRED);
            CDvQuantity cdq = CDvQuantity.singleRequired((String)valuePath, (CDvQuantityItem)item);
            valueAttr.addChild((CObject)cdq);
            ccobj.addAttribute(valueAttr);
        } else {
            if (valueAttr.getChildren() == null || valueAttr.getChildren().isEmpty()) {
                throw new FlatteningException("Missing child obj for quantityConstraint.excludedUnits");
            }
            if (valueAttr.getChildren().size() > 1) {
                throw new FlatteningException("More than one child obj for quantityConstraint.excludedUnits");
            }
            CObject child = (CObject)valueAttr.getChildren().get(0);
            if (!(child instanceof CDvQuantity)) {
                throw new FlatteningException("Non-CDvQuantity child obj for quantityConstraint.excludedUnits");
            }
            CDvQuantity cdq = (CDvQuantity)child;
            cdq.addItem(item);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void applyTextConstraint(CComplexObject ccobj, TextConstraint tc) throws FlatteningException {
        log.debug((Object)("applying text constraint on path: " + ccobj.path()));
        String[] includedValues = tc.getIncludedValuesArray();
        String[] excludedValues = tc.getExcludedValuesArray();
        CAttribute valueAttr = ccobj.getAttribute(VALUE);
        String valuePath = ccobj.path() + "/" + VALUE;
        String definingCodePath = valuePath + "/" + DEFINING_CODE;
        if (includedValues != null && includedValues.length > 0) {
            if (valueAttr == null) {
                valueAttr = new CSingleAttribute(valuePath, VALUE, CAttribute.Existence.REQUIRED);
                ccobj.addAttribute(valueAttr);
            } else if (valueAttr.getChildren().size() > 0) {
                valueAttr.removeAllChildren();
            }
            CComplexObject valueObj = CComplexObject.createSingleRequired((String)valuePath, (String)DV_CODED_TEXT);
            valueAttr.addChild((CObject)valueObj);
            CSingleAttribute definingCode = CSingleAttribute.createRequired((String)definingCodePath, (String)DEFINING_CODE);
            valueObj.addAttribute((CAttribute)definingCode);
            ArrayList<String> codeList = new ArrayList<String>();
            String terminology = null;
            String text = null;
            String code = null;
            for (String value : includedValues) {
                int j;
                int i = value.indexOf("::");
                if (i == (j = value.lastIndexOf("::")) || j > value.length() - 2) {
                    throw new FlatteningException("wrong syntax for coded text: " + value);
                }
                terminology = value.substring(0, i);
                code = value.substring(i + 2, j);
                text = value.substring(j + 2);
                codeList.add(code);
                this.termMap.addTerm(terminology, code, text, valuePath);
            }
            CCodePhrase ccp = CCodePhrase.singleRequired((String)definingCodePath, terminology, codeList);
            definingCode.addChild((CObject)ccp);
            return;
        } else {
            if (excludedValues == null || excludedValues.length <= 0) return;
            if (valueAttr == null) {
                throw new FlatteningException("failed to set excluded values on text constraint, VALUE attribute missing");
            }
            if (valueAttr.getChildren().size() != 1) throw new FlatteningException("Unexpected VALUE.children.size: " + valueAttr.getChildren().size());
            CObject child = (CObject)valueAttr.getChildren().get(0);
            if (!(child instanceof CComplexObject)) throw new FlatteningException("Unexpected VALUE.child constrainType: " + (child == null ? "null" : child.getClass()));
            CComplexObject childCCObj = (CComplexObject)child;
            if (!childCCObj.getRmTypeName().equals(DV_CODED_TEXT)) return;
            CAttribute definingCodeAttr = childCCObj.getAttribute(DEFINING_CODE);
            if (definingCodeAttr == null) {
                throw new FlatteningException("Missing defining_code attribute");
            }
            CCodePhrase ccp = (CCodePhrase)definingCodeAttr.getChildren().get(0);
            log.debug((Object)("before codeList.size: " + ccp.getCodeList().size()));
            Iterator it = ccp.getCodeList().iterator();
            while (it.hasNext()) {
                String code = (String)it.next();
                for (String value : excludedValues) {
                    int i = value.indexOf("::");
                    if (!code.equals(value.substring(i + 2))) continue;
                    it.remove();
                }
            }
            log.debug((Object)("after codeList.size: " + ccp.getCodeList().size()));
        }
    }

    protected void applyMultipleConstraint(CComplexObject ccobj, MultipleConstraint mc) throws FlatteningException {
        log.debug((Object)("applying multiple constraint on path: " + ccobj.path()));
        String[] includedTypes = mc.getIncludedTypesArray();
        CAttribute cattr = ccobj.getAttribute(VALUE);
        if (cattr != null) {
            if (cattr.getChildren() == null || cattr.getChildren().isEmpty()) {
                throw new FlatteningException("failed to set value constraint, null/empty children list");
            }
            ArrayList<CObject> newChildrenList = new ArrayList<CObject>();
            block0: for (CObject child : cattr.getChildren()) {
                String childType = child.getRmTypeName();
                for (String type : includedTypes) {
                    if (!(DATA_TYPES_PREFIX + type).equalsIgnoreCase(childType) && !type.equalsIgnoreCase(childType)) continue;
                    newChildrenList.add(child);
                    continue block0;
                }
            }
            cattr.removeAllChildren();
            for (CObject child : newChildrenList) {
                cattr.addChild(child);
            }
            log.debug((Object)("total " + newChildrenList.size() + " children left"));
        } else {
            String valuePath = ccobj.path() + "/" + VALUE;
            cattr = new CSingleAttribute(valuePath, VALUE, CAttribute.Existence.REQUIRED);
            ccobj.addAttribute(cattr);
            for (String rmType : includedTypes) {
                if (!(rmType = rmType.toUpperCase()).startsWith(DATA_TYPES_PREFIX)) {
                    rmType = DATA_TYPES_PREFIX + rmType;
                }
                CComplexObject child = CComplexObject.createSingleRequired((String)valuePath, (String)rmType);
                cattr.addChild((CObject)child);
            }
            log.debug((Object)("value attribute added with total " + cattr.getChildren().size() + "child(s)"));
        }
    }

    protected String formatNodeId(long count) {
        String nextId = AT + format.format(count);
        return nextId;
    }

    private String nextNodeId() {
        ++this.nodeCount;
        String nextId = this.formatNodeId(this.nodeCount);
        return nextId;
    }

    private CodePhrase parseCodePhraseAndCollectText(String value, String path) throws FlatteningException {
        int j;
        int i = value.indexOf("::");
        if (i == (j = value.lastIndexOf("::"))) {
            throw new FlatteningException("wrong syntax for coded text: " + value);
        }
        String terminology = value.substring(0, i);
        String code = value.substring(i + 2, j);
        String text = value.substring(j + 2);
        CodePhrase codePhrase = new CodePhrase(terminology, code);
        this.termMap.addTerm(terminology, code, text, path);
        return codePhrase;
    }

    private CString cString(String value) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        CString cstring = new CString(null, values, null);
        return cstring;
    }

    void replaceSlotWithFlattened(CAttribute cattr, Archetyped definition, CObject cobj) {
        List children = cattr.getChildren();
        if (children == null) {
            return;
        }
        int j = children.size();
        for (int i = 0; i < j; ++i) {
            CObject child = (CObject)children.get(i);
            if (!(child instanceof ArchetypeSlot)) continue;
            children.remove(i);
            cobj.setPath(child.path());
            children.add(i, cobj);
        }
    }

    private TEMPLATE retrieveTemplate(String templateId) throws FlatteningException {
        TEMPLATE template = this.templateMap.get(templateId);
        if (template == null) {
            throw new UnknownTemplateException(templateId);
        }
        return template;
    }

    private Archetype retrieveArchetype(String archetypeId) throws FlatteningException {
        Archetype archetype = this.archetypeMap.get(archetypeId);
        if (archetype == null) {
            throw new UnknownArchetypeException(archetypeId);
        }
        archetype = archetype.copy();
        return archetype;
    }

    protected int findLargestNodeId(Archetype archetype) throws FlatteningException {
        return this.findLargestNodeId((CObject)archetype.getDefinition(), 0);
    }

    protected int findLargestNodeId(CObject cobj, int largest) throws FlatteningException {
        int current = largest;
        int last = 0;
        current = this.parseNodeId(cobj.getNodeID());
        if (largest > current) {
            current = largest;
        }
        if (cobj instanceof CComplexObject) {
            CComplexObject ccobj = (CComplexObject)cobj;
            for (CAttribute cattr : ccobj.getAttributes()) {
                for (CObject child : cattr.getChildren()) {
                    last = this.findLargestNodeId(child, current);
                    if (last <= current) continue;
                    current = last;
                }
            }
        }
        return current;
    }

    protected int parseNodeId(String nodeId) throws FlatteningException {
        if (nodeId == null) {
            return 0;
        }
        if (nodeId.length() <= AT.length()) {
            throw new FlatteningException("Too short nodeId: " + nodeId);
        }
        int dot = (nodeId = nodeId.substring(AT.length())).indexOf(".");
        if (dot > 0) {
            nodeId = nodeId.substring(0, dot);
        } else if (dot == 0) {
            throw new FlatteningException("Bad format of nodeId: " + nodeId);
        }
        int value = 0;
        try {
            value = Integer.parseInt(nodeId);
        }
        catch (NumberFormatException nfe) {
            throw new FlatteningException("Bad format of nodeId: " + nodeId);
        }
        return value;
    }

    protected ArchetypeConstraint nodeAtHybridPath(String path) throws FlatteningException {
        return null;
    }

    public TermMap getTermMap() {
        return this.termMap;
    }

    static {
        format.setMinimumIntegerDigits(4);
        format.setMaximumIntegerDigits(8);
        log = Logger.getLogger(Flattener.class);
    }
}

