/*
 * Decompiled with CFR 0.152.
 */
package org.openehr.am.template;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class PathMap {
    private static final String UTF8 = "UTF-8";
    private static final String DELIMITER = "=";
    private Map<String, String> keyPathMap;
    private Logger log = Logger.getLogger(PathMap.class);

    PathMap() {
        this.keyPathMap = new HashMap<String, String>();
    }

    public static PathMap load(String filename) throws IOException {
        List lines = FileUtils.readLines((File)new File(filename), (String)UTF8);
        return PathMap.fromLines(lines);
    }

    public static PathMap load(InputStream input) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(input, UTF8));
        String line = reader.readLine();
        ArrayList<String> lines = new ArrayList<String>();
        while (line != null) {
            lines.add(line);
            line = reader.readLine();
        }
        return PathMap.fromLines(lines);
    }

    static PathMap fromLines(List<String> lines) {
        PathMap pathMap = new PathMap();
        pathMap.addAll(lines);
        return pathMap;
    }

    public void addAll(List<String> lines) {
        String key = null;
        String path = null;
        int i = 0;
        for (String line : lines) {
            if (line.startsWith("#")) continue;
            i = line.indexOf(DELIMITER);
            if (i <= 0) {
                this.log.warn((Object)("Wrong formatted line skipped: " + line));
                continue;
            }
            key = line.substring(0, i).trim();
            path = line.substring(i + 1).trim();
            this.addPath(key, path);
        }
    }

    public void addPath(String key, String path) {
        if (key == null || path == null) {
            throw new IllegalArgumentException("null key or path");
        }
        if (!this.keyPathMap.containsKey(key)) {
            this.keyPathMap.put(key, path);
        } else if (!path.equals(this.keyPathMap.get(key))) {
            this.log.warn((Object)("tried to add duplicated key [" + key + "] with different path: " + path));
        }
    }

    public int countPaths() {
        return this.keyPathMap.keySet().size();
    }

    public String getPath(String key) {
        return this.keyPathMap.get(key);
    }

    public SortedSet<String> getKeys() {
        return new TreeSet<String>(this.keyPathMap.keySet());
    }

    public void writeToFile(String filename) throws IOException {
        ArrayList<String> paths = new ArrayList<String>();
        DateFormat df = DateFormat.getDateTimeInstance();
        paths.add("# Generated path map on " + df.format(new Date()));
        int maxLen = 0;
        String maxLenKey = null;
        for (Map.Entry<String, String> entry : this.keyPathMap.entrySet()) {
            String key = entry.getKey();
            String path = entry.getValue();
            if (key.length() > maxLen) {
                maxLen = key.length();
                maxLenKey = key;
            }
            paths.add(key + DELIMITER + path);
        }
        this.log.debug((Object)("max length of key: " + maxLen + ", key: " + maxLenKey));
        File pathMapFile = new File(filename);
        FileUtils.writeLines((File)pathMapFile, (String)UTF8, paths);
        this.log.info((Object)("total " + (paths.size() - 1) + " line(s) of path written to file"));
    }
}

