/*
 * Decompiled with CFR 0.152.
 */
package org.openehr.am.template;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.openehr.rm.datatypes.text.CodePhrase;

public class TermMap {
    private static final String UTF8 = "UTF-8";
    private static final String DELIMITER = "::";
    private static final Logger log = Logger.getLogger(TermMap.class);
    private Map<String, Map<String, Map<String, String>>> termMap = new TreeMap<String, Map<String, Map<String, String>>>();

    public static TermMap load(String filename) throws IOException {
        List lines = FileUtils.readLines((File)new File(filename), (String)UTF8);
        return TermMap.fromLines(lines);
    }

    public static TermMap load(InputStream input) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(input, UTF8));
        String line = reader.readLine();
        ArrayList<String> lines = new ArrayList<String>();
        while (line != null) {
            lines.add(line);
            line = reader.readLine();
        }
        return TermMap.fromLines(lines);
    }

    static TermMap fromLines(List<String> lines) {
        TermMap termMap = new TermMap();
        termMap.addAll(lines);
        return termMap;
    }

    public void addAll(InputStream input) throws Exception {
        BufferedReader reader = new BufferedReader(new InputStreamReader(input, UTF8));
        String line = reader.readLine();
        ArrayList<String> lines = new ArrayList<String>();
        while (line != null) {
            lines.add(line);
            line = reader.readLine();
        }
        this.addAll(lines);
    }

    public void addAll(List<String> lines) {
        String text = null;
        String terminology = null;
        String code = null;
        String path = null;
        StringTokenizer tokens = null;
        int totalTokens = 0;
        for (String line : lines) {
            tokens = new StringTokenizer(line, DELIMITER);
            totalTokens = tokens.countTokens();
            if (totalTokens != 3 && totalTokens != 4) {
                log.debug((Object)("Wrong formatted line skipped: " + line));
                continue;
            }
            terminology = tokens.nextToken();
            code = tokens.nextToken();
            text = tokens.nextToken();
            path = totalTokens == 4 ? tokens.nextToken() : "";
            this.addTerm(terminology, code, text, path);
        }
    }

    public void clear() {
        this.termMap.clear();
    }

    public void addTerm(String terminology, String code, String text, String path) {
        Map<String, String> paths;
        Map<String, Map<String, String>> terms;
        if (log.isDebugEnabled()) {
            log.debug((Object)("adding term: " + terminology + DELIMITER + code + DELIMITER + text + DELIMITER + path));
        }
        if ((terms = this.termMap.get(terminology)) == null) {
            terms = new TreeMap<String, Map<String, String>>();
            this.termMap.put(terminology, terms);
            log.debug((Object)("new terminology: " + terminology + " added.."));
        }
        if ((paths = terms.get(code)) == null) {
            paths = new TreeMap<String, String>();
            terms.put(code, paths);
        }
        paths.put(path, text);
    }

    public String getText(String terminology, String code, String path) {
        Map<String, String> paths = null;
        String text = null;
        Map<String, Map<String, String>> terms = this.termMap.get(terminology);
        if (terms != null && (paths = terms.get(code)) != null) {
            if (paths.size() == 1 && "".equals(paths.keySet().iterator().next())) {
                text = paths.get("");
            } else {
                text = paths.get(path);
                if (text == null) {
                    for (Map.Entry<String, String> entry : paths.entrySet()) {
                        if (!path.endsWith(entry.getKey())) continue;
                        text = entry.getValue();
                    }
                }
            }
        }
        log.debug((Object)("Retrieved text '" + text + "' for [" + terminology + DELIMITER + code + "] at path: " + path));
        return text;
    }

    public String getText(String codePhrase, String path) {
        int i = codePhrase.indexOf(DELIMITER);
        if (i <= 0 || i == codePhrase.length()) {
            throw new IllegalArgumentException("wrong format, expected {terminology}::{code}");
        }
        String terminology = codePhrase.substring(0, i);
        String code = codePhrase.substring(i + 2);
        return this.getText(terminology, code, path);
    }

    public String getText(CodePhrase codePhrase, String path) {
        return this.getText(codePhrase.getTerminologyId().toString(), codePhrase.getCodeString(), path);
    }

    public int countTerminologies() {
        return this.termMap.size();
    }

    public Map<String, Map<String, Map<String, String>>> getTermMap() {
        return this.termMap;
    }

    public void writeTermMap(String filename) throws IOException {
        StringBuffer buf = new StringBuffer();
        String terminology = null;
        String code = null;
        String text = null;
        String path = null;
        Map<String, String> texts = null;
        Map<String, Map<String, String>> terms = null;
        for (Map.Entry<String, Map<String, Map<String, String>>> entry : this.termMap.entrySet()) {
            terminology = entry.getKey();
            terms = entry.getValue();
            for (Map.Entry<String, Map<String, String>> entry2 : terms.entrySet()) {
                code = entry2.getKey();
                texts = entry2.getValue();
                for (Map.Entry<String, String> entry3 : texts.entrySet()) {
                    path = entry3.getKey();
                    text = entry3.getValue();
                    buf.append(terminology);
                    buf.append(DELIMITER);
                    buf.append(code);
                    buf.append(DELIMITER);
                    buf.append(text);
                    buf.append(DELIMITER);
                    buf.append(path);
                    buf.append("\r\n");
                }
            }
        }
        FileUtils.writeStringToFile((File)new File(filename), (String)buf.toString(), (String)UTF8);
    }
}

