/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.openengsb.core.api.model.BeanDescription;
import org.openengsb.core.api.remote.MethodCall;
import org.openengsb.core.api.remote.MethodCallMessage;
import org.openengsb.core.api.remote.MethodResult;
import org.openengsb.core.api.remote.MethodResultMessage;
import org.openengsb.core.api.security.DecryptionException;
import org.openengsb.core.api.security.EncryptionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AuthenticatingSampleApp {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthenticatingSampleApp.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final String URL = "tcp://127.0.0.1:6549";
    private static Connection connection;
    private static Session session;
    private static MessageProducer producer;

    private static void init() throws JMSException {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(URL);
        connection = connectionFactory.createConnection();
        connection.start();
        session = connection.createSession(false, 1);
        Queue destination = session.createQueue("receive");
        producer = session.createProducer((Destination)destination);
    }

    private static MethodResult call(MethodCall call, String username, Object credentials) throws IOException, JMSException, InterruptedException, ClassNotFoundException, EncryptionException, DecryptionException {
        MethodCallMessage methodCallRequest = new MethodCallMessage(call);
        String requestString = AuthenticatingSampleApp.marshalSecureRequest(methodCallRequest, username, credentials);
        AuthenticatingSampleApp.sendMessage(requestString);
        String resultString = AuthenticatingSampleApp.getResultFromQueue(methodCallRequest.getCallId());
        return AuthenticatingSampleApp.convertStringToResult(resultString);
    }

    private static String marshalSecureRequest(MethodCallMessage methodCallRequest, String username, Object credentails) throws IOException {
        BeanDescription auth = BeanDescription.fromObject((Object)credentails);
        methodCallRequest.setPrincipal(username);
        methodCallRequest.setCredentials(auth);
        return MAPPER.writeValueAsString((Object)methodCallRequest);
    }

    private static MethodResult convertStringToResult(String resultString) throws IOException, ClassNotFoundException, DecryptionException {
        MethodResultMessage resultMessage = (MethodResultMessage)MAPPER.readValue(resultString, MethodResultMessage.class);
        return AuthenticatingSampleApp.convertResult(resultMessage);
    }

    private static MethodResult convertResult(MethodResultMessage resultMessage) throws ClassNotFoundException {
        MethodResult result = resultMessage.getResult();
        Class<?> clazz = Class.forName(result.getClassName());
        Object resultValue = MAPPER.convertValue(result.getArg(), clazz);
        result.setArg(resultValue);
        return result;
    }

    private static void sendMessage(String requestString) throws JMSException {
        TextMessage message = session.createTextMessage(requestString);
        producer.send((Message)message);
    }

    private static String getResultFromQueue(String callId) throws JMSException, InterruptedException {
        Queue resultDest = session.createQueue(callId);
        MessageConsumer consumer = session.createConsumer((Destination)resultDest);
        final Semaphore messageSem = new Semaphore(0);
        final AtomicReference resultReference = new AtomicReference();
        consumer.setMessageListener(new MessageListener(){

            public void onMessage(Message message) {
                try {
                    String text = ((TextMessage)message).getText();
                    resultReference.set(text);
                }
                catch (JMSException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    messageSem.release();
                }
            }
        });
        LOGGER.info("waiting for response");
        if (!messageSem.tryAcquire(10L, TimeUnit.SECONDS)) {
            throw new RuntimeException("no response");
        }
        LOGGER.info("response received");
        return (String)resultReference.get();
    }

    private static void stop() throws JMSException {
        session.close();
        connection.stop();
        connection.close();
    }

    public static void main(String[] args) throws Exception {
        LOGGER.info("initializing");
        AuthenticatingSampleApp.init();
        LOGGER.info("initialized");
        MethodCall methodCall = new MethodCall("doSomething", new Object[]{"Hello World!"}, (Map)ImmutableMap.of((Object)"serviceId", (Object)"example+example+testlog", (Object)"contextId", (Object)"foo"));
        LOGGER.info("calling method");
        MethodResult methodResult = AuthenticatingSampleApp.call(methodCall, "admin", "password");
        System.out.println(methodResult);
        AuthenticatingSampleApp.stop();
    }

    private AuthenticatingSampleApp() {
    }
}

