/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.google.common.base.Throwables;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import org.openengsb.core.api.remote.MethodCallMessage;
import org.openengsb.core.api.remote.MethodResult;
import org.openengsb.core.api.remote.MethodResultMessage;
import test.JmsConfig;
import test.MessageHandler;
import test.RequestHandler;
import test.SecureSampleConnector;

final class ConnectorMessageListener
implements MessageListener {
    private MessageHandler handler;
    private RequestHandler requestHander = new RequestHandler();
    private JmsConfig jmsConfig;

    ConnectorMessageListener(JmsConfig jmsConfig) {
        this.handler = new MessageHandler();
        this.jmsConfig = jmsConfig;
    }

    public void onMessage(Message message) {
        SecureSampleConnector.LOGGER.info("recieved JMS-message");
        TextMessage content = (TextMessage)message;
        String text = this.getTextFromMessage(content);
        MethodCallMessage request = this.handler.unmarshal(text);
        MethodResult result = this.requestHander.process(request.getMethodCall());
        try {
            this.sendResult(request, result);
        }
        catch (JMSException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private String getTextFromMessage(TextMessage content) {
        String text;
        try {
            text = content.getText();
        }
        catch (JMSException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return text;
    }

    private void sendResult(MethodCallMessage request, MethodResult result) throws JMSException {
        MethodResultMessage methodResultMessage = new MethodResultMessage(result, request.getCallId());
        String resultText = this.handler.marshal(methodResultMessage);
        this.jmsConfig.sendMessage(request.getCallId(), resultText);
    }
}

