/*
 * Decompiled with CFR 0.152.
 */
package test;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmsConfig.class);
    private String url;
    private Connection connection;
    private Session session;

    public JmsConfig(String url) {
        this.url = url;
    }

    public void init() throws JMSException {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(this.url);
        this.connection = connectionFactory.createConnection();
        this.connection.start();
        this.session = this.connection.createSession(false, 1);
    }

    public MessageProducer createProducerForQueue(String name) throws JMSException {
        Queue destination = this.session.createQueue(name);
        return this.session.createProducer((Destination)destination);
    }

    public MessageConsumer createConsumerForQueue(String name) throws JMSException {
        Queue queue = this.session.createQueue(name);
        return this.session.createConsumer((Destination)queue);
    }

    public MessageConsumer createConsumerForQueue(String name, MessageListener listener) throws JMSException {
        MessageConsumer result = this.createConsumerForQueue(name);
        result.setMessageListener(listener);
        return result;
    }

    public void sendMessage(String queue, String message) throws JMSException {
        LOGGER.info("sending message {}", (Object)message);
        LOGGER.info("to queue {}", (Object)queue);
        TextMessage message2 = this.session.createTextMessage(message);
        MessageProducer resultProducer = this.createProducerForQueue(queue);
        resultProducer.send((Message)message2);
    }

    public void stop() throws JMSException {
        this.session.close();
        this.connection.stop();
        this.connection.close();
    }
}

