/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.google.common.base.Throwables;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.openengsb.core.api.remote.MethodCall;
import org.openengsb.core.api.remote.MethodResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import test.ExampleConnector;

class RequestHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestHandler.class);
    private ExampleConnector connector = new ExampleConnector();

    RequestHandler() {
    }

    public MethodResult process(MethodCall request) {
        Method method;
        List argClassList = request.getClasses();
        Class[] argClasses = new Class[argClassList.size()];
        LOGGER.debug("converting arguments");
        for (int i = 0; i < argClassList.size(); ++i) {
            try {
                argClasses[i] = Class.forName((String)argClassList.get(i));
                continue;
            }
            catch (ClassNotFoundException e) {
                return this.makeExceptionResult(new IllegalStateException(e));
            }
        }
        try {
            LOGGER.debug("searching for method {} with args {}", (Object)request.getMethodName(), (Object)request.getClasses());
            method = ExampleConnector.class.getMethod(request.getMethodName(), argClasses);
        }
        catch (NoSuchMethodException e) {
            return this.makeExceptionResult(e);
        }
        try {
            LOGGER.info("invoking method {}", (Object)method);
            Object result = method.invoke((Object)this.connector, request.getArgs());
            if (method.getReturnType().equals(Void.TYPE)) {
                MethodResult methodResult = new MethodResult();
                methodResult.setClassName(Object.class.getName());
                methodResult.setType(MethodResult.ReturnType.Void);
                return methodResult;
            }
            LOGGER.debug("invocation successful");
            return new MethodResult(result);
        }
        catch (InvocationTargetException e) {
            return this.makeExceptionResult((Exception)e.getTargetException());
        }
        catch (IllegalArgumentException e) {
            return this.makeExceptionResult(e);
        }
        catch (IllegalAccessException e) {
            return this.makeExceptionResult(new IllegalStateException(e));
        }
    }

    private MethodResult makeExceptionResult(Exception e) {
        LOGGER.error("Exception occured, making Exception result");
        return new MethodResult((Object)Throwables.getStackTraceAsString((Throwable)e), MethodResult.ReturnType.Exception);
    }
}

