/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.PublicKey;
import java.util.Map;
import java.util.UUID;
import javax.crypto.SecretKey;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.openengsb.core.api.model.BeanDescription;
import org.openengsb.core.api.remote.MethodCall;
import org.openengsb.core.api.remote.MethodCallMessage;
import org.openengsb.core.api.remote.MethodResult;
import org.openengsb.core.api.remote.MethodResultMessage;
import org.openengsb.core.api.security.DecryptionException;
import org.openengsb.core.api.security.EncryptionException;
import org.openengsb.core.api.security.model.EncryptedMessage;
import org.openengsb.core.util.CipherUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.SessionCallback;

public final class SecureSampleApp {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecureSampleApp.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final String URL = "tcp://127.0.0.1:6549";
    private static JmsTemplate template;

    private static void init() throws JMSException {
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory(URL);
        template = new JmsTemplate((ConnectionFactory)cf);
    }

    private static MethodResult call(MethodCall call, String username, Object credentails) throws IOException, JMSException, InterruptedException, ClassNotFoundException, EncryptionException, DecryptionException {
        MethodCallMessage methodCallRequest = new MethodCallMessage(call);
        SecretKey sessionKey = CipherUtils.generateKey((String)"AES", (int)128);
        String requestString = SecureSampleApp.marshalRequest(methodCallRequest, sessionKey, username, credentails);
        String resultString = SecureSampleApp.sendMessage(requestString);
        return SecureSampleApp.convertStringToResult(resultString, sessionKey);
    }

    private static String sendMessage(final String encryptedMessage) {
        return (String)template.execute((SessionCallback)new SessionCallback<String>(){

            public String doInJms(Session session) throws JMSException {
                TextMessage message = session.createTextMessage(encryptedMessage);
                Queue outQueue = session.createQueue("receive");
                TemporaryQueue inDest = session.createTemporaryQueue();
                String correlationID = UUID.randomUUID().toString();
                message.setJMSReplyTo((Destination)inDest);
                message.setJMSCorrelationID(correlationID);
                MessageProducer producer = session.createProducer((Destination)outQueue);
                producer.send((Destination)outQueue, (Message)message);
                return ((TextMessage)session.createConsumer((Destination)inDest).receive(10000L)).getText();
            }
        }, true);
    }

    private static String marshalRequest(MethodCallMessage methodCallRequest, SecretKey sessionKey, String username, Object credentials) throws IOException, EncryptionException {
        byte[] requestString = SecureSampleApp.marshalSecureRequest(methodCallRequest, username, credentials);
        EncryptedMessage encryptedMessage = SecureSampleApp.encryptMessage(sessionKey, requestString);
        return MAPPER.writeValueAsString((Object)encryptedMessage);
    }

    private static EncryptedMessage encryptMessage(SecretKey sessionKey, byte[] requestString) throws IOException, EncryptionException {
        PublicKey publicKey = SecureSampleApp.readPublicKey();
        byte[] encryptedContent = CipherUtils.encrypt((byte[])requestString, (Key)sessionKey);
        byte[] encryptedKey = CipherUtils.encrypt((byte[])sessionKey.getEncoded(), (Key)publicKey);
        EncryptedMessage encryptedMessage = new EncryptedMessage(encryptedContent, encryptedKey);
        return encryptedMessage;
    }

    private static PublicKey readPublicKey() throws IOException {
        InputStream publicKeyResource = ClassLoader.getSystemResourceAsStream("public.key.data");
        byte[] publicKeyData = IOUtils.toByteArray((InputStream)publicKeyResource);
        PublicKey publicKey = CipherUtils.deserializePublicKey((byte[])publicKeyData, (String)"RSA");
        return publicKey;
    }

    private static byte[] marshalSecureRequest(MethodCallMessage methodCallRequest, String username, Object credentials) throws IOException {
        BeanDescription credentialsBean = BeanDescription.fromObject((Object)credentials);
        methodCallRequest.setPrincipal(username);
        methodCallRequest.setCredentials(credentialsBean);
        return MAPPER.writeValueAsBytes((Object)methodCallRequest);
    }

    private static MethodResult convertStringToResult(String resultString, SecretKey sessionKey) throws IOException, ClassNotFoundException, DecryptionException {
        MethodResultMessage resultMessage = SecureSampleApp.decryptResponse(resultString, sessionKey);
        return SecureSampleApp.convertResult(resultMessage);
    }

    private static MethodResult convertResult(MethodResultMessage resultMessage) throws ClassNotFoundException {
        MethodResult result = resultMessage.getResult();
        Class<?> clazz = Class.forName(result.getClassName());
        Object resultValue = MAPPER.convertValue(result.getArg(), clazz);
        result.setArg(resultValue);
        return result;
    }

    private static MethodResultMessage decryptResponse(String resultString, SecretKey sessionKey) throws DecryptionException, IOException {
        byte[] decryptedContent;
        try {
            decryptedContent = CipherUtils.decrypt((byte[])Base64.decodeBase64((String)resultString), (Key)sessionKey);
        }
        catch (DecryptionException e) {
            System.err.println(resultString);
            throw e;
        }
        MethodResultMessage resultMessage = (MethodResultMessage)MAPPER.readValue(decryptedContent, MethodResultMessage.class);
        return resultMessage;
    }

    public static void main(String[] args) throws Exception {
        LOGGER.info("initializing");
        SecureSampleApp.init();
        LOGGER.info("initialized");
        MethodCall methodCall = new MethodCall("doSomething", new Object[]{"Hello World!"}, (Map)ImmutableMap.of((Object)"serviceId", (Object)"example+example+testlog", (Object)"contextId", (Object)"foo"));
        LOGGER.info("calling method");
        MethodResult methodResult = SecureSampleApp.call(methodCall, "admin", "password");
        System.out.println(methodResult);
    }

    private SecureSampleApp() {
    }
}

