/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.event.legacy;

import com.atlassian.event.Event;
import com.atlassian.event.EventListener;
import com.atlassian.event.spi.ListenerHandler;
import com.atlassian.event.spi.ListenerInvoker;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LegacyListenerHandler
implements ListenerHandler {
    @Override
    public List<? extends ListenerInvoker> getInvokers(Object listener) {
        return Preconditions.checkNotNull((Object)listener) instanceof EventListener ? this.getLegacyListenerInvoker((EventListener)listener) : Collections.emptyList();
    }

    private List<? extends ListenerInvoker> getLegacyListenerInvoker(EventListener eventListener) {
        return Collections.singletonList(new LegacyListenerInvoker(eventListener));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LegacyListenerInvoker
    implements ListenerInvoker {
        private final EventListener eventListener;

        public LegacyListenerInvoker(EventListener eventListener) {
            this.eventListener = (EventListener)Preconditions.checkNotNull((Object)eventListener);
        }

        @Override
        public Set<Class<?>> getSupportedEventTypes() {
            Object[] classes = this.eventListener.getHandledEventClasses();
            if (classes.length == 0) {
                return Collections.singleton(Event.class);
            }
            return Sets.newHashSet((Object[])classes);
        }

        @Override
        public void invoke(Object event) {
            this.eventListener.handleEvent((Event)event);
        }

        @Override
        public boolean supportAsynchronousEvents() {
            return true;
        }
    }
}

