/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.internal.async;

import com.atlassian.httpclient.api.HttpClient;
import com.atlassian.jira.rest.client.api.UserRestClient;
import com.atlassian.jira.rest.client.api.domain.User;
import com.atlassian.jira.rest.client.internal.async.AbstractAsynchronousRestClient;
import com.atlassian.jira.rest.client.internal.json.UserJsonParser;
import com.atlassian.util.concurrent.Promise;
import java.net.URI;
import javax.ws.rs.core.UriBuilder;

public class AsynchronousUserRestClient
extends AbstractAsynchronousRestClient
implements UserRestClient {
    private static final String USER_URI_PREFIX = "user";
    private final UserJsonParser userJsonParser = new UserJsonParser();
    private final URI baseUri;

    public AsynchronousUserRestClient(URI baseUri, HttpClient client) {
        super(client);
        this.baseUri = baseUri;
    }

    @Override
    public Promise<User> getUser(String username) {
        URI userUri = UriBuilder.fromUri((URI)this.baseUri).path(USER_URI_PREFIX).queryParam("username", new Object[]{username}).queryParam("expand", new Object[]{"groups"}).build(new Object[0]);
        return this.getUser(userUri);
    }

    @Override
    public Promise<User> getUser(URI userUri) {
        return this.getAndParse(userUri, this.userJsonParser);
    }
}

