/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.interceptor;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.interceptor.CacheEvictOperation;
import org.springframework.cache.interceptor.CacheOperation;
import org.springframework.cache.interceptor.CacheOperationSource;
import org.springframework.cache.interceptor.CachePutOperation;
import org.springframework.cache.interceptor.CacheableOperation;
import org.springframework.cache.interceptor.CompositeCacheOperationSource;
import org.springframework.cache.interceptor.DefaultKeyGenerator;
import org.springframework.cache.interceptor.ExpressionEvaluator;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.expression.EvaluationContext;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CacheAspectSupport
implements InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private CacheManager cacheManager;
    private CacheOperationSource cacheOperationSource;
    private final ExpressionEvaluator evaluator = new ExpressionEvaluator();
    private KeyGenerator keyGenerator = new DefaultKeyGenerator();
    private boolean initialized = false;
    private static final String CACHEABLE = "cacheable";
    private static final String UPDATE = "cacheupdate";
    private static final String EVICT = "cacheevict";

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void setCacheOperationSources(CacheOperationSource ... cacheOperationSources) {
        Assert.notEmpty((Object[])cacheOperationSources);
        this.cacheOperationSource = cacheOperationSources.length > 1 ? new CompositeCacheOperationSource(cacheOperationSources) : cacheOperationSources[0];
    }

    public CacheOperationSource getCacheOperationSource() {
        return this.cacheOperationSource;
    }

    public void setKeyGenerator(KeyGenerator keyGenerator) {
        this.keyGenerator = keyGenerator;
    }

    public KeyGenerator getKeyGenerator() {
        return this.keyGenerator;
    }

    @Override
    public void afterPropertiesSet() {
        if (this.cacheManager == null) {
            throw new IllegalStateException("'cacheManager' is required");
        }
        if (this.cacheOperationSource == null) {
            throw new IllegalStateException("The 'cacheOperationSources' property is required: If there are no cacheable methods, then don't use a cache aspect.");
        }
        this.initialized = true;
    }

    protected String methodIdentification(Method method, Class<?> targetClass) {
        Method specificMethod = ClassUtils.getMostSpecificMethod((Method)method, targetClass);
        return ClassUtils.getQualifiedMethodName((Method)specificMethod);
    }

    protected Collection<Cache> getCaches(CacheOperation operation) {
        Set<String> cacheNames = operation.getCacheNames();
        ArrayList<Cache> caches = new ArrayList<Cache>(cacheNames.size());
        for (String cacheName : cacheNames) {
            Cache cache = this.cacheManager.getCache(cacheName);
            if (cache == null) {
                throw new IllegalArgumentException("Cannot find cache named [" + cacheName + "] for " + operation);
            }
            caches.add(cache);
        }
        return caches;
    }

    protected CacheOperationContext getOperationContext(CacheOperation operation, Method method, Object[] args, Object target, Class<?> targetClass) {
        return new CacheOperationContext(operation, method, args, target, targetClass);
    }

    protected Object execute(Invoker invoker, Object target, Method method, Object[] args) {
        Collection<CacheOperation> cacheOp;
        if (!this.initialized) {
            return invoker.invoke();
        }
        Class<?> targetClass = AopProxyUtils.ultimateTargetClass(target);
        if (targetClass == null && target != null) {
            targetClass = target.getClass();
        }
        if (!CollectionUtils.isEmpty(cacheOp = this.getCacheOperationSource().getCacheOperations(method, targetClass))) {
            Map<String, Collection<CacheOperationContext>> ops = this.createOperationContext(cacheOp, method, args, target, targetClass);
            this.inspectBeforeCacheEvicts(ops.get(EVICT));
            CacheStatus status = this.inspectCacheables(ops.get(CACHEABLE));
            Object retVal = null;
            Map<CacheOperationContext, Object> updates = this.inspectCacheUpdates(ops.get(UPDATE));
            if (status != null) {
                if (status.updateRequired) {
                    updates.putAll(status.cUpdates);
                } else {
                    return status.retVal;
                }
            }
            retVal = invoker.invoke();
            this.inspectAfterCacheEvicts(ops.get(EVICT));
            if (!updates.isEmpty()) {
                this.update(updates, retVal);
            }
            return retVal;
        }
        return invoker.invoke();
    }

    private void inspectBeforeCacheEvicts(Collection<CacheOperationContext> evictions) {
        this.inspectCacheEvicts(evictions, true);
    }

    private void inspectAfterCacheEvicts(Collection<CacheOperationContext> evictions) {
        this.inspectCacheEvicts(evictions, false);
    }

    private void inspectCacheEvicts(Collection<CacheOperationContext> evictions, boolean beforeInvocation) {
        if (!evictions.isEmpty()) {
            boolean log = this.logger.isTraceEnabled();
            for (CacheOperationContext context : evictions) {
                CacheEvictOperation evictOp = (CacheEvictOperation)context.operation;
                if (beforeInvocation != evictOp.isBeforeInvocation()) continue;
                if (context.isConditionPassing()) {
                    Object key = null;
                    for (Cache cache : context.getCaches()) {
                        if (evictOp.isCacheWide()) {
                            cache.clear();
                            if (!log) continue;
                            this.logger.trace((Object)("Invalidating entire cache for operation " + evictOp + " on method " + context.method));
                            continue;
                        }
                        if (key == null) {
                            key = context.generateKey();
                        }
                        if (log) {
                            this.logger.trace((Object)("Invalidating cache key " + key + " for operation " + evictOp + " on method " + context.method));
                        }
                        cache.evict(key);
                    }
                    continue;
                }
                if (!log) continue;
                this.logger.trace((Object)("Cache condition failed on method " + context.method + " for operation " + context.operation));
            }
        }
    }

    private CacheStatus inspectCacheables(Collection<CacheOperationContext> cacheables) {
        LinkedHashMap<CacheOperationContext, Object> cUpdates = new LinkedHashMap<CacheOperationContext, Object>(cacheables.size());
        boolean updateRequire = false;
        Object retVal = null;
        if (!cacheables.isEmpty()) {
            boolean log = this.logger.isTraceEnabled();
            boolean atLeastOnePassed = false;
            for (CacheOperationContext context : cacheables) {
                if (context.isConditionPassing()) {
                    atLeastOnePassed = true;
                    Object key = context.generateKey();
                    if (log) {
                        this.logger.trace((Object)("Computed cache key " + key + " for operation " + context.operation));
                    }
                    if (key == null) {
                        throw new IllegalArgumentException("Null key returned for cache operation (maybe you are using named params on classes without debug info?) " + context.operation);
                    }
                    cUpdates.put(context, key);
                    boolean localCacheHit = false;
                    if (!updateRequire) {
                        for (Cache cache : context.getCaches()) {
                            Cache.ValueWrapper wrapper = cache.get(key);
                            if (wrapper == null) continue;
                            retVal = wrapper.get();
                            localCacheHit = true;
                            break;
                        }
                    }
                    if (localCacheHit) continue;
                    updateRequire = true;
                    continue;
                }
                if (!log) continue;
                this.logger.trace((Object)("Cache condition failed on method " + context.method + " for operation " + context.operation));
            }
            if (atLeastOnePassed) {
                return new CacheStatus(cUpdates, updateRequire, retVal);
            }
        }
        return null;
    }

    private Map<CacheOperationContext, Object> inspectCacheUpdates(Collection<CacheOperationContext> updates) {
        LinkedHashMap<CacheOperationContext, Object> cUpdates = new LinkedHashMap<CacheOperationContext, Object>(updates.size());
        if (!updates.isEmpty()) {
            boolean log = this.logger.isTraceEnabled();
            for (CacheOperationContext context : updates) {
                if (context.isConditionPassing()) {
                    Object key = context.generateKey();
                    if (log) {
                        this.logger.trace((Object)("Computed cache key " + key + " for operation " + context.operation));
                    }
                    if (key == null) {
                        throw new IllegalArgumentException("Null key returned for cache operation (maybe you are using named params on classes without debug info?) " + context.operation);
                    }
                    cUpdates.put(context, key);
                    continue;
                }
                if (!log) continue;
                this.logger.trace((Object)("Cache condition failed on method " + context.method + " for operation " + context.operation));
            }
        }
        return cUpdates;
    }

    private void update(Map<CacheOperationContext, Object> updates, Object retVal) {
        for (Map.Entry<CacheOperationContext, Object> entry : updates.entrySet()) {
            for (Cache cache : entry.getKey().getCaches()) {
                cache.put(entry.getValue(), retVal);
            }
        }
    }

    private Map<String, Collection<CacheOperationContext>> createOperationContext(Collection<CacheOperation> cacheOp, Method method, Object[] args, Object target, Class<?> targetClass) {
        LinkedHashMap<String, Collection<CacheOperationContext>> map = new LinkedHashMap<String, Collection<CacheOperationContext>>(3);
        ArrayList<CacheOperationContext> cacheables = new ArrayList<CacheOperationContext>();
        ArrayList<CacheOperationContext> evicts = new ArrayList<CacheOperationContext>();
        ArrayList<CacheOperationContext> updates = new ArrayList<CacheOperationContext>();
        for (CacheOperation cacheOperation : cacheOp) {
            CacheOperationContext opContext = this.getOperationContext(cacheOperation, method, args, target, targetClass);
            if (cacheOperation instanceof CacheableOperation) {
                cacheables.add(opContext);
            }
            if (cacheOperation instanceof CacheEvictOperation) {
                evicts.add(opContext);
            }
            if (!(cacheOperation instanceof CachePutOperation)) continue;
            updates.add(opContext);
        }
        map.put(CACHEABLE, cacheables);
        map.put(EVICT, evicts);
        map.put(UPDATE, updates);
        return map;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class CacheOperationContext {
        private final CacheOperation operation;
        private final Collection<Cache> caches;
        private final Object target;
        private final Method method;
        private final Object[] args;
        private final EvaluationContext evalContext;

        public CacheOperationContext(CacheOperation operation, Method method, Object[] args, Object target, Class<?> targetClass) {
            this.operation = operation;
            this.caches = CacheAspectSupport.this.getCaches(operation);
            this.target = target;
            this.method = method;
            this.args = args;
            this.evalContext = CacheAspectSupport.this.evaluator.createEvaluationContext(this.caches, method, args, target, targetClass);
        }

        protected boolean isConditionPassing() {
            if (StringUtils.hasText((String)this.operation.getCondition())) {
                return CacheAspectSupport.this.evaluator.condition(this.operation.getCondition(), this.method, this.evalContext);
            }
            return true;
        }

        protected Object generateKey() {
            if (StringUtils.hasText((String)this.operation.getKey())) {
                return CacheAspectSupport.this.evaluator.key(this.operation.getKey(), this.method, this.evalContext);
            }
            return CacheAspectSupport.this.keyGenerator.generate(this.target, this.method, this.args);
        }

        protected Collection<Cache> getCaches() {
            return this.caches;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CacheStatus {
        final Map<CacheOperationContext, Object> cUpdates;
        final boolean updateRequired;
        final Object retVal;

        CacheStatus(Map<CacheOperationContext, Object> cUpdates, boolean updateRequired, Object retVal) {
            this.cUpdates = cUpdates;
            this.updateRequired = updateRequired;
            this.retVal = retVal;
        }
    }

    public static interface Invoker {
        public Object invoke();
    }
}

