/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.interceptor;

import java.lang.reflect.Method;
import java.util.Map;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LazyParamAwareEvaluationContext
extends StandardEvaluationContext {
    private final ParameterNameDiscoverer paramDiscoverer;
    private final Method method;
    private final Object[] args;
    private final Class<?> targetClass;
    private final Map<String, Method> methodCache;
    private boolean paramLoaded = false;

    LazyParamAwareEvaluationContext(Object rootObject, ParameterNameDiscoverer paramDiscoverer, Method method, Object[] args, Class<?> targetClass, Map<String, Method> methodCache) {
        super(rootObject);
        this.paramDiscoverer = paramDiscoverer;
        this.method = method;
        this.args = args;
        this.targetClass = targetClass;
        this.methodCache = methodCache;
    }

    @Override
    public Object lookupVariable(String name) {
        Object variable = super.lookupVariable(name);
        if (variable != null) {
            return variable;
        }
        if (!this.paramLoaded) {
            this.loadArgsAsVariables();
            this.paramLoaded = true;
            variable = super.lookupVariable(name);
        }
        return variable;
    }

    private void loadArgsAsVariables() {
        if (ObjectUtils.isEmpty((Object[])this.args)) {
            return;
        }
        String mKey = this.toString(this.method);
        Method targetMethod = this.methodCache.get(mKey);
        if (targetMethod == null) {
            targetMethod = AopUtils.getMostSpecificMethod(this.method, this.targetClass);
            if (targetMethod == null) {
                targetMethod = this.method;
            }
            this.methodCache.put(mKey, targetMethod);
        }
        int i = 0;
        while (i < this.args.length) {
            this.setVariable("a" + i, this.args[i]);
            this.setVariable("p" + i, this.args[i]);
            ++i;
        }
        String[] parameterNames = this.paramDiscoverer.getParameterNames(targetMethod);
        if (parameterNames != null) {
            int i2 = 0;
            while (i2 < parameterNames.length) {
                this.setVariable(parameterNames[i2], this.args[i2]);
                ++i2;
            }
        }
    }

    private String toString(Method m) {
        StringBuilder sb = new StringBuilder();
        sb.append(m.getDeclaringClass().getName());
        sb.append("#");
        sb.append(m.toString());
        return sb.toString();
    }
}

