/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.annotation;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.parsing.Location;
import org.springframework.beans.factory.parsing.Problem;
import org.springframework.beans.factory.parsing.ProblemReporter;
import org.springframework.beans.factory.support.BeanDefinitionReader;
import org.springframework.context.annotation.BeanMethod;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.DescriptiveResource;
import org.springframework.core.io.Resource;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.core.type.StandardAnnotationMetadata;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ConfigurationClass {
    private final AnnotationMetadata metadata;
    private final Resource resource;
    private final Map<String, Class<? extends BeanDefinitionReader>> importedResources = new LinkedHashMap<String, Class<? extends BeanDefinitionReader>>();
    private final Set<BeanMethod> beanMethods = new LinkedHashSet<BeanMethod>();
    private String beanName;
    private final boolean imported;

    public ConfigurationClass(MetadataReader metadataReader, String beanName) {
        Assert.hasText((String)beanName, (String)"bean name must not be null");
        this.metadata = metadataReader.getAnnotationMetadata();
        this.resource = metadataReader.getResource();
        this.beanName = beanName;
        this.imported = false;
    }

    public ConfigurationClass(MetadataReader metadataReader, boolean imported) {
        this.metadata = metadataReader.getAnnotationMetadata();
        this.resource = metadataReader.getResource();
        this.imported = imported;
    }

    public ConfigurationClass(Class<?> clazz, String beanName) {
        Assert.hasText((String)beanName, (String)"bean name must not be null");
        this.metadata = new StandardAnnotationMetadata(clazz, true);
        this.resource = new DescriptiveResource(clazz.toString());
        this.beanName = beanName;
        this.imported = false;
    }

    public ConfigurationClass(Class<?> clazz, boolean imported) {
        this.metadata = new StandardAnnotationMetadata(clazz, true);
        this.resource = new DescriptiveResource(clazz.toString());
        this.imported = imported;
    }

    public AnnotationMetadata getMetadata() {
        return this.metadata;
    }

    public Resource getResource() {
        return this.resource;
    }

    public String getSimpleName() {
        return ClassUtils.getShortName((String)this.getMetadata().getClassName());
    }

    public boolean isImported() {
        return this.imported;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void addBeanMethod(BeanMethod method) {
        this.beanMethods.add(method);
    }

    public Set<BeanMethod> getBeanMethods() {
        return this.beanMethods;
    }

    public void addImportedResource(String importedResource, Class<? extends BeanDefinitionReader> readerClass) {
        this.importedResources.put(importedResource, readerClass);
    }

    public Map<String, Class<? extends BeanDefinitionReader>> getImportedResources() {
        return this.importedResources;
    }

    public void validate(ProblemReporter problemReporter) {
        HashMap<String, Integer> methodNameCounts = new HashMap<String, Integer>();
        for (BeanMethod beanMethod : this.beanMethods) {
            String dClassName = beanMethod.getMetadata().getDeclaringClassName();
            String methodName = beanMethod.getMetadata().getMethodName();
            String fqMethodName = String.valueOf(dClassName) + '#' + methodName;
            Integer currentCount = (Integer)methodNameCounts.get(fqMethodName);
            int newCount = currentCount != null ? currentCount + 1 : 1;
            methodNameCounts.put(fqMethodName, newCount);
        }
        for (String methodName : methodNameCounts.keySet()) {
            int count = (Integer)methodNameCounts.get(methodName);
            if (count <= 1) continue;
            String shortMethodName = methodName.substring(methodName.indexOf(35) + 1);
            problemReporter.error(new BeanMethodOverloadingProblem(shortMethodName, count));
        }
        if (this.getMetadata().isAnnotated(Configuration.class.getName()) && this.getMetadata().isFinal()) {
            problemReporter.error(new FinalConfigurationProblem());
        }
        for (BeanMethod beanMethod : this.beanMethods) {
            beanMethod.validate(problemReporter);
        }
    }

    public boolean equals(Object other) {
        return this == other || other instanceof ConfigurationClass && this.getMetadata().getClassName().equals(((ConfigurationClass)other).getMetadata().getClassName());
    }

    public int hashCode() {
        return this.getMetadata().getClassName().hashCode();
    }

    public String toString() {
        return String.format("[ConfigurationClass:beanName=%s,resource=%s]", this.beanName, this.resource);
    }

    private class BeanMethodOverloadingProblem
    extends Problem {
        public BeanMethodOverloadingProblem(String methodName, int count) {
            super(String.format("@Configuration class '%s' has %s overloaded @Bean methods named '%s'. Only one @Bean method of a given name is allowed within each @Configuration class.", ConfigurationClass.this.getSimpleName(), count, methodName), new Location(ConfigurationClass.this.getResource(), ConfigurationClass.this.getMetadata()));
        }
    }

    private class FinalConfigurationProblem
    extends Problem {
        public FinalConfigurationProblem() {
            super(String.format("@Configuration class '%s' may not be final. Remove the final modifier to continue.", ConfigurationClass.this.getSimpleName()), new Location(ConfigurationClass.this.getResource(), ConfigurationClass.this.getMetadata()));
        }
    }
}

