/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jmx.export.assembler;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jmx.export.assembler.AbstractConfigurableMBeanInfoAssembler;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterfaceBasedMBeanInfoAssembler
extends AbstractConfigurableMBeanInfoAssembler
implements BeanClassLoaderAware,
InitializingBean {
    private Class[] managedInterfaces;
    private Properties interfaceMappings;
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private Map<String, Class[]> resolvedInterfaceMappings;

    public void setManagedInterfaces(Class[] managedInterfaces) {
        if (managedInterfaces != null) {
            Class[] classArray = managedInterfaces;
            int n = managedInterfaces.length;
            int n2 = 0;
            while (n2 < n) {
                Class ifc = classArray[n2];
                if (!ifc.isInterface()) {
                    throw new IllegalArgumentException("Management interface [" + ifc.getName() + "] is not an interface");
                }
                ++n2;
            }
        }
        this.managedInterfaces = managedInterfaces;
    }

    public void setInterfaceMappings(Properties mappings) {
        this.interfaceMappings = mappings;
    }

    @Override
    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
    }

    @Override
    public void afterPropertiesSet() {
        if (this.interfaceMappings != null) {
            this.resolvedInterfaceMappings = this.resolveInterfaceMappings(this.interfaceMappings);
        }
    }

    private Map<String, Class[]> resolveInterfaceMappings(Properties mappings) {
        HashMap<String, Class[]> resolvedMappings = new HashMap<String, Class[]>(mappings.size());
        Enumeration<?> en = mappings.propertyNames();
        while (en.hasMoreElements()) {
            String beanKey = (String)en.nextElement();
            String[] classNames = StringUtils.commaDelimitedListToStringArray((String)mappings.getProperty(beanKey));
            Class[] classes = this.resolveClassNames(classNames, beanKey);
            resolvedMappings.put(beanKey, classes);
        }
        return resolvedMappings;
    }

    private Class[] resolveClassNames(String[] classNames, String beanKey) {
        Class[] classes = new Class[classNames.length];
        int x = 0;
        while (x < classes.length) {
            Class cls = ClassUtils.resolveClassName((String)classNames[x].trim(), (ClassLoader)this.beanClassLoader);
            if (!cls.isInterface()) {
                throw new IllegalArgumentException("Class [" + classNames[x] + "] mapped to bean key [" + beanKey + "] is no interface");
            }
            classes[x] = cls;
            ++x;
        }
        return classes;
    }

    @Override
    protected boolean includeReadAttribute(Method method, String beanKey) {
        return this.isPublicInInterface(method, beanKey);
    }

    @Override
    protected boolean includeWriteAttribute(Method method, String beanKey) {
        return this.isPublicInInterface(method, beanKey);
    }

    @Override
    protected boolean includeOperation(Method method, String beanKey) {
        return this.isPublicInInterface(method, beanKey);
    }

    private boolean isPublicInInterface(Method method, String beanKey) {
        return (method.getModifiers() & 1) > 0 && this.isDeclaredInInterface(method, beanKey);
    }

    private boolean isDeclaredInInterface(Method method, String beanKey) {
        Class[] ifaces = null;
        if (this.resolvedInterfaceMappings != null) {
            ifaces = this.resolvedInterfaceMappings.get(beanKey);
        }
        if (ifaces == null && (ifaces = this.managedInterfaces) == null) {
            ifaces = ClassUtils.getAllInterfacesForClass(method.getDeclaringClass());
        }
        if (ifaces != null) {
            Class[] classArray = ifaces;
            int n = ifaces.length;
            int n2 = 0;
            while (n2 < n) {
                Class ifc = classArray[n2];
                Method[] methodArray = ifc.getMethods();
                int n3 = methodArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Method ifcMethod = methodArray[n4];
                    if (ifcMethod.getName().equals(method.getName()) && Arrays.equals(ifcMethod.getParameterTypes(), method.getParameterTypes())) {
                        return true;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return false;
    }
}

