/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.annotation;

import java.lang.annotation.Annotation;
import java.util.concurrent.Executor;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.framework.AopInfrastructureBean;
import org.springframework.aop.framework.ProxyConfig;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.scheduling.annotation.AsyncAnnotationAdvisor;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncAnnotationBeanPostProcessor
extends ProxyConfig
implements BeanPostProcessor,
BeanClassLoaderAware,
BeanFactoryAware,
InitializingBean,
Ordered {
    private Class<? extends Annotation> asyncAnnotationType;
    private Executor executor;
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private AsyncAnnotationAdvisor asyncAnnotationAdvisor;
    private int order = Integer.MAX_VALUE;
    private BeanFactory beanFactory;

    public void setAsyncAnnotationType(Class<? extends Annotation> asyncAnnotationType) {
        Assert.notNull(asyncAnnotationType, (String)"'asyncAnnotationType' must not be null");
        this.asyncAnnotationType = asyncAnnotationType;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    @Override
    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    @Override
    public void afterPropertiesSet() {
        AsyncAnnotationAdvisor asyncAnnotationAdvisor = this.asyncAnnotationAdvisor = this.executor != null ? new AsyncAnnotationAdvisor(this.executor) : new AsyncAnnotationAdvisor();
        if (this.asyncAnnotationType != null) {
            this.asyncAnnotationAdvisor.setAsyncAnnotationType(this.asyncAnnotationType);
        }
        this.asyncAnnotationAdvisor.setBeanFactory(this.beanFactory);
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        if (bean instanceof AopInfrastructureBean) {
            return bean;
        }
        Class<?> targetClass = AopUtils.getTargetClass(bean);
        if (AopUtils.canApply(this.asyncAnnotationAdvisor, targetClass)) {
            if (bean instanceof Advised) {
                ((Advised)bean).addAdvisor(0, this.asyncAnnotationAdvisor);
                return bean;
            }
            ProxyFactory proxyFactory = new ProxyFactory(bean);
            proxyFactory.copyFrom(this);
            proxyFactory.addAdvisor(this.asyncAnnotationAdvisor);
            return proxyFactory.getProxy(this.beanClassLoader);
        }
        return bean;
    }
}

