/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.config;

import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.JdkVersion;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskExecutorFactoryBean
implements FactoryBean<TaskExecutor>,
BeanNameAware,
InitializingBean,
DisposableBean {
    private String poolSize;
    private Integer queueCapacity;
    private Object rejectedExecutionHandler;
    private Integer keepAliveSeconds;
    private String beanName;
    private TaskExecutor target;

    public void setPoolSize(String poolSize) {
        this.poolSize = poolSize;
    }

    public void setQueueCapacity(int queueCapacity) {
        this.queueCapacity = queueCapacity;
    }

    public void setRejectedExecutionHandler(Object rejectedExecutionHandler) {
        this.rejectedExecutionHandler = rejectedExecutionHandler;
    }

    public void setKeepAliveSeconds(int keepAliveSeconds) {
        this.keepAliveSeconds = keepAliveSeconds;
    }

    @Override
    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Class<ThreadPoolTaskExecutor> executorClass = this.shouldUseBackport() ? this.getClass().getClassLoader().loadClass("org.springframework.scheduling.backportconcurrent.ThreadPoolTaskExecutor") : ThreadPoolTaskExecutor.class;
        BeanWrapperImpl bw = new BeanWrapperImpl(executorClass);
        this.determinePoolSizeRange((BeanWrapper)bw);
        if (this.queueCapacity != null) {
            bw.setPropertyValue("queueCapacity", (Object)this.queueCapacity);
        }
        if (this.keepAliveSeconds != null) {
            bw.setPropertyValue("keepAliveSeconds", (Object)this.keepAliveSeconds);
        }
        if (this.rejectedExecutionHandler != null) {
            bw.setPropertyValue("rejectedExecutionHandler", this.rejectedExecutionHandler);
        }
        if (this.beanName != null) {
            bw.setPropertyValue("threadNamePrefix", (Object)(String.valueOf(this.beanName) + "-"));
        }
        this.target = (TaskExecutor)bw.getWrappedInstance();
        if (this.target instanceof InitializingBean) {
            ((InitializingBean)this.target).afterPropertiesSet();
        }
    }

    private boolean shouldUseBackport() {
        return StringUtils.hasText((String)this.poolSize) && this.poolSize.startsWith("0") && JdkVersion.getMajorJavaVersion() < 3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void determinePoolSizeRange(BeanWrapper bw) {
        if (!StringUtils.hasText((String)this.poolSize)) return;
        try {
            int maxPoolSize;
            int corePoolSize;
            int separatorIndex = this.poolSize.indexOf(45);
            if (separatorIndex != -1) {
                corePoolSize = Integer.valueOf(this.poolSize.substring(0, separatorIndex));
                if (corePoolSize > (maxPoolSize = Integer.valueOf(this.poolSize.substring(separatorIndex + 1, this.poolSize.length())).intValue())) {
                    throw new IllegalArgumentException("Lower bound of pool-size range must not exceed the upper bound");
                }
                if (this.queueCapacity == null) {
                    if (corePoolSize != 0) throw new IllegalArgumentException("A non-zero lower bound for the size range requires a queue-capacity value");
                    bw.setPropertyValue("allowCoreThreadTimeOut", (Object)true);
                    corePoolSize = maxPoolSize;
                }
            } else {
                Integer value = Integer.valueOf(this.poolSize);
                corePoolSize = value;
                maxPoolSize = value;
            }
            bw.setPropertyValue("corePoolSize", (Object)corePoolSize);
            bw.setPropertyValue("maxPoolSize", (Object)maxPoolSize);
            return;
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Invalid pool-size value [" + this.poolSize + "]: only single " + "maximum integer (e.g. \"5\") and minimum-maximum range (e.g. \"3-5\") are supported", ex);
        }
    }

    @Override
    public TaskExecutor getObject() {
        return this.target;
    }

    @Override
    public Class<? extends TaskExecutor> getObjectType() {
        if (this.target != null) {
            return this.target.getClass();
        }
        return !this.shouldUseBackport() ? ThreadPoolTaskExecutor.class : TaskExecutor.class;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    public void destroy() throws Exception {
        if (this.target instanceof DisposableBean) {
            ((DisposableBean)this.target).destroy();
        }
    }
}

