/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.adaptor;

import java.lang.reflect.Method;
import org.openeuler.adaptor.AdapterBase;
import sun.security.x509.AlgorithmId;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

public class X509CertImplAdapter
extends AdapterBase {
    private static final String NAME = "x509";
    private static final String INFO = "info";
    private static final String SIG_ALG = "x509.algorithm";
    private static final String IMPL_CLASS = "sun.security.x509.X509CertImpl";
    private static Method get;
    private static Method getSigAlg;
    private static Method getInfo;
    private static final Class<?> proxyClass;

    public X509CertImplAdapter(X509CertImpl cert) {
        this.proxy = cert;
    }

    private static void init() throws InstantiationException, IllegalAccessException, NoSuchMethodException {
        if (proxyClass == null) {
            return;
        }
        try {
            get = proxyClass.getDeclaredMethod("get", String.class);
        }
        catch (NoSuchMethodException e) {
            getSigAlg = proxyClass.getDeclaredMethod("getSigAlg", new Class[0]);
            getInfo = proxyClass.getDeclaredMethod("getInfo", new Class[0]);
        }
    }

    public AlgorithmId getSigAlg() {
        this.ensureAvailable();
        if (get != null) {
            return (AlgorithmId)this.invoke(get, SIG_ALG);
        }
        return (AlgorithmId)this.invoke(getSigAlg, new Object[0]);
    }

    public X509CertInfo getInfo() {
        this.ensureAvailable();
        if (get != null) {
            return (X509CertInfo)this.invoke(get, "x509.info");
        }
        return (X509CertInfo)this.invoke(getInfo, new Object[0]);
    }

    static {
        try {
            proxyClass = Class.forName(IMPL_CLASS, true, null);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        try {
            X509CertImplAdapter.init();
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            exception = e;
        }
    }
}

