/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.jcajce.provider.asymmetric.ec.KeyPairGeneratorSpi;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SM2KeyPairGenerator
extends java.security.KeyPairGeneratorSpi {
    private static final int SM2P256V1_KEY_SIZE = 256;
    private static final int WAPIP192V1_KEY_SIZE = 192;
    private static Map<Integer, ECGenParameterSpec> ecGenParameterSpecMap;
    private KeyPairGeneratorSpi keyPairGenerator = new KeyPairGeneratorSpi.EC("SM2", BouncyCastleProvider.CONFIGURATION);
    private boolean isInitialized;

    private static void initECGenParameterSpecMap() {
        ecGenParameterSpecMap = new HashMap<Integer, ECGenParameterSpec>();
        ecGenParameterSpecMap.put(256, new ECGenParameterSpec("sm2p256v1"));
        ecGenParameterSpecMap.put(192, new ECGenParameterSpec("wapip192v1"));
    }

    @Override
    public void initialize(int keysize, SecureRandom random) {
        ECGenParameterSpec ecGenParameterSpec = ecGenParameterSpecMap.get(keysize);
        if (ecGenParameterSpec == null) {
            throw new InvalidParameterException("Unknown key size.");
        }
        try {
            this.initialize(ecGenParameterSpec, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InvalidParameterException(e.getMessage());
        }
    }

    @Override
    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        this.keyPairGenerator.initialize(params, random);
        this.isInitialized = true;
    }

    @Override
    public KeyPair generateKeyPair() {
        if (!this.isInitialized) {
            this.initialize(256, new SecureRandom());
        }
        return this.keyPairGenerator.generateKeyPair();
    }

    static {
        SM2KeyPairGenerator.initECGenParameterSpecMap();
    }
}

