/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.com.sun.crypto.provider;

import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;

abstract class PBES2Parameters
extends AlgorithmParametersSpi {
    private static final int[] HMAC_WITH_SM3 = new int[]{1, 2, 156, 10197, 1, 401, 2};
    private static final int[] SM4_128_ECB = new int[]{1, 2, 156, 10197, 1, 104, 1};
    private static final int[] SM4_128_CBC = new int[]{1, 2, 156, 10197, 1, 104, 2};
    private static final int[] GMT_0091_2020_PBKDF2 = new int[]{1, 2, 156, 10197, 6, 1, 4, 1, 5, 1};
    private static final int[] GMT_0091_2020_HMAC_WITH_SM3 = new int[]{1, 2, 156, 10197, 1, 401, 3, 1};
    private static final int[] GMT_0091_2020_SM4_128_CBC = new int[]{1, 2, 156, 10197, 6, 1, 4, 1, 12, 1, 1};
    private static ObjectIdentifier HMAC_WITH_SM3_OID;
    private static ObjectIdentifier SM4_128_ECB_OID;
    private static ObjectIdentifier SM4_128_CBC_OID;
    private static ObjectIdentifier GMT_0091_2020_PBKDF2_OID;
    private static ObjectIdentifier GMT_0091_2020_HMAC_WITH_SM3_OID;
    private static ObjectIdentifier GMT_0091_2020_SM4_128_CBC_OID;
    private static Set<ObjectIdentifier> SM4_CBC_OID_SET;
    private static Set<ObjectIdentifier> HMAC_WITH_SM3_OID_SET;
    private String pbes2AlgorithmName = null;
    private byte[] salt = null;
    private int iCount = 0;
    private AlgorithmParameterSpec cipherParam = null;
    private ObjectIdentifier kdfAlgo_OID = HMAC_WITH_SM3_OID;
    private ObjectIdentifier cipherAlgo_OID = null;
    private int keysize = -1;
    private String mode;
    private String padding;

    PBES2Parameters() {
    }

    PBES2Parameters(String pbes2AlgorithmName) throws NoSuchAlgorithmException {
        this(pbes2AlgorithmName, null, null);
    }

    PBES2Parameters(String pbes2AlgorithmName, String mode, String padding) throws NoSuchAlgorithmException {
        int and;
        this.mode = mode;
        this.padding = padding;
        String kdfAlgo = null;
        String cipherAlgo = null;
        if (pbes2AlgorithmName.startsWith("PBEWith") && (and = pbes2AlgorithmName.indexOf("And", 8)) > 0) {
            kdfAlgo = pbes2AlgorithmName.substring(7, and);
            cipherAlgo = pbes2AlgorithmName.substring(and + 3);
            int underscore = cipherAlgo.indexOf(95);
            if (underscore > 0) {
                int slash = cipherAlgo.indexOf(47, underscore + 1);
                this.keysize = slash > 0 ? Integer.parseInt(cipherAlgo.substring(underscore + 1, slash)) : Integer.parseInt(cipherAlgo.substring(underscore + 1));
                cipherAlgo = cipherAlgo.substring(0, underscore);
            }
        } else {
            throw new NoSuchAlgorithmException("No crypto implementation for " + pbes2AlgorithmName);
        }
        StringBuilder algorithmBuilder = new StringBuilder(pbes2AlgorithmName);
        if (this.mode != null) {
            algorithmBuilder.append("/").append(this.mode);
        }
        if (this.padding != null) {
            algorithmBuilder.append("/").append(this.padding);
        }
        this.pbes2AlgorithmName = algorithmBuilder.toString();
        if (!"HmacSM3".equals(kdfAlgo)) {
            throw new NoSuchAlgorithmException("No crypto implementation for " + kdfAlgo);
        }
        this.kdfAlgo_OID = GMT_0091_2020_HMAC_WITH_SM3_OID;
        if (!"SM4".equals(cipherAlgo)) {
            throw new NoSuchAlgorithmException("No Cipher implementation for " + cipherAlgo);
        }
        if (this.keysize != 128) {
            throw new NoSuchAlgorithmException("No Cipher implementation for " + this.keysize + "-bit " + cipherAlgo);
        }
        if ("ECB".equals(this.mode)) {
            this.cipherAlgo_OID = SM4_128_ECB_OID;
        } else if ("CBC".equals(this.mode)) {
            this.cipherAlgo_OID = GMT_0091_2020_SM4_128_CBC_OID;
        } else {
            throw new NoSuchAlgorithmException("No Cipher implementation for " + this.mode + " " + cipherAlgo);
        }
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        if (!(paramSpec instanceof PBEParameterSpec)) {
            throw new InvalidParameterSpecException("Inappropriate parameter specification");
        }
        this.salt = (byte[])((PBEParameterSpec)paramSpec).getSalt().clone();
        this.iCount = ((PBEParameterSpec)paramSpec).getIterationCount();
        this.cipherParam = ((PBEParameterSpec)paramSpec).getParameterSpec();
    }

    @Override
    protected void engineInit(byte[] encoded) throws IOException {
        String kdfAlgo = null;
        String cipherAlgo = null;
        DerValue pBES2_params = new DerValue(encoded);
        if (pBES2_params.tag != 48) {
            throw new IOException("PBE parameter parsing error: not an ASN.1 SEQUENCE tag");
        }
        DerValue kdf = pBES2_params.data.getDerValue();
        if (kdf.getTag() == 6) {
            pBES2_params = pBES2_params.data.getDerValue();
            kdf = pBES2_params.data.getDerValue();
        }
        kdfAlgo = this.parseKDF(kdf);
        if (pBES2_params.tag != 48) {
            throw new IOException("PBE parameter parsing error: not an ASN.1 SEQUENCE tag");
        }
        cipherAlgo = this.parseES(pBES2_params.data.getDerValue());
        StringBuilder algorithmBuilder = new StringBuilder().append("PBEWith").append(kdfAlgo).append("And").append(cipherAlgo);
        if (this.mode != null) {
            algorithmBuilder.append("/").append(this.mode);
        }
        if (this.padding != null) {
            algorithmBuilder.append("/").append(this.padding);
        }
        this.pbes2AlgorithmName = algorithmBuilder.toString();
    }

    private String parseKDF(DerValue keyDerivationFunc) throws IOException {
        if (!GMT_0091_2020_PBKDF2_OID.equals(keyDerivationFunc.data.getOID())) {
            throw new IOException("PBE parameter parsing error: expecting the object identifier for PBKDF2");
        }
        if (keyDerivationFunc.tag != 48) {
            throw new IOException("PBE parameter parsing error: not an ASN.1 SEQUENCE tag");
        }
        DerValue pBKDF2_params = keyDerivationFunc.data.getDerValue();
        if (pBKDF2_params.tag != 48) {
            throw new IOException("PBE parameter parsing error: not an ASN.1 SEQUENCE tag");
        }
        DerValue specified = pBKDF2_params.data.getDerValue();
        if (specified.tag != 4) {
            throw new IOException("PBE parameter parsing error: not an ASN.1 OCTET STRING tag");
        }
        this.salt = specified.getOctetString();
        this.iCount = pBKDF2_params.data.getInteger();
        DerValue prf = null;
        if (pBKDF2_params.data.available() > 0) {
            DerValue keyLength = pBKDF2_params.data.getDerValue();
            if (keyLength.tag == 2) {
                this.keysize = keyLength.getInteger() * 8;
            } else {
                prf = keyLength;
            }
        }
        String kdfAlgo = "HmacSM3";
        if (prf == null && pBKDF2_params.data.available() > 0) {
            prf = pBKDF2_params.data.getDerValue();
        }
        if (prf != null) {
            this.kdfAlgo_OID = prf.data.getOID();
            if (!HMAC_WITH_SM3_OID_SET.contains(this.kdfAlgo_OID)) {
                throw new IOException("PBE parameter parsing error: expecting the object identifier for a HmacSHA key derivation function");
            }
            kdfAlgo = "HmacSM3";
            if (prf.data.available() != 0) {
                DerValue parameter = prf.data.getDerValue();
                if (parameter.tag != 5) {
                    throw new IOException("PBE parameter parsing error: not an ASN.1 NULL tag");
                }
            }
        }
        return kdfAlgo;
    }

    private String parseES(DerValue encryptionScheme) throws IOException {
        String cipherAlgo = null;
        this.cipherAlgo_OID = encryptionScheme.data.getOID();
        if (SM4_128_ECB_OID.equals(this.cipherAlgo_OID)) {
            cipherAlgo = "SM4_128";
            this.keysize = 128;
            this.mode = "ECB";
            this.padding = "PKCS5Padding";
        } else if (SM4_CBC_OID_SET.contains(this.cipherAlgo_OID)) {
            cipherAlgo = "SM4_128";
            this.cipherParam = new IvParameterSpec(encryptionScheme.data.getOctetString());
            this.keysize = 128;
            this.mode = "CBC";
            this.padding = "PKCS5Padding";
        } else {
            throw new IOException("PBE parameter parsing error: expecting the object identifier for AES cipher");
        }
        return cipherAlgo;
    }

    @Override
    protected void engineInit(byte[] encoded, String decodingMethod) throws IOException {
        this.engineInit(encoded);
    }

    @Override
    protected <T extends AlgorithmParameterSpec> T engineGetParameterSpec(Class<T> paramSpec) throws InvalidParameterSpecException {
        if (PBEParameterSpec.class.isAssignableFrom(paramSpec)) {
            return (T)((AlgorithmParameterSpec)paramSpec.cast(new PBEParameterSpec(this.salt, this.iCount, this.cipherParam)));
        }
        throw new InvalidParameterSpecException("Inappropriate parameter specification");
    }

    @Override
    protected byte[] engineGetEncoded() throws IOException {
        DerOutputStream out = new DerOutputStream();
        DerOutputStream pBES2_params = new DerOutputStream();
        DerOutputStream keyDerivationFunc = new DerOutputStream();
        keyDerivationFunc.putOID(GMT_0091_2020_PBKDF2_OID);
        DerOutputStream pBKDF2_params = new DerOutputStream();
        pBKDF2_params.putOctetString(this.salt);
        pBKDF2_params.putInteger(this.iCount);
        if (this.keysize > 0) {
            pBKDF2_params.putInteger(this.keysize / 8);
        }
        DerOutputStream prf = new DerOutputStream();
        prf.putOID(this.kdfAlgo_OID);
        prf.putNull();
        pBKDF2_params.write((byte)48, prf);
        keyDerivationFunc.write((byte)48, pBKDF2_params);
        pBES2_params.write((byte)48, keyDerivationFunc);
        DerOutputStream encryptionScheme = new DerOutputStream();
        encryptionScheme.putOID(this.cipherAlgo_OID);
        if (this.cipherParam != null && this.cipherParam instanceof IvParameterSpec) {
            encryptionScheme.putOctetString(((IvParameterSpec)this.cipherParam).getIV());
        } else if (SM4_128_ECB_OID.equals(this.cipherAlgo_OID)) {
            encryptionScheme.putOctetString(new byte[0]);
        } else {
            throw new IOException("Wrong parameter type: IV expected");
        }
        pBES2_params.write((byte)48, encryptionScheme);
        out.write((byte)48, pBES2_params);
        return out.toByteArray();
    }

    @Override
    protected byte[] engineGetEncoded(String encodingMethod) throws IOException {
        return this.engineGetEncoded();
    }

    @Override
    protected String engineToString() {
        return this.pbes2AlgorithmName;
    }

    static {
        try {
            HMAC_WITH_SM3_OID = new ObjectIdentifier(HMAC_WITH_SM3);
            SM4_128_ECB_OID = new ObjectIdentifier(SM4_128_ECB);
            SM4_128_CBC_OID = new ObjectIdentifier(SM4_128_CBC);
            GMT_0091_2020_PBKDF2_OID = new ObjectIdentifier(GMT_0091_2020_PBKDF2);
            GMT_0091_2020_HMAC_WITH_SM3_OID = new ObjectIdentifier(GMT_0091_2020_HMAC_WITH_SM3);
            GMT_0091_2020_SM4_128_CBC_OID = new ObjectIdentifier(GMT_0091_2020_SM4_128_CBC);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        SM4_CBC_OID_SET = new HashSet<ObjectIdentifier>(Arrays.asList(SM4_128_CBC_OID, GMT_0091_2020_SM4_128_CBC_OID));
        HMAC_WITH_SM3_OID_SET = new HashSet<ObjectIdentifier>(Arrays.asList(HMAC_WITH_SM3_OID, GMT_0091_2020_HMAC_WITH_SM3_OID));
    }

    public static final class HmacSM3AndSM4_128_CBC_PKCS5Padding
    extends PBES2Parameters {
        public HmacSM3AndSM4_128_CBC_PKCS5Padding() throws NoSuchAlgorithmException {
            super("PBEWithHmacSM3AndSM4_128", "CBC", "PKCS5Padding");
        }
    }

    public static final class HmacSM3AndSM4_128_ECB_PKCS5Padding
    extends PBES2Parameters {
        public HmacSM3AndSM4_128_ECB_PKCS5Padding() throws NoSuchAlgorithmException {
            super("PBEWithHmacSM3AndSM4_128", "ECB", "PKCS5Padding");
        }
    }

    public static final class General
    extends PBES2Parameters {
    }
}

