/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.Map;
import java.util.Properties;
import org.openeuler.CompatibleOracleJdkHandler;
import org.openeuler.ObjectIdentifierHandler;
import sun.security.x509.AlgorithmId;

public class BGMJCEProvider
extends Provider {
    private static final String OID_PKCS5_GM_PBES2 = "1.2.156.10197.6.1.4.1.5.2";

    private static void initNameTable() {
        try {
            Field nameTableFiled = AlgorithmId.class.getDeclaredField("nameTable");
            nameTableFiled.setAccessible(true);
            Object object = nameTableFiled.get(null);
            if (!(object instanceof Map)) {
                return;
            }
            Map nameTable = (Map)object;
            nameTable.put(ObjectIdentifierHandler.newObjectIdentifier("1.2.156.10197.1.401"), "SM3");
        }
        catch (IOException | IllegalAccessException | NoSuchFieldException exception) {
            // empty catch block
        }
    }

    public static SecureRandom getRandom() {
        return SecureRandomHolder.RANDOM;
    }

    public BGMJCEProvider() {
        super("BGMJCEProvider", 1.8, "BGMJCEProvider");
        BGMJCEProvider.putEntries(this);
        CompatibleOracleJdkHandler.skipJarVerify(this);
    }

    private static Properties getProp() {
        Properties props = new Properties();
        String bgmproviderConf = System.getProperty("bgmprovider.conf");
        if (bgmproviderConf == null) {
            return props;
        }
        File propFile = new File(bgmproviderConf);
        if (propFile.exists()) {
            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(propFile));){
                props.load(is);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return props;
    }

    static void putEntries(Map<Object, Object> map) {
        Properties props = BGMJCEProvider.getProp();
        if (!"false".equalsIgnoreCase(props.getProperty("jce.sm2"))) {
            BGMJCEProvider.putSM2(map);
        }
        if (!"false".equalsIgnoreCase(props.getProperty("jce.sm3"))) {
            BGMJCEProvider.putSM3(map);
        }
        if (!"false".equalsIgnoreCase(props.getProperty("jce.sm4"))) {
            BGMJCEProvider.putSM4(map);
        }
        if (!"false".equalsIgnoreCase(props.getProperty("jce.hmacSM3"))) {
            BGMJCEProvider.putHmacSM3(map);
        }
        if (!"false".equalsIgnoreCase(props.getProperty("jce.signatureSM2withSM2"))) {
            BGMJCEProvider.putSignatureSM3withSM2(map);
        }
        if (!"false".equalsIgnoreCase(props.getProperty("jce.keypairGenerator"))) {
            BGMJCEProvider.putKeyPairGenerator(map);
        }
        if (!"false".equalsIgnoreCase(props.getProperty("jce.algorithmParameters"))) {
            BGMJCEProvider.putAlgorithmParameters(map);
        }
        if (!"false".equalsIgnoreCase(props.getProperty("jce.pbes2"))) {
            BGMJCEProvider.putPBES2Algorithm(map);
        }
    }

    private static void putSM4(Map<Object, Object> map) {
        map.put("Cipher.SM4", "org.bouncycastle.jcajce.provider.symmetric.SM4$ECB");
        map.put("AlgorithmParameters.SM4", "org.bouncycastle.jcajce.provider.symmetric.SM4$AlgParams");
        map.put("AlgorithmParameterGenerator.SM4", "org.bouncycastle.jcajce.provider.symmetric.SM4$AlgParams$AlgParamGen");
        map.put("KeyGenerator.SM4", "org.bouncycastle.jcajce.provider.symmetric.SM4$AlgParams$KeyGen");
    }

    private static void putSM3(Map<Object, Object> map) {
        map.put("MessageDigest.SM3", "org.bouncycastle.jcajce.provider.digest.SM3$Digest");
        map.put("Alg.Alias.MessageDigest.OID.1.2.156.10197.1.401", "SM3");
        map.put("Alg.Alias.MessageDigest.1.2.156.10197.1.401", "SM3");
    }

    private static void putHmacSM3(Map<Object, Object> map) {
        map.put("Mac.HmacSM3", "org.bouncycastle.jcajce.provider.digest.SM3$HashMac");
        map.put("KeyGenerator.HmacSM3", "org.bouncycastle.jcajce.provider.digest.SM3$KeyGenerator");
    }

    private static void putSignatureSM3withSM2(Map<Object, Object> map) {
        map.put("Signature.SM3withSM2", "org.bouncycastle.jcajce.provider.asymmetric.ec.GMSignatureSpi$sm3WithSM2");
        map.put("Alg.Alias.Signature.1.2.156.10197.1.501", "SM3withSM2");
        map.put("Alg.Alias.Signature.OID.1.2.156.10197.1.501", "SM3withSM2");
    }

    private static void putSM2(Map<Object, Object> map) {
        map.put("Cipher.SM2", "org.openeuler.SM2Cipher");
        map.put("KeyPairGenerator.SM2", "org.openeuler.SM2KeyPairGenerator");
        map.put("KeyAgreement.SM2", "org.openeuler.SM2KeyAgreement");
        map.put("KeyFactory.EC", "org.bouncycastle.jcajce.provider.asymmetric.ec.KeyFactorySpi$EC");
        map.put("Alg.Alias.KeyFactory.SM2", "EC");
        map.put("Alg.Alias.KeyFactory.1.2.840.10045.2.1", "EC");
        map.put("Alg.Alias.KeyFactory.OID.1.2.840.10045.2.1", "EC");
    }

    private static void putKeyPairGenerator(Map<Object, Object> map) {
        map.put("KeyPairGenerator.EC", "org.bouncycastle.jcajce.provider.asymmetric.ec.KeyPairGeneratorSpi$EC");
    }

    private static void putAlgorithmParameters(Map<Object, Object> map) {
        map.put("AlgorithmParameters.EC", "org.bouncycastle.jcajce.provider.asymmetric.ec.AlgorithmParametersSpi");
        map.put("Alg.Alias.AlgorithmParameters.1.2.840.10045.2.1", "EC");
        map.put("Alg.Alias.AlgorithmParameters.OID.1.2.840.10045.2.1", "EC");
    }

    private static void putPBES2Algorithm(Map<Object, Object> map) {
        map.put("AlgorithmParameters.GMPBES2", "org.openeuler.com.sun.crypto.provider.PBES2Parameters$General");
        map.put("Alg.Alias.AlgorithmParameters.OID1.2.156.10197.6.1.4.1.5.2", "GMPBES2");
        map.put("Alg.Alias.AlgorithmParameters.1.2.156.10197.6.1.4.1.5.2", "GMPBES2");
        map.put("AlgorithmParameters.PBEWithHmacSM3AndSM4_128/ECB/PKCS5Padding", "org.openeuler.com.sun.crypto.provider.PBES2Parameters$HmacSM3AndSM4_128_ECB_PKCS5Padding");
        map.put("AlgorithmParameters.PBEWithHmacSM3AndSM4_128/CBC/PKCS5Padding", "org.openeuler.com.sun.crypto.provider.PBES2Parameters$HmacSM3AndSM4_128_CBC_PKCS5Padding");
        map.put("Alg.Alias.AlgorithmParameters.PBEWithHmacSM3AndSM4_CBC", "PBEWithHmacSM3AndSM4_128/CBC/PKCS5Padding");
        map.put("Cipher.PBEWithHmacSM3AndSM4_128/ECB/PKCS5Padding", "org.openeuler.com.sun.crypto.provider.PBES2Core$HmacSM3AndSM4_128_ECB_PKCS5Padding");
        map.put("Cipher.PBEWithHmacSM3AndSM4_128/CBC/PKCS5Padding", "org.openeuler.com.sun.crypto.provider.PBES2Core$HmacSM3AndSM4_128_CBC_PKCS5Padding");
        map.put("Alg.Alias.Cipher.PBEWithHmacSM3AndSM4_CBC", "PBEWithHmacSM3AndSM4_128/CBC/PKCS5Padding");
        map.put("SecretKeyFactory.PBKDF2WithHmacSM3", "org.openeuler.com.sun.crypto.provider.PBKDF2Core$HmacSM3");
        map.put("SecretKeyFactory.PBEWithHmacSM3AndSM4_128/ECB/PKCS5Padding", "org.openeuler.com.sun.crypto.provider.PBEKeyFactory$PBEWithHmacSM3AndSM4_128_ECB_PKCS5Padding");
        map.put("SecretKeyFactory.PBEWithHmacSM3AndSM4_128/CBC/PKCS5Padding", "org.openeuler.com.sun.crypto.provider.PBEKeyFactory$PBEWithHmacSM3AndSM4_128_CBC_PKCS5Padding");
        map.put("Alg.Alias.SecretKeyFactory.PBEWithHmacSM3AndSM4_CBC", "PBEWithHmacSM3AndSM4_128/CBC/PKCS5Padding");
        map.put("Mac.HmacPBESM3", "org.openeuler.com.sun.crypto.provider.HmacPKCS12PBECore$HmacPKCS12PBESM3");
    }

    static {
        BGMJCEProvider.initNameTable();
    }

    private static class SecureRandomHolder {
        static final SecureRandom RANDOM = new SecureRandom();

        private SecureRandomHolder() {
        }
    }
}

