/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.util.HashMap;
import java.util.Map;
import org.openeuler.sun.security.ec.BGECPrivateKey;
import org.openeuler.sun.security.ec.BGECPublicKey;
import org.openeuler.util.GMUtil;
import org.openeuler.util.Util;
import sun.security.jca.JCAUtil;
import sun.security.util.ECUtil;

public final class SM2KeyPairGenerator
extends KeyPairGeneratorSpi {
    private SecureRandom random;
    private AlgorithmParameterSpec params = null;
    private static final int SM2P256V1_KEY_SIZE = 256;
    private static Map<Integer, ECGenParameterSpec> ecGenParameterSpecMap;

    private static void initECGenParameterSpecMap() {
        ecGenParameterSpecMap = new HashMap<Integer, ECGenParameterSpec>();
        ecGenParameterSpecMap.put(256, new ECGenParameterSpec("sm2p256v1"));
    }

    public SM2KeyPairGenerator() {
        this.initialize(256, null);
    }

    @Override
    public void initialize(int keySize, SecureRandom random) {
        ECGenParameterSpec ecGenParameterSpec = ecGenParameterSpecMap.get(keySize);
        if (ecGenParameterSpec == null) {
            throw new InvalidParameterException("Unknown key size, the sm2 algorithm only supports sm2p256v1 and wapip192v1 curve");
        }
        try {
            this.initialize(ecGenParameterSpec, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InvalidParameterException(e.getMessage());
        }
    }

    @Override
    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        ECParameterSpec ecSpec;
        if (!GMUtil.isSM2Curve(params)) {
            throw new InvalidAlgorithmParameterException("Not a GM curve : " + (params instanceof ECGenParameterSpec ? ((ECGenParameterSpec)params).getName() : params));
        }
        if (params instanceof ECParameterSpec) {
            ECParameterSpec ecParams = (ECParameterSpec)params;
            ecSpec = ECUtil.getECParameterSpec(null, ecParams);
            if (ecSpec == null) {
                throw new InvalidAlgorithmParameterException("Unsupported curve: " + params);
            }
        } else if (params instanceof ECGenParameterSpec) {
            String name = ((ECGenParameterSpec)params).getName();
            ecSpec = ECUtil.getECParameterSpec(null, name);
            if (ecSpec == null) {
                throw new InvalidAlgorithmParameterException("Unknown curve name: " + name);
            }
        } else {
            throw new InvalidAlgorithmParameterException("ECParameterSpec or ECGenParameterSpec required for SM2");
        }
        this.params = ecSpec;
        this.random = random;
    }

    @Override
    public KeyPair generateKeyPair() {
        if (this.random == null) {
            this.random = JCAUtil.getSecureRandom();
        }
        try {
            BigInteger d;
            ECParameterSpec ecParams = (ECParameterSpec)this.params;
            BigInteger n = ((ECParameterSpec)this.params).getOrder();
            int nBitLength = n.bitLength();
            BigInteger limit = n.subtract(BigInteger.ONE);
            while ((d = Util.createRandomBigInteger(nBitLength, this.random)).compareTo(BigInteger.ONE) < 0 || d.compareTo(limit) >= 0) {
            }
            ECPoint w = GMUtil.multiply(ecParams.getGenerator(), d, ecParams.getCurve());
            BGECPrivateKey privateKey = new BGECPrivateKey(d, ecParams);
            BGECPublicKey publicKey = new BGECPublicKey(w, ecParams);
            return new KeyPair(publicKey, privateKey);
        }
        catch (Exception ex) {
            throw new ProviderException(ex);
        }
    }

    static {
        SM2KeyPairGenerator.initECGenParameterSpecMap();
    }
}

