/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.sm4;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import org.openeuler.sm4.SM4Padding;
import org.openeuler.sm4.SM4Util;

public class SM4BaseCipher
extends CipherSpi {
    protected boolean isInitialized = false;
    protected final int BLOCKSIZE = 16;
    protected int opmode;
    protected SM4Padding padding = new SM4Padding();
    protected SM4Util sm4 = new SM4Util();
    protected byte[] inputUpdate;
    protected int inputLenUpdate;
    protected int inputOffsetUpdate;
    protected int len;
    protected int[] rk;

    @Override
    protected void engineUpdateAAD(byte[] src, int offset, int len) {
        super.engineUpdateAAD(src, offset, len);
    }

    @Override
    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        throw new NoSuchAlgorithmException();
    }

    @Override
    public void engineSetPadding(String padding) throws NoSuchPaddingException {
        this.padding.setPadding(padding);
    }

    @Override
    protected int engineGetBlockSize() {
        return 16;
    }

    @Override
    public int engineGetOutputSize(int inputLen) {
        if (this.opmode == 1) {
            if (!this.padding.getPadding().equalsIgnoreCase("NOPADDING")) {
                return inputLen + (16 - inputLen % 16);
            }
            if (inputLen % 16 != 0) {
                return 0;
            }
            return inputLen;
        }
        if (this.opmode == 2) {
            if (inputLen % 16 != 0) {
                return 0;
            }
            return inputLen;
        }
        return 0;
    }

    @Override
    public byte[] engineGetIV() {
        return null;
    }

    @Override
    public AlgorithmParameters engineGetParameters() {
        return null;
    }

    @Override
    public void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        this.init(opmode, key);
    }

    @Override
    public void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.init(opmode, key);
    }

    @Override
    public void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.init(opmode, key);
    }

    protected void init(int opmode, Key key) throws InvalidKeyException {
        if (!(key instanceof SecretKey) || key.getEncoded().length != 16) {
            throw new InvalidKeyException();
        }
        this.opmode = opmode;
        this.rk = this.sm4.expandKey(key.getEncoded());
    }

    @Override
    public byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        return null;
    }

    @Override
    public int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        return 0;
    }

    @Override
    public byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        return null;
    }

    @Override
    public int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return 0;
    }

    public void reset() {
        this.inputUpdate = null;
        this.inputLenUpdate = 0;
        this.len = 0;
    }
}

