/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.ECKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import org.openeuler.ConstructKeys;
import org.openeuler.SM2Point;
import org.openeuler.sun.security.ec.BGECPrivateKey;
import org.openeuler.sun.security.ec.BGECPublicKey;
import org.openeuler.util.GMUtil;
import org.openeuler.util.Util;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ECUtil;

public class SM2Cipher
extends CipherSpi {
    private ByteArrayOutputStream byteBuf = new ByteArrayOutputStream();
    private MessageDigest digest = MessageDigest.getInstance("SM3");
    private SecureRandom random;
    private ECKey ecKey;
    private Mode outputMode = Mode.C1C3C2;
    private int cipherMode = -1;
    private int curveLength;

    @Override
    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        String modeName = mode.toUpperCase();
        if (!modeName.equals("NONE")) {
            throw new IllegalArgumentException("can't support mode " + mode);
        }
    }

    @Override
    protected void engineSetPadding(String padding) throws NoSuchPaddingException {
        String paddingName = padding.toUpperCase();
        if (!paddingName.equals("NOPADDING")) {
            throw new NoSuchPaddingException("padding not available with SM2Cipher");
        }
    }

    @Override
    protected int engineGetBlockSize() {
        return 0;
    }

    @Override
    protected int engineGetOutputSize(int inputLen) {
        throw new UnsupportedOperationException("engineGetOutputSize");
    }

    @Override
    protected byte[] engineGetIV() {
        return null;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    @Override
    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        if (key == null) {
            throw new InvalidKeyException("Key cannot be null");
        }
        byte[] encoded = key.getEncoded();
        if (encoded == null || encoded.length == 0) {
            throw new InvalidKeyException("Cannot get an encoding of the key to be wrapped");
        }
        try {
            return this.engineDoFinal(encoded, 0, encoded.length);
        }
        catch (BadPaddingException e) {
            throw new InvalidKeyException("Wrapping failed", e);
        }
    }

    @Override
    protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        byte[] unWrappedKey;
        if (wrappedKey == null || wrappedKey.length == 0) {
            throw new InvalidKeyException("The wrappedKey cannot be null or empty");
        }
        try {
            unWrappedKey = this.engineDoFinal(wrappedKey, 0, wrappedKey.length);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new InvalidKeyException("Unwrapping failed", e);
        }
        return ConstructKeys.constructKey(unWrappedKey, wrappedKeyAlgorithm, wrappedKeyType);
    }

    @Override
    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this.engineInit(opmode, key, (AlgorithmParameterSpec)null, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new IllegalArgumentException("Parameters not supported: " + e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (opmode == 1 || opmode == 3) {
            if (key instanceof BGECPublicKey) {
                this.ecKey = (BGECPublicKey)key;
            } else {
                if (!(key instanceof ECPublicKey)) throw new InvalidKeyException("must be passed public EC key for encryption");
                this.ecKey = (ECPublicKey)key;
            }
        } else {
            if (opmode != 2 && opmode != 4) throw new InvalidParameterException("wrong cipher mode, must be ENCRYPT_MODE or WRAP_MODE or DECRYPT_MODE or UNWRAP_MODE");
            if (key instanceof BGECPrivateKey) {
                this.ecKey = (BGECPrivateKey)key;
            } else {
                if (!(key instanceof ECPrivateKey)) throw new InvalidKeyException("must be passed private EC key for decryption");
                this.ecKey = (ECPrivateKey)key;
            }
        }
        this.random = random == null ? new SecureRandom() : random;
        this.curveLength = (this.ecKey.getParams().getCurve().getField().getFieldSize() + 7) / 8;
        this.cipherMode = opmode;
        this.byteBuf.reset();
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (params != null) {
            throw new InvalidAlgorithmParameterException("Parameters not supported: " + params.getClass());
        }
    }

    @Override
    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        this.byteBuf.write(input, inputOffset, inputLen);
        return null;
    }

    @Override
    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        this.engineUpdate(input, inputOffset, inputLen);
        return 0;
    }

    @Override
    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        block11: {
            if (inputLen != 0) {
                this.byteBuf.write(input, inputOffset, inputLen);
            }
            if (this.cipherMode == 1 || this.cipherMode == 3) {
                try {
                    byte[] byArray = this.encrypt(this.byteBuf.toByteArray(), 0, this.byteBuf.size());
                    return byArray;
                }
                catch (Exception e) {
                    throw new RuntimeException("decryption failed: " + e.getMessage());
                }
            }
            if (this.cipherMode != 2 && this.cipherMode != 4) break block11;
            try {
                byte[] e = this.decrypt(this.byteBuf.toByteArray(), 0, this.byteBuf.size());
                return e;
            }
            catch (Exception e) {
                throw new RuntimeException("decryption failed: " + e.getMessage());
            }
        }
        throw new IllegalStateException("cipher not initialised");
        finally {
            this.byteBuf.reset();
        }
    }

    @Override
    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        byte[] buffer = this.engineDoFinal(input, inputOffset, inputLen);
        System.arraycopy(buffer, 0, output, outputOffset, buffer.length);
        return buffer.length;
    }

    private byte[] encrypt(byte[] input, int inputOffset, int inputLen) throws IOException, InvalidKeyException {
        ECPoint c1Point;
        byte[] y2;
        BigInteger k;
        ECPoint kPb;
        byte[] x2;
        byte[] z;
        byte[] t;
        ECParameterSpec ecParameterSpec = this.ecKey.getParams();
        EllipticCurve curve = ecParameterSpec.getCurve();
        ECPoint Pb = ((ECPublicKey)this.ecKey).getW();
        ECPoint s = GMUtil.multiply(Pb, ecParameterSpec.getCofactor(), curve);
        if (s.equals(ECPoint.POINT_INFINITY)) {
            throw new InvalidKeyException("[h]Pb at infinity");
        }
        do {
            int nBitLen;
            BigInteger n = ecParameterSpec.getOrder();
            while ((k = Util.createRandomBigInteger(nBitLen = n.bitLength(), this.random)).compareTo(BigInteger.ONE) < 0 || k.compareTo(n) >= 0) {
            }
            c1Point = GMUtil.multiply(ecParameterSpec.getGenerator(), k, curve);
            byte[] c1 = ECUtil.encodePoint(c1Point, curve);
        } while (this.isAllZero(t = this.KDF(z = Util.concatenate(x2 = Util.asUnsignedByteArray(this.curveLength, (kPb = GMUtil.multiply(Pb, k, curve)).getAffineX()), y2 = Util.asUnsignedByteArray(this.curveLength, kPb.getAffineY())), inputLen)));
        byte[] c2 = new byte[inputLen];
        for (int i = 0; i < inputLen; ++i) {
            c2[i] = (byte)(input[inputOffset + i] ^ t[i]);
        }
        this.digest.update(x2);
        this.digest.update(input, inputOffset, inputLen);
        this.digest.update(y2);
        byte[] c3 = this.digest.digest();
        DerOutputStream out = new DerOutputStream();
        out.putInteger(c1Point.getAffineX());
        out.putInteger(c1Point.getAffineY());
        if (this.outputMode == Mode.C1C3C2) {
            out.putOctetString(c3);
            out.putOctetString(c2);
        } else if (this.outputMode == Mode.C1C2C3) {
            out.putOctetString(c2);
            out.putOctetString(c3);
        }
        DerValue result = new DerValue(48, out.toByteArray());
        try {
            return result.toByteArray();
        }
        catch (IOException e) {
            throw new IOException("DERSequence getEncoded failed", e);
        }
    }

    private byte[] decrypt(byte[] input, int inputOffset, int inputLen) throws IOException, InvalidKeyException {
        byte[] y2;
        byte[] c2;
        byte[] c3;
        byte[] bytes = new byte[inputLen];
        System.arraycopy(input, inputOffset, bytes, 0, inputLen);
        DerInputStream inDer = new DerInputStream(bytes, inputOffset, inputLen, false);
        DerValue[] values = inDer.getSequence(2);
        if (values.length != 4 || inDer.available() != 0) {
            throw new IOException("Invalid encoding for signature");
        }
        BigInteger x = values[0].getPositiveBigInteger();
        BigInteger y = values[1].getPositiveBigInteger();
        SM2Point c1Point = new SM2Point(x, y);
        ECParameterSpec ecParameterSpec = ((ECPrivateKey)this.ecKey).getParams();
        EllipticCurve curve = ecParameterSpec.getCurve();
        byte[] c1 = ECUtil.encodePoint(c1Point, curve);
        if (this.outputMode == Mode.C1C3C2) {
            c3 = values[2].getOctetString();
            c2 = values[3].getOctetString();
        } else {
            c2 = values[2].getOctetString();
            c3 = values[3].getOctetString();
        }
        if (!GMUtil.checkECPoint(c1Point, curve)) {
            throw new InvalidKeyException("C1 does not satisfy the curve equation");
        }
        ECPoint s = GMUtil.multiply((ECPoint)c1Point, ecParameterSpec.getCofactor(), curve);
        if (s.equals(ECPoint.POINT_INFINITY)) {
            throw new InvalidKeyException("[h]C1 at infinity");
        }
        ECPoint temp = GMUtil.multiply((ECPoint)c1Point, ((ECPrivateKey)this.ecKey).getS(), curve);
        byte[] x2 = Util.asUnsignedByteArray(this.curveLength, temp.getAffineX());
        byte[] z = Util.concatenate(x2, y2 = Util.asUnsignedByteArray(this.curveLength, temp.getAffineY()));
        byte[] t = this.KDF(z, c2.length);
        if (this.isAllZero(t)) {
            throw new InvalidKeyException("invalid cipher text");
        }
        byte[] m_ = new byte[c2.length];
        for (int i = 0; i < c2.length; ++i) {
            m_[i] = (byte)(c2[i] ^ t[i]);
        }
        this.digest.update(x2);
        this.digest.update(m_);
        this.digest.update(y2);
        byte[] u = this.digest.digest();
        if (Arrays.equals(u, c3)) {
            return m_;
        }
        throw new InvalidKeyException("invalid cipher text");
    }

    private byte[] KDF(byte[] z, int klen) {
        int digestSize = this.digest.getDigestLength();
        byte[] k = new byte[klen];
        byte[] ctBuf = new byte[4];
        int off = 0;
        int ct = 1;
        while (off < klen) {
            Util.intToBigEndian(ct++, ctBuf, 0);
            this.digest.update(z);
            this.digest.update(ctBuf);
            byte[] hash = this.digest.digest();
            if (klen - off >= digestSize) {
                System.arraycopy(hash, 0, k, off, digestSize);
                off += digestSize;
                continue;
            }
            System.arraycopy(hash, 0, k, off, klen - off);
            off = klen;
        }
        return k;
    }

    private boolean isAllZero(byte[] t) {
        for (byte b : t) {
            if (b == 0) continue;
            return false;
        }
        return true;
    }

    public static enum Mode {
        C1C2C3,
        C1C3C2;

    }
}

