/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.com.sun.crypto.provider;

import java.io.ByteArrayOutputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.util.Arrays;
import javax.crypto.AEADBadTagException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;
import org.openeuler.com.sun.crypto.provider.CipherBlockChaining;
import org.openeuler.com.sun.crypto.provider.CounterMode;
import org.openeuler.com.sun.crypto.provider.FeedbackCipher;
import org.openeuler.com.sun.crypto.provider.SymmetricCipher;
import org.openeuler.util.Util;

final class CBCMacCounterMode
extends FeedbackCipher {
    static final int DEFAULT_TAG_LEN = 8;
    static final int DEFAULT_IV_LEN = 12;
    private int M = 8;
    private int L;
    private FeedbackCipher cbcFeedbackCipher;
    private FeedbackCipher ctrFeedbackCipher;
    private ByteArrayOutputStream aadBuffer = new ByteArrayOutputStream();
    private ByteArrayOutputStream dataBuffer = new ByteArrayOutputStream();
    private byte[] aadBufferSave;
    private byte[] dataBufferSave;

    private CBCMacCounterMode(SymmetricCipher embeddedCipher, FeedbackCipher cbcFeedbackCipher, FeedbackCipher ctrFeedbackCipher) {
        super(embeddedCipher);
        this.cbcFeedbackCipher = cbcFeedbackCipher;
        this.ctrFeedbackCipher = ctrFeedbackCipher;
    }

    CBCMacCounterMode(SymmetricCipher embeddedCipher) {
        this(embeddedCipher, new CipherBlockChaining(embeddedCipher), new CounterMode(embeddedCipher));
    }

    @Override
    String getFeedback() {
        return "CCM";
    }

    @Override
    void save() {
        this.aadBufferSave = this.aadBuffer.toByteArray();
        this.dataBufferSave = this.dataBuffer.toByteArray();
    }

    @Override
    void restore() {
        this.aadBuffer.reset();
        this.aadBuffer.write(this.aadBufferSave, 0, this.aadBufferSave.length);
        this.dataBuffer.reset();
        this.dataBuffer.write(this.dataBufferSave, 0, this.dataBufferSave.length);
    }

    @Override
    void init(boolean decrypting, String algorithm, byte[] key, byte[] iv) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.init(decrypting, algorithm, key, iv, 8);
    }

    void init(boolean decrypting, String algorithm, byte[] key, byte[] iv, int tagLen) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.iv = (byte[])iv.clone();
        this.M = tagLen;
        this.L = 15 - this.iv.length;
        byte[] ivBytes = new byte[this.blockSize];
        this.cbcFeedbackCipher.init(decrypting, algorithm, key, ivBytes);
        byte[] A0 = this.getA_0();
        this.ctrFeedbackCipher.init(decrypting, algorithm, key, A0);
    }

    @Override
    void updateAAD(byte[] src, int offset, int len) {
        if (this.aadBuffer == null) {
            throw new IllegalStateException("Update has been called; no more AAD data");
        }
        this.aadBuffer.write(src, offset, len);
    }

    @Override
    void reset() {
        this.dataBuffer.reset();
        this.aadBuffer.reset();
        this.cbcFeedbackCipher.reset();
        this.ctrFeedbackCipher.reset();
    }

    @Override
    int encrypt(byte[] plain, int plainOffset, int plainLen, byte[] cipher, int cipherOffset) {
        this.update(plain, plainOffset, plainLen);
        return 0;
    }

    @Override
    int decrypt(byte[] cipher, int cipherOffset, int cipherLen, byte[] plain, int plainOffset) {
        this.update(cipher, cipherOffset, cipherLen);
        return 0;
    }

    void update(byte[] input, int inputOffset, int inputLen) {
        if (input == null || inputLen <= 0) {
            return;
        }
        this.dataBuffer.write(input, inputOffset, inputLen);
    }

    @Override
    int encryptFinal(byte[] plain, int plainOffset, int plainLen, byte[] cipher, int cipherOffset) throws IllegalBlockSizeException, ShortBufferException {
        byte[] X;
        this.encrypt(plain, plainOffset, plainLen, cipher, cipherOffset);
        byte[] dataBytes = this.dataBuffer.toByteArray();
        this.checkDataLength(dataBytes.length);
        try {
            X = this.getX(dataBytes);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
        byte[] E_X = new byte[X.length];
        this.ctrFeedbackCipher.encrypt(X, 0, X.length, E_X, 0);
        byte[] U = new byte[this.M];
        System.arraycopy(E_X, 0, U, 0, U.length);
        int encryptLen = this.ctrFeedbackCipher.encrypt(dataBytes, 0, dataBytes.length, cipher, cipherOffset);
        System.arraycopy(U, 0, cipher, cipherOffset + encryptLen, U.length);
        return encryptLen += U.length;
    }

    @Override
    int decryptFinal(byte[] cipher, int cipherOffset, int cipherLen, byte[] plain, int plainOffset) throws IllegalBlockSizeException, AEADBadTagException, ShortBufferException {
        byte[] X;
        this.decrypt(cipher, cipherOffset, cipherLen, plain, plainOffset);
        byte[] cipherBytes = this.dataBuffer.toByteArray();
        int dataLen = cipherBytes.length - this.M;
        this.checkDataLength(dataLen);
        byte[] U = new byte[this.blockSize];
        System.arraycopy(cipherBytes, dataLen, U, 0, this.M);
        byte[] X_D = new byte[U.length];
        this.ctrFeedbackCipher.decrypt(U, 0, U.length, X_D, 0);
        int decryptLen = this.ctrFeedbackCipher.decrypt(cipherBytes, 0, dataLen, plain, plainOffset);
        byte[] dataBytes = new byte[decryptLen];
        System.arraycopy(plain, plainOffset, dataBytes, 0, dataBytes.length);
        try {
            X = this.getX(dataBytes);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
        this.checkT(X, X_D);
        return decryptLen;
    }

    private void checkT(byte[] X, byte[] X_D) throws AEADBadTagException {
        for (int i = 0; i < this.M; ++i) {
            if (X[i] == X_D[i]) continue;
            throw new AEADBadTagException("mac check in CCM failed");
        }
    }

    private void checkDataLength(int dataLen) throws ShortBufferException {
        int limitLen;
        if (this.L < 4 && dataLen >= (limitLen = 1 << 8 * this.L)) {
            throw new IllegalStateException("CCM packet too large for choice of L");
        }
    }

    private byte[] getA_0() {
        return this.getA_i(0);
    }

    private byte[] getA_i(int num) {
        byte[] A = new byte[this.blockSize];
        A[0] = (byte)(this.L - 1 & 7);
        System.arraycopy(this.iv, 0, A, 1, this.iv.length);
        for (int i = 0; i < num; ++i) {
            CBCMacCounterMode.increment(A);
        }
        return A;
    }

    private static void increment(byte[] b) {
        int n = b.length - 1;
        while (n >= 0) {
            int n2 = n--;
            b[n2] = (byte)(b[n2] + 1);
            if (b[n2] == 0) continue;
        }
    }

    private byte[] getX(byte[] dataBytes) throws InvalidAlgorithmParameterException, InvalidKeyException {
        int plainOffset;
        byte[] newBytes;
        int totalLen;
        byte[] aadLenBytes;
        int dataLen = dataBytes.length;
        byte[] B0 = this.getAuthB_0(dataLen);
        int aadLen = this.aadBuffer.size();
        if (aadLen == 0) {
            aadLenBytes = new byte[]{};
        } else if (aadLen < 65280) {
            aadLenBytes = new byte[2];
            Util.shortToBigEndian((short)aadLen, aadLenBytes, 0);
        } else {
            aadLenBytes = new byte[6];
            aadLenBytes[0] = -1;
            aadLenBytes[1] = -2;
            Util.intToBigEndian(aadLen, aadLenBytes, 2);
        }
        byte[] aadBytes = this.aadBuffer.toByteArray();
        byte[] cipherBytes = new byte[this.blockSize];
        this.cbcFeedbackCipher.encrypt(B0, 0, B0.length, cipherBytes, 0);
        if (aadLenBytes.length > 0) {
            totalLen = CBCMacCounterMode.getPaddingLen(aadLenBytes.length + aadLen, this.blockSize);
            newBytes = new byte[totalLen];
            System.arraycopy(aadLenBytes, 0, newBytes, 0, aadLenBytes.length);
            System.arraycopy(aadBytes, 0, newBytes, aadLenBytes.length, aadBytes.length);
            for (plainOffset = 0; plainOffset < newBytes.length; plainOffset += this.blockSize) {
                this.cbcFeedbackCipher.encrypt(newBytes, plainOffset, this.blockSize, cipherBytes, 0);
            }
        }
        if (dataLen > 0) {
            totalLen = CBCMacCounterMode.getPaddingLen(dataLen, this.blockSize);
            newBytes = totalLen == dataLen ? dataBytes : Arrays.copyOf(dataBytes, totalLen);
            for (plainOffset = 0; plainOffset < newBytes.length; plainOffset += this.blockSize) {
                this.cbcFeedbackCipher.encrypt(newBytes, plainOffset, this.blockSize, cipherBytes, 0);
            }
        }
        return cipherBytes;
    }

    private static int getPaddingLen(int len, int blockSize) {
        int newLen = len;
        if (newLen % blockSize != 0) {
            newLen = (newLen / blockSize + 1) * blockSize;
        }
        return newLen;
    }

    private byte[] getAuthB_0(int dataLen) {
        byte[] B = new byte[16];
        B[0] = this.getAuthFlags();
        System.arraycopy(this.iv, 0, B, 1, this.iv.length);
        int lm = dataLen;
        int count = 1;
        while (lm > 0) {
            B[B.length - count] = (byte)(lm & 0xFF);
            lm >>>= 8;
            ++count;
        }
        return B;
    }

    private byte getAuthFlags() {
        byte flags = 0;
        if (this.aadBuffer.size() > 0) {
            flags = (byte)(flags | 0x40);
        }
        flags = (byte)(flags | ((this.M - 2) / 2 & 7) << 3);
        flags = (byte)(flags | this.L - 1 & 7);
        return flags;
    }

    public int getTagLen() {
        return this.M;
    }

    @Override
    int getBufferedLength() {
        return this.dataBuffer.size();
    }
}

