/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.com.sun.crypto.provider;

import java.security.InvalidKeyException;
import org.openeuler.com.sun.crypto.provider.SM4Constants;
import org.openeuler.com.sun.crypto.provider.SymmetricCipher;
import org.openeuler.sm4.SM4Util;

public class SM4Crypt
extends SymmetricCipher {
    private SM4Util sm4Util;
    private int[] rk;

    @Override
    int getBlockSize() {
        return 16;
    }

    @Override
    void init(boolean decrypting, String algorithm, byte[] key) throws InvalidKeyException {
        this.sm4Util = new SM4Util();
        this.rk = this.sm4Util.expandKey(key);
    }

    @Override
    void encryptBlock(byte[] plain, int plainOffset, byte[] cipher, int cipherOffset) {
        this.sm4Util.encrypt(this.rk, plain, plainOffset, cipher, cipherOffset);
    }

    @Override
    void decryptBlock(byte[] cipher, int cipherOffset, byte[] plain, int plainOffset) {
        this.sm4Util.decrypt(this.rk, cipher, cipherOffset, plain, plainOffset);
    }

    static final boolean isKeySizeValid(int len) {
        for (int i = 0; i < SM4Constants.SM4_KEYSIZES.length; ++i) {
            if (len != SM4Constants.SM4_KEYSIZES[i]) continue;
            return true;
        }
        return false;
    }
}

