/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.sun.misc;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.openeuler.gm.GMTlsUtil;

public class SharedSecrets {
    private static final int VERSION_8 = 8;
    private static final int VERSION_11 = 11;
    private static Method getJavaNetAccessMethod;
    private static Method getOriginalHostNameMethod;
    private static Exception exception;

    private static void init() {
        int javaVersion = GMTlsUtil.javaVersion();
        try {
            Class<?> javaNetAccessClass;
            if (javaVersion == 8) {
                Class<?> sharedSecretsClass = Class.forName("sun.misc.SharedSecrets");
                javaNetAccessClass = Class.forName("sun.misc.JavaNetAccess");
                getJavaNetAccessMethod = sharedSecretsClass.getDeclaredMethod("getJavaNetAccess", new Class[0]);
            } else if (javaVersion == 11) {
                Class<?> sharedSecretsClass = Class.forName("jdk.internal.misc.SharedSecrets");
                javaNetAccessClass = Class.forName("jdk.internal.misc.JavaNetInetAddressAccess");
                getJavaNetAccessMethod = sharedSecretsClass.getDeclaredMethod("getJavaNetInetAddressAccess", new Class[0]);
            } else {
                throw new IllegalArgumentException("Unsupported jdk " + javaVersion);
            }
            getOriginalHostNameMethod = javaNetAccessClass.getDeclaredMethod("getOriginalHostName", InetAddress.class);
            getOriginalHostNameMethod.setAccessible(true);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            exception = e;
        }
    }

    private static Object getJavaNetAccess() throws InvocationTargetException, IllegalAccessException {
        return getJavaNetAccessMethod.invoke(null, new Object[0]);
    }

    public static String getOriginalHostName(InetAddress ia) {
        if (exception != null) {
            throw new AssertionError((Object)exception);
        }
        try {
            Object javaNetAccess = SharedSecrets.getJavaNetAccess();
            return (String)getOriginalHostNameMethod.invoke(javaNetAccess, ia);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                SharedSecrets.init();
                return null;
            }
        });
    }
}

