/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler;

import java.security.Provider;
import org.openeuler.BGMJSSEConfig;
import org.openeuler.provider.AbstractEntries;

class BGMJSSEEntries
extends AbstractEntries {
    BGMJSSEEntries(Provider provider) {
        super(provider);
    }

    protected void putServices(Provider provider) {
        if (BGMJSSEConfig.enableKeyManagerFactory()) {
            this.putKeyManagerFactory(provider);
        }
        if (BGMJSSEConfig.enableTrustManagerFactory()) {
            this.putTrustManagerFactory(provider);
        }
        if (BGMJSSEConfig.enableKeyGenerator()) {
            this.putKeyGenerator(provider);
        }
        if (BGMJSSEConfig.enableSSLContext()) {
            this.putSSLContext(provider);
        }
        if (BGMJSSEConfig.enableKeyStore()) {
            this.putKeyStore(provider);
        }
    }

    private void putKeyManagerFactory(Provider provider) {
        this.add(provider, "KeyManagerFactory", "SunX509", "org.openeuler.sun.security.ssl.KeyManagerFactoryImpl$SunX509");
        this.add(provider, "KeyManagerFactory", "NewSunX509", "org.openeuler.sun.security.ssl.KeyManagerFactoryImpl$X509", BGMJSSEEntries.createAliases((String[])new String[]{"PKIX"}));
    }

    private void putTrustManagerFactory(Provider provider) {
        this.add(provider, "TrustManagerFactory", "SunX509", "org.openeuler.sun.security.ssl.TrustManagerFactoryImpl$SimpleFactory");
        this.add(provider, "TrustManagerFactory", "PKIX", "org.openeuler.sun.security.ssl.TrustManagerFactoryImpl$PKIXFactory", BGMJSSEEntries.createAliases((String[])new String[]{"SunPKIX", "X509", "X.509"}));
    }

    private void putKeyGenerator(Provider provider) {
        this.add(provider, "KeyGenerator", "SunTlsPrf", "org.openeuler.com.sun.crypto.provider.TlsPrfGenerator$V10");
        this.add(provider, "KeyGenerator", "SunTls12Prf", "org.openeuler.com.sun.crypto.provider.TlsPrfGenerator$V12");
        this.add(provider, "KeyGenerator", "SunTlsMasterSecret", "org.openeuler.com.sun.crypto.provider.TlsMasterSecretGenerator", BGMJSSEEntries.createAliases((String[])new String[]{"SunTls12MasterSecret", "SunTlsExtendedMasterSecret"}));
        this.add(provider, "KeyGenerator", "SunTlsKeyMaterial", "org.openeuler.com.sun.crypto.provider.TlsKeyMaterialGenerator", BGMJSSEEntries.createAliases((String[])new String[]{"SunTls12KeyMaterial"}));
        this.add(provider, "KeyGenerator", "GMTlsPrf", "org.openeuler.gm.GMTlsPrfGenerator");
        this.add(provider, "KeyGenerator", "GMTlsMasterSecret", "org.openeuler.gm.GMTlsMasterSecretGenerator");
        this.add(provider, "KeyGenerator", "GMTlsKeyMaterial", "org.openeuler.gm.GMTlsKeyMaterialGenerator");
        this.add(provider, "KeyAgreement", "GmTlsEccPremasterSecret", "org.openeuler.sun.security.ssl.ECCKeyAgreement");
    }

    private void putSSLContext(Provider provider) {
        this.add(provider, "SSLContext", "GMTLS", "org.openeuler.sun.security.ssl.SSLContextImpl$GMTLSContext");
        this.add(provider, "SSLContext", "TLSv1", "org.openeuler.sun.security.ssl.SSLContextImpl$TLS10Context", BGMJSSEEntries.createAliases((String[])new String[]{"SSLv3"}));
        this.add(provider, "SSLContext", "TLSv1.1", "org.openeuler.sun.security.ssl.SSLContextImpl$TLS11Context");
        this.add(provider, "SSLContext", "TLSv1.2", "org.openeuler.sun.security.ssl.SSLContextImpl$TLS12Context");
        this.add(provider, "SSLContext", "TLSv1.3", "org.openeuler.sun.security.ssl.SSLContextImpl$TLS13Context");
        this.add(provider, "SSLContext", "TLS", "org.openeuler.sun.security.ssl.SSLContextImpl$TLSContext", BGMJSSEEntries.createAliases((String[])new String[]{"SSL"}));
        this.add(provider, "SSLContext", "Default", "org.openeuler.sun.security.ssl.SSLContextImpl$DefaultSSLContext");
    }

    private void putKeyStore(Provider provider) {
        this.add(provider, "KeyStore", "PKCS12", "org.openeuler.gm.KeyStoreResolver$DualFormatPKCS12");
        this.add(provider, "KeyStore", "JKS", "org.openeuler.gm.KeyStoreResolver$DualFormatJKS");
    }
}

