/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.sun.security.ssl;

import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import org.openeuler.spec.ECCPremasterSecretKeySpec;
import org.openeuler.sun.security.internal.spec.TlsECCKeyAgreementParameterSpec;
import org.openeuler.sun.security.ssl.JsseJce;
import org.openeuler.sun.security.ssl.SSLLogger;
import sun.security.util.KeyUtil;

public class ECCKeyAgreement
extends KeyAgreementSpi {
    private static final String MSG = "ECCKeyAgreement must be initialized using a TlsECCKeyAgreementParameterSpec";
    private TlsECCKeyAgreementParameterSpec spec;
    private SecureRandom random;
    private Key key;
    private static final int ECC_PREMASTER_KEY_LEN = 48;

    @Override
    protected void engineInit(Key key, SecureRandom random) throws InvalidKeyException {
        throw new UnsupportedOperationException(MSG);
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (!(params instanceof TlsECCKeyAgreementParameterSpec)) {
            throw new InvalidAlgorithmParameterException(MSG);
        }
        this.key = key;
        this.spec = (TlsECCKeyAgreementParameterSpec)params;
        this.random = random;
    }

    @Override
    protected Key engineDoPhase(Key key, boolean lastPhase) throws IllegalStateException {
        throw new UnsupportedOperationException("ECCKeyAgreement not support engineDoPhase.");
    }

    @Override
    protected byte[] engineGenerateSecret() throws IllegalStateException {
        throw new UnsupportedOperationException("ECCKeyAgreement.engineGenerateSecret not support the return byte[].");
    }

    @Override
    protected int engineGenerateSecret(byte[] sharedSecret, int offset) throws IllegalStateException {
        throw new UnsupportedOperationException("ECCKeyAgreement.engineGenerateSecret not support the return int.");
    }

    @Override
    protected SecretKey engineGenerateSecret(String algorithm) throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        byte[] encryptedKey;
        byte[] premasterSecret;
        if (this.spec == null) {
            throw new IllegalStateException("ECCKeyAgreement.TlsECCKeyAgreementParameterSpec must be initialized");
        }
        try {
            if (this.spec.isClient()) {
                byte[] premasterSecret2 = this.generatePreMasterSecret(this.spec.getMajorVersion(), this.spec.getMinorVersion(), null);
                byte[] encryptedKey2 = this.encryptSecret(premasterSecret2);
                return new ECCPremasterSecretKeySpec(premasterSecret2, "TlsEccPremasterSecret", encryptedKey2);
            }
            premasterSecret = this.decryptSecret();
            encryptedKey = this.spec.getEncryptedSecret();
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException(e.getMessage(), e.getCause());
        }
        return new ECCPremasterSecretKeySpec(premasterSecret, "TlsEccPremasterSecret", encryptedKey);
    }

    private byte[] encryptSecret(byte[] premasterSecret) throws NoSuchAlgorithmException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        if (this.key == null) {
            throw new IllegalStateException("Key must be initialized");
        }
        if (!(this.key instanceof PublicKey)) {
            throw new IllegalStateException("decode need PublicKey");
        }
        Cipher cipher = JsseJce.getCipher("SM2");
        cipher.init(1, this.key, this.random);
        return cipher.doFinal(premasterSecret);
    }

    private byte[] generatePreMasterSecret(int clientVersion, int serverVersion, byte[] encodedSecret) {
        if (encodedSecret == null) {
            if (this.random == null) {
                this.random = new SecureRandom();
            }
            encodedSecret = new byte[48];
            this.random.nextBytes(encodedSecret);
        }
        encodedSecret[0] = (byte)clientVersion;
        encodedSecret[1] = (byte)serverVersion;
        return encodedSecret;
    }

    private byte[] decryptSecret() throws GeneralSecurityException {
        byte[] preMaster;
        block7: {
            if (this.key == null) {
                throw new IllegalStateException("Key must be initialized");
            }
            if (!(this.key instanceof PrivateKey)) {
                throw new IllegalStateException("decode need PrivateKey");
            }
            if (this.spec.getEncryptedSecret() == null) {
                throw new IllegalStateException("TlsECCKeyAgreementParameterSpec.encryptedSecret must be initialized");
            }
            byte[] encoded = null;
            preMaster = null;
            Cipher cipher = JsseJce.getCipher("SM2");
            try {
                cipher.init(2, this.key);
                boolean failed = false;
                try {
                    encoded = cipher.doFinal(this.spec.getEncryptedSecret());
                }
                catch (BadPaddingException bpe) {
                    failed = true;
                }
                encoded = KeyUtil.checkTlsPreMasterSecretKey(this.spec.getClientVersion(), this.spec.getServerVersion(), this.random, encoded, failed);
                preMaster = this.generatePreMasterSecret(this.spec.getClientVersion(), this.spec.getServerVersion(), encoded);
            }
            catch (UnsupportedOperationException | InvalidKeyException iue) {
                if (!SSLLogger.isOn || !SSLLogger.isOn("ssl,handshake")) break block7;
                SSLLogger.warning("The Cipher provider " + ECCKeyAgreement.safeProviderName(cipher) + " caused exception: " + iue.getMessage(), new Object[0]);
            }
        }
        return preMaster;
    }

    private static String safeProviderName(Cipher cipher) {
        try {
            return cipher.getProvider().toString();
        }
        catch (Exception e) {
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Retrieving The Cipher provider name caused exception ", e);
            }
            try {
                return ((Object)cipher).toString() + " (provider name not available)";
            }
            catch (Exception e2) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Retrieving The Cipher name caused exception ", e2);
                }
                return "(cipher/provider names not available)";
            }
        }
    }
}

