/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.sun.security.ssl;

import java.security.CryptoPrimitive;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.openeuler.sun.security.ssl.SSLAlgorithmConstraints;
import org.openeuler.sun.security.ssl.SSLConfiguration;

public enum ProtocolVersion {
    GMTLS(257, "GMTLS"),
    TLS13(772, "TLSv1.3"),
    TLS12(771, "TLSv1.2"),
    TLS11(770, "TLSv1.1"),
    TLS10(769, "TLSv1"),
    SSL30(768, "SSLv3"),
    SSL20Hello(2, "SSLv2Hello"),
    NONE(-1, "NONE");

    final int id;
    final String name;
    final byte major;
    final byte minor;
    final boolean isAvailable;
    static final int LIMIT_MAX_VALUE = 65535;
    static final int LIMIT_MIN_VALUE = 0;
    static final ProtocolVersion[] PROTOCOLS_TO_10;
    static final ProtocolVersion[] PROTOCOLS_TO_11;
    static final ProtocolVersion[] PROTOCOLS_TO_12;
    static final ProtocolVersion[] PROTOCOLS_TO_12_AND_GMTLS;
    static final ProtocolVersion[] PROTOCOLS_TO_13;
    static final ProtocolVersion[] PROTOCOLS_TO_13_AND_GMTLS;
    static final ProtocolVersion[] PROTOCOLS_OF_NONE;
    static final ProtocolVersion[] PROTOCOLS_OF_30;
    static final ProtocolVersion[] PROTOCOLS_OF_GMTLS;
    static final ProtocolVersion[] PROTOCOLS_OF_GMTLS_AND_12;
    static final ProtocolVersion[] PROTOCOLS_OF_11;
    static final ProtocolVersion[] PROTOCOLS_OF_12;
    static final ProtocolVersion[] PROTOCOLS_OF_13;
    static final ProtocolVersion[] PROTOCOLS_10_11;
    static final ProtocolVersion[] PROTOCOLS_11_12;
    static final ProtocolVersion[] PROTOCOLS_12_13;
    static final ProtocolVersion[] PROTOCOLS_10_12;
    static final ProtocolVersion[] PROTOCOLS_TO_TLS12;
    static final ProtocolVersion[] PROTOCOLS_TO_TLS11;
    static final ProtocolVersion[] PROTOCOLS_TO_TLS10;
    static final ProtocolVersion[] PROTOCOLS_EMPTY;
    static final ProtocolVersion[] PROTOCOLS_OF_RFC8998;

    private ProtocolVersion(int id, String name) {
        this.id = id;
        this.name = name;
        this.major = (byte)(id >>> 8 & 0xFF);
        this.minor = (byte)(id & 0xFF);
        this.isAvailable = SSLAlgorithmConstraints.DEFAULT_SSL_ONLY.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), name, null);
    }

    static ProtocolVersion valueOf(byte major, byte minor) {
        for (ProtocolVersion pv : ProtocolVersion.values()) {
            if (pv.major != major || pv.minor != minor) continue;
            return pv;
        }
        return null;
    }

    static ProtocolVersion valueOf(int id) {
        for (ProtocolVersion pv : ProtocolVersion.values()) {
            if (pv.id != id) continue;
            return pv;
        }
        return null;
    }

    static String nameOf(byte major, byte minor) {
        for (ProtocolVersion pv : ProtocolVersion.values()) {
            if (pv.major != major || pv.minor != minor) continue;
            return pv.name;
        }
        return "TLS-" + major + "." + minor;
    }

    static String nameOf(int id) {
        return ProtocolVersion.nameOf((byte)(id >>> 8 & 0xFF), (byte)(id & 0xFF));
    }

    static ProtocolVersion nameOf(String name) {
        for (ProtocolVersion pv : ProtocolVersion.values()) {
            if (!pv.name.equals(name)) continue;
            return pv;
        }
        return null;
    }

    static boolean isNegotiable(byte major, byte minor, boolean allowSSL20Hello) {
        int v = (major & 0xFF) << 8 | minor & 0xFF;
        if (v == ProtocolVersion.GMTLS.id) {
            return true;
        }
        return v >= ProtocolVersion.SSL30.id || allowSSL20Hello && v == ProtocolVersion.SSL20Hello.id;
    }

    static String[] toStringArray(List<ProtocolVersion> protocolVersions) {
        if (protocolVersions != null && !protocolVersions.isEmpty()) {
            String[] protocolNames = new String[protocolVersions.size()];
            int i = 0;
            for (ProtocolVersion pv : protocolVersions) {
                protocolNames[i++] = pv.name;
            }
            return protocolNames;
        }
        return new String[0];
    }

    static String[] toStringArray(int[] protocolVersions) {
        if (protocolVersions != null && protocolVersions.length != 0) {
            String[] protocolNames = new String[protocolVersions.length];
            int i = 0;
            for (int pv : protocolVersions) {
                protocolNames[i++] = ProtocolVersion.nameOf(pv);
            }
            return protocolNames;
        }
        return new String[0];
    }

    static List<ProtocolVersion> namesOf(String[] protocolNames) {
        if (protocolNames == null || protocolNames.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<ProtocolVersion> pvs = new ArrayList<ProtocolVersion>(protocolNames.length);
        for (String pn : protocolNames) {
            ProtocolVersion pv = ProtocolVersion.nameOf(pn);
            if (pv == null) {
                throw new IllegalArgumentException("Unsupported protocol" + pn);
            }
            pvs.add(pv);
        }
        return Collections.unmodifiableList(pvs);
    }

    static boolean useTLS12PlusSpec(String name) {
        ProtocolVersion pv = ProtocolVersion.nameOf(name);
        if (pv != null && pv != NONE) {
            return pv.id >= ProtocolVersion.TLS12.id;
        }
        return false;
    }

    int compare(ProtocolVersion that) {
        if (this == that) {
            return 0;
        }
        if (this == GMTLS) {
            return 1;
        }
        if (that == GMTLS) {
            return -1;
        }
        if (this == NONE) {
            return -1;
        }
        if (that == NONE) {
            return 1;
        }
        return this.id - that.id;
    }

    boolean useTLS13PlusSpec() {
        return this.id >= ProtocolVersion.TLS13.id;
    }

    boolean useTLS12PlusSpec() {
        return this.id >= ProtocolVersion.TLS12.id;
    }

    boolean useTLS11PlusSpec() {
        return this.id >= ProtocolVersion.TLS11.id;
    }

    boolean useTLS10PlusSpec() {
        return this.id >= ProtocolVersion.TLS10.id;
    }

    static boolean useTLS10PlusSpec(int id) {
        if (id == ProtocolVersion.GMTLS.id) {
            return true;
        }
        return id >= ProtocolVersion.TLS10.id;
    }

    static boolean useTLS13PlusSpec(int id) {
        return id >= ProtocolVersion.TLS13.id;
    }

    boolean useGMTLSSpec() {
        return this.id == ProtocolVersion.GMTLS.id;
    }

    static ProtocolVersion selectedFrom(List<ProtocolVersion> listedVersions, int suggestedVersion) {
        ProtocolVersion selectedVersion = NONE;
        for (ProtocolVersion pv : listedVersions) {
            if (pv.id == suggestedVersion) {
                return pv;
            }
            if (pv == GMTLS || pv.id >= suggestedVersion || pv.id <= selectedVersion.id) continue;
            selectedVersion = pv;
        }
        return selectedVersion;
    }

    static {
        PROTOCOLS_TO_10 = new ProtocolVersion[]{TLS10, SSL30};
        PROTOCOLS_TO_11 = new ProtocolVersion[]{TLS11, TLS10, SSL30};
        PROTOCOLS_TO_12 = new ProtocolVersion[]{TLS12, TLS11, TLS10, SSL30};
        PROTOCOLS_TO_12_AND_GMTLS = new ProtocolVersion[]{TLS12, TLS11, TLS10, SSL30, GMTLS};
        PROTOCOLS_TO_13 = new ProtocolVersion[]{TLS13, TLS12, TLS11, TLS10, SSL30};
        PROTOCOLS_TO_13_AND_GMTLS = new ProtocolVersion[]{TLS13, TLS12, TLS11, TLS10, SSL30, GMTLS};
        PROTOCOLS_OF_NONE = new ProtocolVersion[]{NONE};
        PROTOCOLS_OF_30 = new ProtocolVersion[]{SSL30};
        PROTOCOLS_OF_GMTLS = new ProtocolVersion[]{GMTLS};
        PROTOCOLS_OF_GMTLS_AND_12 = new ProtocolVersion[]{GMTLS, TLS12};
        PROTOCOLS_OF_11 = new ProtocolVersion[]{TLS11};
        PROTOCOLS_OF_12 = new ProtocolVersion[]{TLS12};
        PROTOCOLS_OF_13 = new ProtocolVersion[]{TLS13};
        PROTOCOLS_10_11 = new ProtocolVersion[]{TLS11, TLS10};
        PROTOCOLS_11_12 = new ProtocolVersion[]{TLS12, TLS11};
        PROTOCOLS_12_13 = new ProtocolVersion[]{TLS13, TLS12};
        PROTOCOLS_10_12 = new ProtocolVersion[]{TLS12, TLS11, TLS10};
        PROTOCOLS_TO_TLS12 = new ProtocolVersion[]{TLS12, TLS11, TLS10, SSL30};
        PROTOCOLS_TO_TLS11 = new ProtocolVersion[]{TLS11, TLS10, SSL30};
        PROTOCOLS_TO_TLS10 = new ProtocolVersion[]{TLS10, SSL30};
        PROTOCOLS_EMPTY = new ProtocolVersion[0];
        PROTOCOLS_OF_RFC8998 = SSLConfiguration.enableRFC8998 ? PROTOCOLS_OF_13 : PROTOCOLS_EMPTY;
    }
}

