/*
 * Decompiled with CFR 0.152.
 */
package org.openftc.easyopencv;

import android.os.Handler;
import android.os.Looper;
import android.os.Process;

public class FixedHandlerThread
extends Thread {
    int mPriority;
    int mTid = -1;
    Looper mLooper;
    Handler mHandler;

    public FixedHandlerThread(String name) {
        super(name);
        this.mPriority = 0;
    }

    public FixedHandlerThread(String name, int priority) {
        super(name);
        this.mPriority = priority;
    }

    protected void onLooperPrepared() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.mTid = Process.myTid();
        Looper.prepare();
        FixedHandlerThread fixedHandlerThread = this;
        synchronized (fixedHandlerThread) {
            this.mLooper = Looper.myLooper();
            this.notifyAll();
        }
        Process.setThreadPriority((int)this.mPriority);
        this.onLooperPrepared();
        Looper.loop();
        this.mTid = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Looper getLooper() {
        if (!this.isAlive()) {
            return null;
        }
        boolean wasInterrupted = false;
        FixedHandlerThread fixedHandlerThread = this;
        synchronized (fixedHandlerThread) {
            while (this.isAlive() && this.mLooper == null) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    wasInterrupted = true;
                }
            }
        }
        if (wasInterrupted) {
            Thread.currentThread().interrupt();
        }
        return this.mLooper;
    }

    public Handler getThreadHandler() {
        if (this.mHandler == null) {
            this.mHandler = new Handler(this.getLooper());
        }
        return this.mHandler;
    }

    public boolean quit() {
        Looper looper = this.getLooper();
        if (looper != null) {
            looper.quit();
            return true;
        }
        return false;
    }

    public boolean quitSafely() {
        Looper looper = this.getLooper();
        if (looper != null) {
            looper.quitSafely();
            return true;
        }
        return false;
    }

    public int getThreadId() {
        return this.mTid;
    }
}

