/*
 * Decompiled with CFR 0.152.
 */
package org.openftc.easyopencv;

import java.util.concurrent.ArrayBlockingQueue;
import org.opencv.core.Mat;

class MatRecycler {
    private RecyclableMat[] mats;
    private ArrayBlockingQueue<RecyclableMat> availableMats;

    MatRecycler(int num) {
        this.mats = new RecyclableMat[num];
        this.availableMats = new ArrayBlockingQueue(num);
        for (int i = 0; i < this.mats.length; ++i) {
            this.mats[i] = new RecyclableMat(i);
            this.availableMats.add(this.mats[i]);
        }
    }

    synchronized RecyclableMat takeMat() throws InterruptedException {
        if (this.availableMats.size() == 0) {
            throw new RuntimeException("All mats have been checked out!");
        }
        RecyclableMat mat = this.availableMats.take();
        mat.checkedOut = true;
        return mat;
    }

    synchronized void returnMat(RecyclableMat mat) {
        if (mat != this.mats[mat.idx]) {
            throw new IllegalArgumentException("This mat does not belong to this recycler!");
        }
        if (!mat.checkedOut) {
            throw new IllegalArgumentException("This mat has already been returned!");
        }
        mat.checkedOut = false;
        this.availableMats.add(mat);
    }

    class RecyclableMat
    extends Mat {
        private int idx = -1;
        private volatile boolean checkedOut = false;
        private Object context;

        private RecyclableMat(int idx) {
            this.idx = idx;
        }

        public void setContext(Object context) {
            this.context = context;
        }

        public Object getContext() {
            return this.context;
        }
    }
}

