/*
 * Decompiled with CFR 0.152.
 */
package org.openftc.easyopencv;

import android.content.Context;
import android.content.pm.PackageManager;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.qualcomm.robotcore.eventloop.opmode.OpMode;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import org.firstinspires.ftc.robotcore.external.ClassFactory;
import org.firstinspires.ftc.robotcore.external.hardware.camera.CameraName;
import org.firstinspires.ftc.robotcore.external.hardware.camera.WebcamName;
import org.firstinspires.ftc.robotcore.internal.camera.delegating.SwitchableCameraName;
import org.firstinspires.ftc.robotcore.internal.system.AppUtil;
import org.openftc.easyopencv.LIFO_OpModeCallbackDelegate;
import org.openftc.easyopencv.OpenCvCameraException;
import org.openftc.easyopencv.OpenCvCameraFactory;
import org.openftc.easyopencv.OpenCvInternalCamera;
import org.openftc.easyopencv.OpenCvInternalCamera2;
import org.openftc.easyopencv.OpenCvInternalCamera2Impl;
import org.openftc.easyopencv.OpenCvInternalCameraImpl;
import org.openftc.easyopencv.OpenCvSwitchableWebcam;
import org.openftc.easyopencv.OpenCvSwitchableWebcamImpl;
import org.openftc.easyopencv.OpenCvWebcam;
import org.openftc.easyopencv.OpenCvWebcamImpl;

class OpenCvCameraFactoryImpl
extends OpenCvCameraFactory {
    private static int appVersion = -1;
    private static int sdk_8_0_versionCode = 47;
    private static String sdk_8_0 = "8.0";

    OpenCvCameraFactoryImpl() {
    }

    private void throwIfIncompatibleSdkVersion() {
        if (appVersion < sdk_8_0_versionCode) {
            throw new RuntimeException(String.format("EasyOpenCV v%s is only compatible with SDK v%s or greater!", "1.7.3", sdk_8_0));
        }
    }

    @Override
    public OpenCvInternalCamera createInternalCamera(OpenCvInternalCamera.CameraDirection direction) {
        this.throwIfIncompatibleSdkVersion();
        return new OpenCvInternalCameraImpl(direction);
    }

    @Override
    public OpenCvInternalCamera createInternalCamera(OpenCvInternalCamera.CameraDirection direction, int containerId) {
        this.throwIfIncompatibleSdkVersion();
        return new OpenCvInternalCameraImpl(direction, containerId);
    }

    @Override
    public OpenCvInternalCamera2 createInternalCamera2(OpenCvInternalCamera2.CameraDirection direction) {
        this.throwIfIncompatibleSdkVersion();
        return new OpenCvInternalCamera2Impl(direction);
    }

    @Override
    public OpenCvInternalCamera2 createInternalCamera2(OpenCvInternalCamera2.CameraDirection direction, int containerId) {
        this.throwIfIncompatibleSdkVersion();
        return new OpenCvInternalCamera2Impl(direction, containerId);
    }

    @Override
    public OpenCvWebcam createWebcam(WebcamName webcamName) {
        this.throwIfIncompatibleSdkVersion();
        return new OpenCvWebcamImpl((CameraName)webcamName);
    }

    @Override
    public OpenCvWebcam createWebcam(WebcamName webcamName, int viewportContainerId) {
        this.throwIfIncompatibleSdkVersion();
        return new OpenCvWebcamImpl((CameraName)webcamName, viewportContainerId);
    }

    @Override
    public OpenCvSwitchableWebcam createSwitchableWebcam(WebcamName ... names) {
        this.throwIfIncompatibleSdkVersion();
        SwitchableCameraName cameraName = ClassFactory.getInstance().getCameraManager().nameForSwitchableCamera((CameraName[])names);
        return new OpenCvSwitchableWebcamImpl(cameraName);
    }

    @Override
    public OpenCvSwitchableWebcam createSwitchableWebcam(int viewportContainerId, WebcamName ... names) {
        this.throwIfIncompatibleSdkVersion();
        SwitchableCameraName cameraName = ClassFactory.getInstance().getCameraManager().nameForSwitchableCamera((CameraName[])names);
        return new OpenCvSwitchableWebcamImpl(cameraName, viewportContainerId);
    }

    @Override
    public int[] splitLayoutForMultipleViewports(final int containerId, final int numViewports, final OpenCvCameraFactory.ViewportSplitMethod viewportSplitMethod) {
        this.throwIfIncompatibleSdkVersion();
        if (numViewports < 2) {
            throw new IllegalArgumentException("Layout requested to be split for <2 viewports!");
        }
        final int[] ids = new int[numViewports];
        final ArrayList layoutArrayList = new ArrayList(numViewports);
        final CountDownLatch latch = new CountDownLatch(1);
        final RuntimeException[] exToRethrowOnOpModeThread = new RuntimeException[]{null};
        AppUtil.getInstance().getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                try {
                    final LinearLayout containerLayout = (LinearLayout)AppUtil.getInstance().getActivity().findViewById(containerId);
                    if (containerLayout == null) {
                        throw new OpenCvCameraException("Viewport container specified by user does not exist!");
                    }
                    if (containerLayout.getChildCount() != 0) {
                        throw new OpenCvCameraException("Viewport container specified by user is not empty!");
                    }
                    containerLayout.setVisibility(0);
                    if (viewportSplitMethod == null) {
                        throw new IllegalArgumentException("Viewport split method cannot be null!");
                    }
                    if (viewportSplitMethod == OpenCvCameraFactory.ViewportSplitMethod.VERTICALLY) {
                        containerLayout.setOrientation(1);
                    } else {
                        containerLayout.setOrientation(0);
                    }
                    for (int i = 0; i < numViewports; ++i) {
                        LinearLayout linearLayout = new LinearLayout((Context)AppUtil.getInstance().getActivity());
                        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -1);
                        params.weight = 1.0f;
                        linearLayout.setLayoutParams((ViewGroup.LayoutParams)params);
                        linearLayout.setId(View.generateViewId());
                        ids[i] = linearLayout.getId();
                        layoutArrayList.add(linearLayout);
                        containerLayout.addView((View)linearLayout);
                    }
                    LIFO_OpModeCallbackDelegate.getInstance().add(new LIFO_OpModeCallbackDelegate.OnOpModeStoppedListener(){

                        @Override
                        public void onOpModePostStop(OpMode opMode) {
                            AppUtil.getInstance().getActivity().runOnUiThread(new Runnable(){

                                @Override
                                public void run() {
                                    for (LinearLayout layout : layoutArrayList) {
                                        containerLayout.removeView((View)layout);
                                    }
                                    containerLayout.setVisibility(8);
                                    containerLayout.setOrientation(1);
                                }
                            });
                        }
                    });
                    latch.countDown();
                }
                catch (RuntimeException e) {
                    exToRethrowOnOpModeThread[0] = e;
                }
            }
        });
        if (exToRethrowOnOpModeThread[0] != null) {
            throw exToRethrowOnOpModeThread[0];
        }
        try {
            latch.await();
            return ids;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        try {
            appVersion = AppUtil.getInstance().getApplication().getPackageManager().getPackageInfo((String)AppUtil.getInstance().getApplication().getPackageName(), (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
    }
}

