/*
 * Decompiled with CFR 0.152.
 */
package org.openftc.easyopencv;

import org.openftc.easyopencv.OpenCvCamera;
import org.openftc.easyopencv.OpenCvCameraRotation;

public interface OpenCvInternalCamera
extends OpenCvCamera {
    public void startStreaming(int var1, int var2, OpenCvCameraRotation var3, BufferMethod var4);

    public void setFocusMode(FocusMode var1);

    public void setFlashlightEnabled(boolean var1);

    public void setExposureCompensation(int var1);

    public int getMaxSupportedExposureCompensation();

    public int getMinSupportedExposureCompensation();

    public void setExposureLocked(boolean var1);

    public void setZoom(int var1);

    public int getMaxSupportedZoom();

    public void setRecordingHint(boolean var1);

    public void setHardwareFrameTimingRange(FrameTimingRange var1);

    public FrameTimingRange[] getFrameTimingRangesSupportedByHardware();

    public static class FrameTimingRange {
        public int min;
        public int max;

        public FrameTimingRange(int min, int max) {
            this.min = min;
            this.max = max;
        }

        public boolean equals(Object o) {
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            FrameTimingRange objToCompare = (FrameTimingRange)o;
            return this.min == objToCompare.min && this.max == objToCompare.max;
        }
    }

    public static enum FocusMode {
        AUTO("auto"),
        FIXED("fixed"),
        INFINITY("infinity"),
        MACRO("macro"),
        EDOF("edof"),
        CONTINUOUS_VIDEO("continuous-video"),
        CONTINUOUS_PICTURE("continuous-picture");

        final String android_string;
        static final FocusMode[] members;

        private FocusMode(String android_string) {
            this.android_string = android_string;
        }

        static FocusMode fromAndroidString(String s) {
            for (FocusMode f : members) {
                if (!f.android_string.equals(s)) continue;
                return f;
            }
            return null;
        }

        static {
            members = FocusMode.values();
        }
    }

    public static enum BufferMethod {
        SINGLE,
        DOUBLE;

    }

    public static enum CameraDirection {
        FRONT(1),
        BACK(0);

        public int id;

        private CameraDirection(int id) {
            this.id = id;
        }
    }
}

