/*
 * Decompiled with CFR 0.152.
 */
package org.openftc.easyopencv;

import android.graphics.ImageFormat;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.imgproc.Imgproc;
import org.openftc.easyopencv.OpenCvCamera;
import org.openftc.easyopencv.OpenCvCameraBase;
import org.openftc.easyopencv.OpenCvCameraException;
import org.openftc.easyopencv.OpenCvCameraRotation;
import org.openftc.easyopencv.OpenCvInternalCamera;

class OpenCvInternalCameraImpl
extends OpenCvCameraBase
implements Camera.PreviewCallback,
OpenCvInternalCamera {
    private Camera camera;
    private OpenCvInternalCamera.CameraDirection direction;
    private Mat rawSensorMat;
    private Mat rgbMat;
    private SurfaceTexture bogusSurfaceTexture;
    private int maxZoom = -1;
    private volatile boolean isStreaming = false;

    public OpenCvInternalCameraImpl(OpenCvInternalCamera.CameraDirection direction) {
        this.direction = direction;
    }

    public OpenCvInternalCameraImpl(OpenCvInternalCamera.CameraDirection direction, int containerLayoutId) {
        super(containerLayoutId);
        this.direction = direction;
    }

    @Override
    public OpenCvCameraRotation getDefaultRotation() {
        return OpenCvCameraRotation.UPRIGHT;
    }

    @Override
    protected int mapRotationEnumToOpenCvRotateCode(OpenCvCameraRotation rotation) {
        if (rotation == OpenCvCameraRotation.SENSOR_NATIVE) {
            return -1;
        }
        if (this.direction == OpenCvInternalCamera.CameraDirection.BACK) {
            if (rotation == OpenCvCameraRotation.UPRIGHT) {
                return 0;
            }
            if (rotation == OpenCvCameraRotation.UPSIDE_DOWN) {
                return 2;
            }
            if (rotation == OpenCvCameraRotation.SIDEWAYS_RIGHT) {
                return 1;
            }
            return -1;
        }
        if (this.direction == OpenCvInternalCamera.CameraDirection.FRONT) {
            if (rotation == OpenCvCameraRotation.UPRIGHT) {
                return 2;
            }
            if (rotation == OpenCvCameraRotation.UPSIDE_DOWN) {
                return 0;
            }
            if (rotation == OpenCvCameraRotation.SIDEWAYS_RIGHT) {
                return 1;
            }
            return -1;
        }
        return -1;
    }

    @Override
    protected boolean cameraOrientationIsTiedToDeviceOrientation() {
        return true;
    }

    @Override
    protected boolean isStreaming() {
        return this.isStreaming;
    }

    @Override
    public synchronized int openCameraDevice() {
        if (this.hasBeenCleanedUp()) {
            return -2;
        }
        this.prepareForOpenCameraDevice();
        try {
            if (this.camera == null) {
                this.camera = Camera.open((int)this.direction.id);
            }
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    @Override
    public void openCameraDeviceAsync(final OpenCvCamera.AsyncCameraOpenListener asyncCameraOpenListener) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                OpenCvInternalCameraImpl openCvInternalCameraImpl = OpenCvInternalCameraImpl.this;
                synchronized (openCvInternalCameraImpl) {
                    try {
                        int retCode = OpenCvInternalCameraImpl.this.openCameraDevice();
                        if (retCode < 0) {
                            asyncCameraOpenListener.onError(retCode);
                        } else {
                            asyncCameraOpenListener.onOpened();
                        }
                    }
                    catch (Exception e) {
                        if (!OpenCvInternalCameraImpl.this.hasBeenCleanedUp()) {
                            OpenCvInternalCameraImpl.this.emulateEStop(e);
                        }
                        e.printStackTrace();
                    }
                }
            }
        }).start();
    }

    @Override
    public synchronized void closeCameraDevice() {
        this.cleanupForClosingCamera();
        if (this.camera != null) {
            this.stopStreaming();
            this.camera.stopPreview();
            this.camera.release();
            this.camera = null;
        }
    }

    @Override
    public void closeCameraDeviceAsync(final OpenCvCamera.AsyncCameraCloseListener asyncCameraCloseListener) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                OpenCvInternalCameraImpl openCvInternalCameraImpl = OpenCvInternalCameraImpl.this;
                synchronized (openCvInternalCameraImpl) {
                    try {
                        OpenCvInternalCameraImpl.this.closeCameraDevice();
                        asyncCameraCloseListener.onClose();
                    }
                    catch (Exception e) {
                        if (!OpenCvInternalCameraImpl.this.hasBeenCleanedUp()) {
                            OpenCvInternalCameraImpl.this.emulateEStop(e);
                        }
                        e.printStackTrace();
                    }
                }
            }
        }).start();
    }

    @Override
    public synchronized void startStreaming(int width, int height) {
        this.startStreaming(width, height, this.getDefaultRotation());
    }

    @Override
    public synchronized void startStreaming(int width, int height, OpenCvCameraRotation rotation) {
        this.startStreaming(width, height, rotation, OpenCvInternalCamera.BufferMethod.DOUBLE);
    }

    @Override
    public synchronized void startStreaming(int width, int height, OpenCvCameraRotation rotation, OpenCvInternalCamera.BufferMethod bufferMethod) {
        if (this.camera == null) {
            throw new OpenCvCameraException("startStreaming() called, but camera is not opened!");
        }
        if (this.isStreaming) {
            this.stopStreaming();
        }
        this.prepareForStartStreaming(width, height, rotation);
        this.rawSensorMat = new Mat(height + height / 2, width, CvType.CV_8UC1);
        this.rgbMat = new Mat(height + height / 2, width, CvType.CV_8UC1);
        if (this.camera != null) {
            Camera.Parameters parameters = this.camera.getParameters();
            parameters.setPreviewFormat(17);
            parameters.setPreviewSize(width, height);
            if (parameters.getSupportedFocusModes().contains("continuous-video")) {
                parameters.setFocusMode("continuous-video");
            } else if (parameters.getSupportedFocusModes().contains("continuous-picture")) {
                parameters.setFocusMode("continuous-picture");
            } else if (parameters.getSupportedFocusModes().contains("fixed")) {
                parameters.setFocusMode("fixed");
            }
            boolean isRequestedSizeSupported = false;
            List cameraSupportedPreviewSizes = parameters.getSupportedPreviewSizes();
            for (Object size : cameraSupportedPreviewSizes) {
                if (((Camera.Size)size).width != width || ((Camera.Size)size).height != height) continue;
                isRequestedSizeSupported = true;
                break;
            }
            if (!isRequestedSizeSupported) {
                StringBuilder supportedSizesBuilder = new StringBuilder();
                for (Camera.Size s : cameraSupportedPreviewSizes) {
                    supportedSizesBuilder.append(String.format("[%dx%d], ", s.width, s.height));
                }
                throw new OpenCvCameraException("Camera does not support requested resolution! Supported resolutions are " + supportedSizesBuilder.toString());
            }
            this.maxZoom = parameters.getMaxZoom();
            this.camera.setParameters(parameters);
            int pixels = width * height;
            int bufSize = pixels * ImageFormat.getBitsPerPixel((int)parameters.getPreviewFormat()) / 8;
            this.bogusSurfaceTexture = new SurfaceTexture(10);
            this.camera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)this);
            if (bufferMethod == OpenCvInternalCamera.BufferMethod.SINGLE) {
                this.camera.addCallbackBuffer(new byte[bufSize]);
            } else if (bufferMethod == OpenCvInternalCamera.BufferMethod.DOUBLE) {
                this.camera.addCallbackBuffer(new byte[bufSize]);
                this.camera.addCallbackBuffer(new byte[bufSize]);
            } else {
                throw new IllegalArgumentException("Illegal buffer method!");
            }
            try {
                this.camera.setPreviewTexture(this.bogusSurfaceTexture);
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            this.camera.startPreview();
            this.isStreaming = true;
        }
    }

    @Override
    public synchronized void stopStreaming() {
        if (this.camera == null) {
            throw new OpenCvCameraException("stopStreaming() called, but camera is not opened!");
        }
        this.cleanupForEndStreaming();
        this.maxZoom = -1;
        if (this.camera != null) {
            this.camera.setPreviewCallback(null);
            this.camera.stopPreview();
        }
        if (this.rawSensorMat != null) {
            this.rawSensorMat.release();
            this.rawSensorMat = null;
        }
        if (this.rgbMat != null) {
            this.rgbMat.release();
            this.rgbMat = null;
        }
        this.isStreaming = false;
    }

    public synchronized void onPreviewFrame(byte[] data, Camera camera) {
        long callbackTimestamp = System.nanoTime();
        this.notifyStartOfFrameProcessing();
        if (this.rawSensorMat != null) {
            this.rawSensorMat.put(0, 0, data);
            Imgproc.cvtColor((Mat)this.rawSensorMat, (Mat)this.rgbMat, (int)96, (int)4);
            this.handleFrame(this.rgbMat, callbackTimestamp);
            if (camera != null) {
                camera.addCallbackBuffer(data);
            }
        }
    }

    @Override
    public synchronized void setFocusMode(OpenCvInternalCamera.FocusMode focusMode) {
        if (this.camera == null) {
            throw new OpenCvCameraException("Cannot set focus mode until camera is opened!");
        }
        Camera.Parameters parameters = this.camera.getParameters();
        ArrayList<OpenCvInternalCamera.FocusMode> supportedModes = this.getEocvCameraApiFocusModes(parameters.getSupportedFocusModes());
        if (!supportedModes.contains((Object)focusMode)) {
            StringBuilder supportedSizesBuilder = new StringBuilder();
            for (OpenCvInternalCamera.FocusMode f : supportedModes) {
                supportedSizesBuilder.append(String.format("%s, ", f.toString()));
            }
            throw new OpenCvCameraException(String.format("Focus mode %s is not supported on this camera. Supported focus modes are %s", focusMode.toString(), supportedSizesBuilder.toString()));
        }
        parameters.setFocusMode(focusMode.android_string);
    }

    private ArrayList<OpenCvInternalCamera.FocusMode> getEocvCameraApiFocusModes(List<String> focusModes) {
        ArrayList<OpenCvInternalCamera.FocusMode> ret = new ArrayList<OpenCvInternalCamera.FocusMode>(focusModes.size());
        for (String s : focusModes) {
            OpenCvInternalCamera.FocusMode m = OpenCvInternalCamera.FocusMode.fromAndroidString(s);
            if (m == null) continue;
            ret.add(m);
        }
        return ret;
    }

    @Override
    public synchronized void setFlashlightEnabled(boolean enabled) {
        if (this.camera == null) {
            throw new OpenCvCameraException("Cannot control flash until camera is opened!");
        }
        Camera.Parameters parameters = this.camera.getParameters();
        List supportedFlashModes = parameters.getSupportedFlashModes();
        if (supportedFlashModes == null) {
            throw new OpenCvCameraException("Camera does not have a flash!");
        }
        if (!supportedFlashModes.contains("torch")) {
            throw new OpenCvCameraException("Camera flash does not support torch mode!");
        }
        if (enabled) {
            parameters.setFlashMode("torch");
        } else {
            parameters.setFlashMode("off");
        }
        this.camera.setParameters(parameters);
    }

    @Override
    public synchronized void setExposureLocked(boolean lock) {
        if (this.camera == null) {
            throw new OpenCvCameraException("Cannot lock exposure until camera is opened");
        }
        Camera.Parameters parameters = this.camera.getParameters();
        if (!parameters.isAutoExposureLockSupported()) {
            throw new OpenCvCameraException("Locking exposure is not supported on this camera");
        }
        parameters.setAutoExposureLock(lock);
        this.camera.setParameters(parameters);
    }

    @Override
    public synchronized void setExposureCompensation(int exposureCompensation) {
        if (this.camera == null) {
            throw new OpenCvCameraException("Cannot set exposure compensation until camera is opened!");
        }
        Camera.Parameters parameters = this.camera.getParameters();
        int minExposureCompensation = parameters.getMinExposureCompensation();
        int maxExposureCompensation = parameters.getMaxExposureCompensation();
        if (exposureCompensation > maxExposureCompensation) {
            throw new OpenCvCameraException(String.format("Exposure compensation value of %d requested, but max supported compensation is %d", exposureCompensation, maxExposureCompensation));
        }
        if (exposureCompensation < minExposureCompensation) {
            throw new OpenCvCameraException(String.format("Exposure compensation value of %d requested, but min supported compensation is %d", exposureCompensation, minExposureCompensation));
        }
        parameters.setExposureCompensation(exposureCompensation);
        this.camera.setParameters(parameters);
    }

    @Override
    public synchronized int getMaxSupportedExposureCompensation() {
        if (this.camera == null) {
            throw new OpenCvCameraException("Cannot get max supported exposure compensation until camera is opened");
        }
        return this.camera.getParameters().getMaxExposureCompensation();
    }

    @Override
    public synchronized int getMinSupportedExposureCompensation() {
        if (this.camera == null) {
            throw new OpenCvCameraException("Cannot get min supported exposure compensation until camera is opened");
        }
        return this.camera.getParameters().getMinExposureCompensation();
    }

    @Override
    public synchronized int getMaxSupportedZoom() {
        if (this.camera == null) {
            throw new OpenCvCameraException("Cannot get supported zooms until camera is opened and streaming is started");
        }
        if (this.maxZoom == -1) {
            throw new OpenCvCameraException("Cannot get supported zooms until streaming has been started");
        }
        return this.maxZoom;
    }

    @Override
    public synchronized void setZoom(int zoom) {
        if (this.camera == null) {
            throw new OpenCvCameraException("Cannot set zoom until camera is opened and streaming is started");
        }
        if (this.maxZoom == -1) {
            throw new OpenCvCameraException("Cannot set zoom until streaming has been started");
        }
        if (zoom > this.maxZoom) {
            throw new OpenCvCameraException(String.format("Zoom value of %d requested, but maximum zoom supported in current configuration is %d", zoom, this.maxZoom));
        }
        if (zoom < 0) {
            throw new OpenCvCameraException("Zoom value cannot be less than 0");
        }
        Camera.Parameters parameters = this.camera.getParameters();
        parameters.setZoom(zoom);
        this.camera.setParameters(parameters);
    }

    @Override
    public synchronized void setRecordingHint(boolean hint) {
        if (this.camera == null) {
            throw new OpenCvCameraException("Cannot set recording hint until camera is opened");
        }
        Camera.Parameters parameters = this.camera.getParameters();
        parameters.setRecordingHint(hint);
        this.camera.setParameters(parameters);
    }

    @Override
    public synchronized void setHardwareFrameTimingRange(OpenCvInternalCamera.FrameTimingRange frameTiming) {
        if (this.camera == null) {
            throw new OpenCvCameraException("Cannot set hardware frame timing range until camera is opened");
        }
        Camera.Parameters parameters = this.camera.getParameters();
        parameters.setPreviewFpsRange(frameTiming.min * 1000, frameTiming.max * 1000);
        this.camera.setParameters(parameters);
    }

    @Override
    public synchronized OpenCvInternalCamera.FrameTimingRange[] getFrameTimingRangesSupportedByHardware() {
        if (this.camera == null) {
            throw new OpenCvCameraException("Cannot get frame timing ranges until camera is opened");
        }
        Camera.Parameters parameters = this.camera.getParameters();
        List rawRanges = parameters.getSupportedPreviewFpsRange();
        OpenCvInternalCamera.FrameTimingRange[] ranges = new OpenCvInternalCamera.FrameTimingRange[rawRanges.size()];
        for (int i = 0; i < ranges.length; ++i) {
            int[] raw = (int[])rawRanges.get(i);
            ranges[i] = new OpenCvInternalCamera.FrameTimingRange(raw[0] / 1000, raw[1] / 1000);
        }
        return ranges;
    }
}

