/*
 * Decompiled with CFR 0.152.
 */
package org.openftc.easyopencv;

import android.content.Context;
import android.graphics.Canvas;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import java.util.concurrent.ArrayBlockingQueue;
import org.firstinspires.ftc.robotcore.external.function.Consumer;
import org.firstinspires.ftc.robotcore.internal.collections.EvictingBlockingQueue;
import org.opencv.core.Mat;
import org.openftc.easyopencv.MatRecycler;
import org.openftc.easyopencv.OpenCvCamera;
import org.openftc.easyopencv.OpenCvViewRenderer;
import org.openftc.easyopencv.OpenCvViewport;

public class OpenCvNativeViewViewport
extends View
implements OpenCvViewport {
    private final OpenCvViewRenderer renderer;
    private static final int VISION_PREVIEW_FRAME_QUEUE_CAPACITY = 2;
    private static final int FRAMEBUFFER_RECYCLER_CAPACITY = 4;
    private final EvictingBlockingQueue<MatRecycler.RecyclableMat> visionPreviewFrameQueue = new EvictingBlockingQueue(new ArrayBlockingQueue(2));
    private MatRecycler framebufferRecycler;
    private volatile boolean active = false;
    private volatile boolean wasJustActivated;
    private volatile boolean paused = false;
    private final Object activeSync = new Object();
    Handler handler = new Handler(Looper.getMainLooper());
    final Runnable invalidateRunnable;
    private volatile boolean isInvalidatePending = false;
    private volatile OpenCvViewport.RenderHook renderHook;

    public OpenCvNativeViewViewport(Context context, View.OnClickListener onClickListener) {
        super(context);
        this.renderer = new OpenCvViewRenderer(context, false);
        this.setOnClickListener(onClickListener);
        this.visionPreviewFrameQueue.setEvictAction((Consumer)new Consumer<MatRecycler.RecyclableMat>(){

            public void accept(MatRecycler.RecyclableMat value) {
                OpenCvNativeViewViewport.this.framebufferRecycler.returnMat(value);
            }
        });
        this.invalidateRunnable = new Runnable(){

            @Override
            public void run() {
                if (!OpenCvNativeViewViewport.this.isInvalidatePending) {
                    OpenCvNativeViewViewport.this.isInvalidatePending = true;
                    OpenCvNativeViewViewport.this.invalidate();
                }
            }
        };
    }

    @Override
    public void setOptimizedViewRotation(OpenCvViewport.OptimizedRotation rotation) {
        this.renderer.setOptimizedViewRotation(rotation);
    }

    @Override
    public void notifyStatistics(float fps, int pipelineMs, int overheadMs) {
        this.renderer.notifyStatistics(fps, pipelineMs, overheadMs);
    }

    @Override
    public void setRecording(boolean recording) {
        this.renderer.setRecording(recording);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void post(Mat frame, Object context) {
        Object object = this.activeSync;
        synchronized (object) {
            if (frame == null) {
                throw new IllegalArgumentException("cannot post null mat!");
            }
            if (this.active && !this.paused) {
                try {
                    MatRecycler.RecyclableMat matToCopyTo = this.framebufferRecycler.takeMat();
                    frame.copyTo((Mat)matToCopyTo);
                    matToCopyTo.setContext(context);
                    this.visionPreviewFrameQueue.offer((Object)matToCopyTo);
                    this.handler.post(this.invalidateRunnable);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    @Override
    public void setFpsMeterEnabled(boolean enabled) {
        this.renderer.setFpsMeterEnabled(enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() {
        if (!this.paused) {
            Object object = this.activeSync;
            synchronized (object) {
                this.paused = true;
                if (this.active) {
                    this.handler.post(this.invalidateRunnable);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        Object object = this.activeSync;
        synchronized (object) {
            if (this.paused) {
                this.paused = false;
                if (this.active) {
                    this.handler.post(this.invalidateRunnable);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void activate() {
        Object object = this.activeSync;
        synchronized (object) {
            this.active = true;
            this.wasJustActivated = true;
            this.handler.post(this.invalidateRunnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void deactivate() {
        Object object = this.activeSync;
        synchronized (object) {
            this.active = false;
            this.handler.post(this.invalidateRunnable);
        }
    }

    @Override
    public synchronized void setSize(int width, int height) {
        if (this.active) {
            throw new RuntimeException();
        }
        this.visionPreviewFrameQueue.clear();
        this.framebufferRecycler = new MatRecycler(4);
    }

    @Override
    public void setRenderingPolicy(OpenCvCamera.ViewportRenderingPolicy policy) {
        this.renderer.setRenderingPolicy(policy);
    }

    @Override
    public void setRenderHook(OpenCvViewport.RenderHook renderHook) {
        this.renderHook = renderHook;
    }

    public synchronized void onDraw(Canvas canvas) {
        this.isInvalidatePending = false;
        if (!this.active) {
            canvas.drawColor(-16777216);
        } else if (this.paused) {
            this.renderer.renderPaused(canvas);
        } else {
            MatRecycler.RecyclableMat mat = (MatRecycler.RecyclableMat)((Object)this.visionPreviewFrameQueue.poll());
            if (mat == null) {
                if (this.wasJustActivated) {
                    this.wasJustActivated = false;
                    canvas.drawColor(-16776961);
                } else {
                    System.out.println("Invalidate w/ null mat " + System.currentTimeMillis());
                }
                return;
            }
            this.renderer.render(mat, canvas, this.renderHook, mat.getContext());
            this.framebufferRecycler.returnMat(mat);
        }
    }
}

