/*
 * Decompiled with CFR 0.152.
 */
package org.openftc.easyopencv;

import android.annotation.SuppressLint;
import com.qualcomm.robotcore.util.RobotLog;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.firstinspires.ftc.robotcore.external.ClassFactory;
import org.firstinspires.ftc.robotcore.external.android.util.Size;
import org.firstinspires.ftc.robotcore.external.function.Continuation;
import org.firstinspires.ftc.robotcore.external.hardware.camera.Camera;
import org.firstinspires.ftc.robotcore.external.hardware.camera.CameraCaptureRequest;
import org.firstinspires.ftc.robotcore.external.hardware.camera.CameraCaptureSequenceId;
import org.firstinspires.ftc.robotcore.external.hardware.camera.CameraCaptureSession;
import org.firstinspires.ftc.robotcore.external.hardware.camera.CameraCharacteristics;
import org.firstinspires.ftc.robotcore.external.hardware.camera.CameraException;
import org.firstinspires.ftc.robotcore.external.hardware.camera.CameraFrame;
import org.firstinspires.ftc.robotcore.external.hardware.camera.CameraName;
import org.firstinspires.ftc.robotcore.external.hardware.camera.controls.CameraControl;
import org.firstinspires.ftc.robotcore.external.hardware.camera.controls.ExposureControl;
import org.firstinspires.ftc.robotcore.external.hardware.camera.controls.FocusControl;
import org.firstinspires.ftc.robotcore.external.hardware.camera.controls.GainControl;
import org.firstinspires.ftc.robotcore.external.hardware.camera.controls.PtzControl;
import org.firstinspires.ftc.robotcore.external.hardware.camera.controls.WhiteBalanceControl;
import org.firstinspires.ftc.robotcore.internal.camera.CameraInternal;
import org.firstinspires.ftc.robotcore.internal.camera.CameraManagerInternal;
import org.firstinspires.ftc.robotcore.internal.camera.calibration.CameraCalibrationIdentity;
import org.firstinspires.ftc.robotcore.internal.camera.libuvc.constants.UvcFrameFormat;
import org.firstinspires.ftc.robotcore.internal.system.Deadline;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.openftc.easyopencv.OpenCvCamera;
import org.openftc.easyopencv.OpenCvCameraBase;
import org.openftc.easyopencv.OpenCvCameraException;
import org.openftc.easyopencv.OpenCvCameraRotation;
import org.openftc.easyopencv.OpenCvWebcam;

class OpenCvWebcamImpl
extends OpenCvCameraBase
implements OpenCvWebcam,
CameraCaptureSession.CaptureCallback {
    private final CameraManagerInternal cameraManager;
    private final Executor serialThreadPool;
    private volatile int millisecondsPermissionTimeout = 5000;
    private final CameraName cameraName;
    private CameraCharacteristics cameraCharacteristics = null;
    protected Camera camera = null;
    private CameraCaptureSession cameraCaptureSession = null;
    private Mat rgbaMat;
    private volatile boolean isStreaming = false;
    protected final Object cameraDeviceStateSync = new Object();
    private final Object newFrameSync = new Object();
    private boolean abortNewFrameCallback = false;
    private volatile boolean hasSeenFrame = false;
    private ExposureControl exposureControl;
    private FocusControl focusControl;
    private PtzControl ptzControl;
    private GainControl gainControl;
    private WhiteBalanceControl whiteBalanceControl;

    public OpenCvWebcamImpl(CameraName cameraName) {
        this.cameraManager = (CameraManagerInternal)ClassFactory.getInstance().getCameraManager();
        this.serialThreadPool = this.cameraManager.getSerialThreadPool();
        this.cameraName = cameraName;
    }

    public OpenCvWebcamImpl(CameraName cameraName, int containerLayoutId) {
        super(containerLayoutId);
        this.cameraManager = (CameraManagerInternal)ClassFactory.getInstance().getCameraManager();
        this.serialThreadPool = this.cameraManager.getSerialThreadPool();
        this.cameraName = cameraName;
    }

    public CameraCharacteristics getCameraCharacteristics() {
        return this.cameraCharacteristics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int openCameraDevice() {
        Object object = this.cameraDeviceStateSync;
        synchronized (object) {
            if (this.hasBeenCleanedUp()) {
                return -2;
            }
            this.prepareForOpenCameraDevice();
            if (this.camera == null) {
                try {
                    this.camera = this.cameraManager.requestPermissionAndOpenCamera(new Deadline((long)this.millisecondsPermissionTimeout, TimeUnit.MILLISECONDS), this.cameraName, null);
                    if (this.camera == null) {
                        return -1;
                    }
                    this.cameraCharacteristics = this.camera.getCameraName().getCameraCharacteristics();
                    this.exposureControl = (ExposureControl)this.camera.getControl(ExposureControl.class);
                    this.focusControl = (FocusControl)this.camera.getControl(FocusControl.class);
                    this.ptzControl = (PtzControl)this.camera.getControl(PtzControl.class);
                    this.gainControl = (GainControl)this.camera.getControl(GainControl.class);
                    this.whiteBalanceControl = (WhiteBalanceControl)this.camera.getControl(WhiteBalanceControl.class);
                }
                catch (Exception e) {
                    this.camera = null;
                    throw e;
                }
            }
            return 0;
        }
    }

    @Override
    public void openCameraDeviceAsync(final OpenCvCamera.AsyncCameraOpenListener callback) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = OpenCvWebcamImpl.this.cameraDeviceStateSync;
                synchronized (object) {
                    try {
                        int retCode = OpenCvWebcamImpl.this.openCameraDevice();
                        if (retCode < 0) {
                            callback.onError(retCode);
                        } else {
                            callback.onOpened();
                        }
                    }
                    catch (Exception e) {
                        if (!OpenCvWebcamImpl.this.hasBeenCleanedUp()) {
                            OpenCvWebcamImpl.this.emulateEStop(e);
                        }
                        e.printStackTrace();
                    }
                }
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeCameraDevice() {
        Object object = this.cameraDeviceStateSync;
        synchronized (object) {
            this.cleanupForClosingCamera();
            if (this.camera != null) {
                this.stopStreaming();
                this.camera.close();
                this.camera = null;
            }
        }
    }

    @Override
    public void closeCameraDeviceAsync(final OpenCvCamera.AsyncCameraCloseListener asyncCameraCloseListener) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = OpenCvWebcamImpl.this.cameraDeviceStateSync;
                synchronized (object) {
                    try {
                        OpenCvWebcamImpl.this.closeCameraDevice();
                        asyncCameraCloseListener.onClose();
                    }
                    catch (Exception e) {
                        if (!OpenCvWebcamImpl.this.hasBeenCleanedUp()) {
                            OpenCvWebcamImpl.this.emulateEStop(e);
                        }
                        e.printStackTrace();
                    }
                }
            }
        }).start();
    }

    @Override
    public void startStreaming(int width, int height) {
        this.startStreaming(width, height, this.getDefaultRotation());
    }

    @Override
    public void startStreaming(int width, int height, OpenCvCameraRotation rotation) {
        this.startStreaming(width, height, rotation, null);
    }

    private static int streamFormat2ImageFormat(OpenCvWebcam.StreamFormat streamFormat) {
        switch (streamFormat) {
            case YUY2: {
                return 20;
            }
            case MJPEG: {
                return 256;
            }
        }
        throw new IllegalArgumentException();
    }

    private static boolean isSizeSupportedForFormat(CameraCharacteristics characteristics, int width, int height, OpenCvWebcam.StreamFormat format) {
        for (Size s : characteristics.getSizes(OpenCvWebcamImpl.streamFormat2ImageFormat(format))) {
            if (s.getHeight() != height || s.getWidth() != width) continue;
            return true;
        }
        return false;
    }

    @SuppressLint(value={"DefaultLocale"})
    private static String getSizeAndFpsListForFormat(CameraCharacteristics characteristics, OpenCvWebcam.StreamFormat format) {
        StringBuilder builder = new StringBuilder();
        boolean areAnySupported = false;
        for (Size s : characteristics.getSizes(OpenCvWebcamImpl.streamFormat2ImageFormat(format))) {
            int fps = characteristics.getMaxFramesPerSecond(OpenCvWebcamImpl.streamFormat2ImageFormat(format), s);
            builder.append(String.format("[%dx%d @ %dFPS], ", s.getWidth(), s.getHeight(), fps));
            areAnySupported = true;
        }
        return areAnySupported ? builder.toString() : "NONE";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressLint(value={"DefaultLocale"})
    public void startStreaming(int width, int height, OpenCvCameraRotation rotation, OpenCvWebcam.StreamFormat streamFormat) {
        boolean userExplicitlyRequestedFormat;
        boolean bl = userExplicitlyRequestedFormat = streamFormat != null;
        if (streamFormat == null) {
            streamFormat = OpenCvWebcam.StreamFormat.YUY2;
        }
        final int format = OpenCvWebcamImpl.streamFormat2ImageFormat(streamFormat);
        Object object = this.cameraDeviceStateSync;
        synchronized (object) {
            if (this.camera == null) {
                throw new OpenCvCameraException("startStreaming() called, but camera is not opened!");
            }
            if (this.isStreaming) {
                this.stopStreaming();
            }
            this.prepareForStartStreaming(width, height, rotation);
            final CountDownLatch captureStartResult = new CountDownLatch(1);
            boolean sizeSupportedForReqFormat = OpenCvWebcamImpl.isSizeSupportedForFormat(this.cameraCharacteristics, width, height, streamFormat);
            boolean sizeSupportedForMjpeg = OpenCvWebcamImpl.isSizeSupportedForFormat(this.cameraCharacteristics, width, height, OpenCvWebcam.StreamFormat.MJPEG);
            if (!sizeSupportedForReqFormat) {
                throw new OpenCvCameraException(String.format("Camera does not support requested resolution for format %s!\nSupported resolutions for YUY2 are: %s\n\nSupported resolutions for MJPEG are: %s\n", new Object[]{streamFormat, OpenCvWebcamImpl.getSizeAndFpsListForFormat(this.cameraCharacteristics, OpenCvWebcam.StreamFormat.YUY2), OpenCvWebcamImpl.getSizeAndFpsListForFormat(this.cameraCharacteristics, OpenCvWebcam.StreamFormat.MJPEG)}));
            }
            final Size size = new Size(width, height);
            if (!userExplicitlyRequestedFormat && streamFormat == OpenCvWebcam.StreamFormat.YUY2 && sizeSupportedForMjpeg) {
                int maxFpsYuy2 = this.cameraCharacteristics.getMaxFramesPerSecond(OpenCvWebcamImpl.streamFormat2ImageFormat(OpenCvWebcam.StreamFormat.YUY2), size);
                int maxFpsMjpeg = this.cameraCharacteristics.getMaxFramesPerSecond(OpenCvWebcamImpl.streamFormat2ImageFormat(OpenCvWebcam.StreamFormat.MJPEG), size);
                if (maxFpsMjpeg > maxFpsYuy2) {
                    RobotLog.addGlobalWarningMessage((String)String.format("You are using YUY2 image format for this camera. You could increase your maximum FPS from %d to %d by choosing MJPEG format. To suppress this warning, explicitly request YUY2 format.", maxFpsYuy2, maxFpsMjpeg));
                }
            }
            try {
                this.camera.createCaptureSession(Continuation.create((Executor)this.serialThreadPool, (Object)new CameraCaptureSession.StateCallback(){

                    public void onConfigured(CameraCaptureSession session) {
                        try {
                            int fps = OpenCvWebcamImpl.this.cameraCharacteristics.getMaxFramesPerSecond(format, size);
                            CameraCaptureRequest cameraCaptureRequest = OpenCvWebcamImpl.this.camera.createCaptureRequest(format, size, fps);
                            session.startCapture(cameraCaptureRequest, (CameraCaptureSession.CaptureCallback)OpenCvWebcamImpl.this, Continuation.create((Executor)OpenCvWebcamImpl.this.serialThreadPool, (Object)new CameraCaptureSession.StatusCallback(){

                                public void onCaptureSequenceCompleted(CameraCaptureSession session, CameraCaptureSequenceId cameraCaptureSequenceId, long lastFrameNumber) {
                                    RobotLog.d((String)"capture sequence %s reports completed: lastFrame=%d", (Object[])new Object[]{cameraCaptureSequenceId, lastFrameNumber});
                                }
                            }));
                        }
                        catch (RuntimeException | CameraException e) {
                            e.printStackTrace();
                            RobotLog.e((String)"exception setting repeat capture request: closing session: %s", (Object[])new Object[]{session});
                            session.close();
                            session = null;
                        }
                        System.out.println("OpenCvWebcam: onConfigured");
                        OpenCvWebcamImpl.this.cameraCaptureSession = session;
                        captureStartResult.countDown();
                    }

                    public void onClosed(CameraCaptureSession session) {
                    }
                }));
            }
            catch (RuntimeException | CameraException e) {
                System.out.println("OpenCvWebcam: exception starting capture");
                captureStartResult.countDown();
            }
            try {
                captureStartResult.await(1L, TimeUnit.SECONDS);
                System.out.println("OpenCvWebcam: streaming started");
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.isStreaming = true;
        }
    }

    @Override
    protected OpenCvCameraRotation getDefaultRotation() {
        return OpenCvCameraRotation.SIDEWAYS_LEFT;
    }

    @Override
    protected int mapRotationEnumToOpenCvRotateCode(OpenCvCameraRotation rotation) {
        if (rotation == OpenCvCameraRotation.SENSOR_NATIVE) {
            return -1;
        }
        if (rotation == OpenCvCameraRotation.SIDEWAYS_LEFT) {
            return 2;
        }
        if (rotation == OpenCvCameraRotation.SIDEWAYS_RIGHT) {
            return 0;
        }
        if (rotation == OpenCvCameraRotation.UPSIDE_DOWN) {
            return 1;
        }
        return -1;
    }

    @Override
    protected boolean cameraOrientationIsTiedToDeviceOrientation() {
        return false;
    }

    @Override
    protected boolean isStreaming() {
        return this.isStreaming;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopStreaming() {
        Object object = this.cameraDeviceStateSync;
        synchronized (object) {
            if (this.camera == null) {
                throw new OpenCvCameraException("stopStreaming() called, but camera is not opened!");
            }
            Object object2 = this.newFrameSync;
            synchronized (object2) {
                this.abortNewFrameCallback = true;
                this.cleanupForEndStreaming();
                this.rgbaMat = null;
            }
            if (this.cameraCaptureSession != null) {
                boolean wasInterrupted = false;
                while (!this.hasSeenFrame) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        wasInterrupted = true;
                    }
                }
                this.cameraCaptureSession.stopCapture();
                this.cameraCaptureSession.close();
                this.cameraCaptureSession = null;
                if (wasInterrupted) {
                    Thread.currentThread().interrupt();
                }
            }
            this.isStreaming = false;
            this.abortNewFrameCallback = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNewFrame(CameraCaptureSession session, CameraCaptureRequest request, CameraFrame cameraFrame) {
        this.hasSeenFrame = true;
        Object object = this.newFrameSync;
        synchronized (object) {
            if (this.abortNewFrameCallback) {
                return;
            }
            this.notifyStartOfFrameProcessing();
            if (this.rgbaMat == null) {
                this.rgbaMat = new Mat(cameraFrame.getSize().getHeight(), cameraFrame.getSize().getWidth(), CvType.CV_8UC4);
            }
            if (cameraFrame.getUvcFrameFormat() == UvcFrameFormat.YUY2) {
                OpenCvWebcamImpl.yuy2BufToRgbaMat(cameraFrame.getImageBuffer(), cameraFrame.getSize().getWidth(), cameraFrame.getSize().getHeight(), this.rgbaMat.nativeObj);
            } else if (cameraFrame.getUvcFrameFormat() == UvcFrameFormat.MJPEG) {
                OpenCvWebcamImpl.mjpegBufToRgbaMat(cameraFrame.getImageBuffer(), cameraFrame.getImageSize(), cameraFrame.getSize().getWidth(), cameraFrame.getSize().getHeight(), this.rgbaMat.nativeObj);
            }
            this.handleFrame(this.rgbaMat, cameraFrame.getCaptureTime());
        }
    }

    @Override
    public void setMillisecondsPermissionTimeout(int ms) {
        this.millisecondsPermissionTimeout = ms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExposureControl getExposureControl() {
        Object object = this.cameraDeviceStateSync;
        synchronized (object) {
            if (this.camera == null) {
                throw new OpenCvCameraException("getExposureControl() called, but camera is not opened!");
            }
            return this.exposureControl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FocusControl getFocusControl() {
        Object object = this.cameraDeviceStateSync;
        synchronized (object) {
            if (this.camera == null) {
                throw new OpenCvCameraException("getFocusControl() called, but camera is not opened!");
            }
            return this.focusControl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PtzControl getPtzControl() {
        Object object = this.cameraDeviceStateSync;
        synchronized (object) {
            if (this.camera == null) {
                throw new OpenCvCameraException("getPtzControl() called, but camera is not opened!");
            }
            return this.ptzControl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GainControl getGainControl() {
        Object object = this.cameraDeviceStateSync;
        synchronized (object) {
            if (this.camera == null) {
                throw new OpenCvCameraException("getGainControl() called, but camera is not opened!");
            }
            return this.gainControl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WhiteBalanceControl getWhiteBalanceControl() {
        Object object = this.cameraDeviceStateSync;
        synchronized (object) {
            if (this.camera == null) {
                throw new OpenCvCameraException("getWhiteBalanceControl() called, but camera is not opened!");
            }
            return this.whiteBalanceControl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends CameraControl> T getControl(Class<T> controlType) {
        Object object = this.cameraDeviceStateSync;
        synchronized (object) {
            if (this.camera == null) {
                throw new OpenCvCameraException("getControl() called, but camera is not opened!");
            }
        }
        return (T)this.camera.getControl(controlType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CameraCalibrationIdentity getCalibrationIdentity() {
        Object object = this.cameraDeviceStateSync;
        synchronized (object) {
            if (this.camera == null) {
                throw new OpenCvCameraException("getCalibrationIdentity() called, but camera is not opened!");
            }
            return ((CameraInternal)this.camera).getCalibrationIdentity();
        }
    }

    public static native void yuy2BufToRgbaMat(long var0, int var2, int var3, long var4);

    public static native void mjpegBufToRgbaMat(long var0, int var2, int var3, int var4, long var5);

    static {
        System.loadLibrary("EasyOpenCV");
    }
}

