/*
 * Decompiled with CFR 0.152.
 */
package org.opengauss.quickautobalance;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.opengauss.Driver;
import org.opengauss.PGProperty;
import org.opengauss.QueryCNListUtils;
import org.opengauss.jdbc.PgConnection;
import org.opengauss.jdbc.StatementCancelState;
import org.opengauss.log.Log;
import org.opengauss.log.Logger;
import org.opengauss.quickautobalance.Cluster;
import org.opengauss.quickautobalance.ConnectionInfo;
import org.opengauss.util.GT;
import org.opengauss.util.HostSpec;
import org.opengauss.util.PSQLException;
import org.opengauss.util.PSQLState;

public class ConnectionManager {
    private static final Log LOGGER = Logger.getLogger(ConnectionManager.class.getName());
    private static final String AUTO_BALANCE = "autoBalance";
    private static final String LEAST_CONN = "leastconn";
    private final Map<String, Cluster> cachedClusters = new ConcurrentHashMap<String, Cluster>();

    private ConnectionManager() {
    }

    public List<Integer> closeConnections() {
        ArrayList<Integer> ans = new ArrayList<Integer>();
        for (Map.Entry<String, Cluster> entry : this.cachedClusters.entrySet()) {
            Cluster cluster = entry.getValue();
            int num = 0;
            ans.add(num += cluster != null ? cluster.closeConnections() : 0);
        }
        return ans;
    }

    public static boolean checkEnableLeastConn(Properties properties) {
        if (properties == null) {
            return false;
        }
        if (!LEAST_CONN.equals(properties.getProperty(AUTO_BALANCE, ""))) {
            return false;
        }
        HostSpec[] hostSpecs = Driver.getURLHostSpecs(properties);
        return hostSpecs.length > 1;
    }

    public static boolean checkEnableQuickAutoBalance(Properties properties) {
        if (!ConnectionManager.checkEnableLeastConn(properties)) {
            return false;
        }
        return "true".equals(PGProperty.ENABLE_QUICK_AUTO_BALANCE.get(properties));
    }

    public static ConnectionManager getInstance() {
        return Holder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setCluster(Properties properties) throws PSQLException {
        if (!ConnectionManager.checkEnableLeastConn(properties)) {
            return false;
        }
        this.checkQuickAutoBalanceParams(properties);
        String urlIdentifier = QueryCNListUtils.keyFromURL(properties);
        if (!this.cachedClusters.containsKey(urlIdentifier)) {
            Map<String, Cluster> map = this.cachedClusters;
            synchronized (map) {
                if (!this.cachedClusters.containsKey(urlIdentifier)) {
                    Cluster cluster = new Cluster(urlIdentifier, properties);
                    this.cachedClusters.put(urlIdentifier, cluster);
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private void checkQuickAutoBalanceParams(Properties properties) throws PSQLException {
        ConnectionInfo.parseEnableQuickAutoBalance(properties);
        ConnectionInfo.parseMaxIdleTimeBeforeTerminal(properties);
        Cluster.parseMinReservedConPerCluster(properties);
        Cluster.parseMinReservedConPerDatanode(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setConnection(PgConnection pgConnection, Properties properties) throws PSQLException {
        if (!ConnectionManager.checkEnableLeastConn(properties)) {
            return false;
        }
        String URLIdentifier = QueryCNListUtils.keyFromURL(properties);
        if (!this.cachedClusters.containsKey(URLIdentifier)) {
            Map<String, Cluster> map = this.cachedClusters;
            synchronized (map) {
                if (!this.cachedClusters.containsKey(URLIdentifier)) {
                    Cluster cluster = new Cluster(URLIdentifier, properties);
                    cluster.setConnection(pgConnection, properties);
                    this.cachedClusters.put(URLIdentifier, cluster);
                }
            }
        } else {
            this.cachedClusters.get(URLIdentifier).setConnection(pgConnection, properties);
        }
        return true;
    }

    public void setConnectionState(PgConnection pgConnection, StatementCancelState state) throws PSQLException {
        String url;
        try {
            url = pgConnection.getURL();
        }
        catch (SQLException e) {
            LOGGER.error(GT.tr("Can't get url from pgConnection.", new Object[0]));
            return;
        }
        String URLIdentifier = ConnectionManager.getURLIdentifierFromUrl(url);
        Cluster cluster = this.cachedClusters.get(URLIdentifier);
        if (cluster != null) {
            cluster.setConnectionState(pgConnection, state);
        }
    }

    public Cluster getCluster(String URLIdentifier) {
        return this.cachedClusters.get(URLIdentifier);
    }

    public static String getURLIdentifierFromUrl(String url) throws PSQLException {
        Object[] hostSpecs;
        try {
            String pgHostUrl = url.split("//")[1].split("/")[0];
            String[] pgHosts = pgHostUrl.split(",");
            hostSpecs = new HostSpec[pgHosts.length];
            for (int i = 0; i < hostSpecs.length; ++i) {
                hostSpecs[i] = new HostSpec(pgHosts[i].split(":")[0], Integer.parseInt(pgHosts[i].split(":")[1]));
            }
            Arrays.sort(hostSpecs);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new PSQLException(GT.tr("Parsed url={0} failed.", url), PSQLState.INVALID_PARAMETER_VALUE);
        }
        return Arrays.toString(hostSpecs);
    }

    public List<Integer> checkConnectionsValidity() {
        ArrayList<Integer> ans = new ArrayList<Integer>();
        for (Map.Entry<String, Cluster> entry : this.cachedClusters.entrySet()) {
            Cluster cluster = entry.getValue();
            int num = 0;
            if (cluster != null) {
                List<Integer> removes = cluster.checkConnectionsValidity();
                for (int remove : removes) {
                    num += remove;
                }
            }
            ans.add(num);
        }
        return ans;
    }

    public int checkClusterStates() {
        int invalidDataNodes = 0;
        for (Map.Entry<String, Cluster> entry : this.cachedClusters.entrySet()) {
            Cluster cluster = entry.getValue();
            if (cluster == null) continue;
            invalidDataNodes += cluster.checkClusterState();
        }
        return invalidDataNodes;
    }

    public int incrementCachedCreatingConnectionSize(HostSpec hostSpec, Properties properties) {
        if (!ConnectionManager.checkEnableLeastConn(properties)) {
            return 0;
        }
        String URLIdentifier = QueryCNListUtils.keyFromURL(properties);
        if (this.cachedClusters.containsKey(URLIdentifier)) {
            Cluster cluster = this.cachedClusters.get(URLIdentifier);
            if (cluster != null) {
                return cluster.incrementCachedCreatingConnectionSize(hostSpec);
            }
        } else {
            LOGGER.info(GT.tr("Can not find cluster: {0} in cached clusters.", URLIdentifier));
        }
        return 0;
    }

    public int decrementCachedCreatingConnectionSize(HostSpec hostSpec, Properties properties) {
        if (!ConnectionManager.checkEnableLeastConn(properties)) {
            return 0;
        }
        String URLIdentifier = QueryCNListUtils.keyFromURL(properties);
        if (this.cachedClusters.containsKey(URLIdentifier)) {
            Cluster cluster = this.cachedClusters.get(URLIdentifier);
            if (cluster != null) {
                return cluster.decrementCachedCreatingConnectionSize(hostSpec);
            }
        } else {
            LOGGER.info(GT.tr("Can not find cluster: {0} in cached clusters.", URLIdentifier));
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<String, Cluster> map = this.cachedClusters;
        synchronized (map) {
            this.cachedClusters.clear();
        }
    }

    public int getCachedConnectionSize() {
        return this.cachedClusters.values().stream().mapToInt(Cluster::getCachedConnectionSize).sum();
    }

    private static class Holder {
        private static final ConnectionManager INSTANCE = new ConnectionManager();

        private Holder() {
        }
    }
}

