/*
 * Copyright (c) 2004, PostgreSQL Global Development Group
 * See the LICENSE file in the project root for more information.
 */

package org.opengauss.jdbc2;

import java.util.HashMap;
import java.util.Map;

/**
 * Array assistants register here.
 *
 * @author Minglei Tu
 */
public class ArrayAssistantRegistry {
  private static Map<Integer, ArrayAssistant> arrayAssistantMap =
      new HashMap<Integer, ArrayAssistant>();

  public static ArrayAssistant getAssistant(int oid) {
    return arrayAssistantMap.get(oid);
  }

  ////
  public static void register(int oid, ArrayAssistant assistant) {
    arrayAssistantMap.put(oid, assistant);
  }
}
