/*
 * Decompiled with CFR 0.152.
 */
package org.opengauss.core.v3;

import java.lang.ref.PhantomReference;
import java.nio.charset.StandardCharsets;
import org.opengauss.core.ResultCursor;
import org.opengauss.core.Utils;
import org.opengauss.core.v3.SimpleQuery;

class Portal
implements ResultCursor {
    private final SimpleQuery query;
    private final String portalName;
    private final byte[] encodedName;
    private PhantomReference<?> cleanupRef;

    Portal(SimpleQuery query, String portalName) {
        this(query, portalName, StandardCharsets.UTF_8.name());
    }

    Portal(SimpleQuery query, String portalName, String clientEncoding) {
        this.query = query;
        this.portalName = portalName;
        this.encodedName = Utils.encodeUTF8(portalName, clientEncoding);
    }

    @Override
    public void close() {
        if (this.cleanupRef != null) {
            this.cleanupRef.clear();
            this.cleanupRef.enqueue();
            this.cleanupRef = null;
        }
    }

    String getPortalName() {
        return this.portalName;
    }

    byte[] getEncodedPortalName() {
        return this.encodedName;
    }

    SimpleQuery getQuery() {
        return this.query;
    }

    void setCleanupRef(PhantomReference<?> cleanupRef) {
        this.cleanupRef = cleanupRef;
    }

    public String toString() {
        return this.portalName;
    }
}

