/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.clusterhealthy;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.postgresql.clusterhealthy.ClusterHeartBeat;
import org.postgresql.core.QueryExecutor;
import org.postgresql.log.Log;
import org.postgresql.log.Logger;
import org.postgresql.util.HostSpec;

public class ClusterHeartBeatMaster
extends ClusterHeartBeat {
    public final Map<HostSpec, Set<HostSpec>> CLUSTER_NODE_RELATIONSHIP = new ConcurrentHashMap<HostSpec, Set<HostSpec>>();
    private static volatile ClusterHeartBeatMaster ClusterHeartBeatMaster;
    private static Log LOGGER;
    private final Object NODE_LOCK = new Object();

    private ClusterHeartBeatMaster() {
    }

    public static synchronized ClusterHeartBeatMaster getInstance() {
        if (ClusterHeartBeatMaster == null) {
            ClusterHeartBeatMaster = new ClusterHeartBeatMaster();
        }
        return ClusterHeartBeatMaster;
    }

    public void run() {
        Map<HostSpec, Set<HostSpec>> clusterRelationship = this.getClusterRelationship();
        Iterator<Map.Entry<HostSpec, Set<HostSpec>>> iterator = clusterRelationship.entrySet().iterator();
        LOGGER.debug("master nodes " + clusterRelationship);
        while (iterator.hasNext()) {
            Map.Entry<HostSpec, Set<HostSpec>> nodeMap = iterator.next();
            HostSpec master = nodeMap.getKey();
            Set<HostSpec> slaves = nodeMap.getValue();
            LOGGER.debug("Current node " + master + " Standby node " + slaves);
            QueryExecutor queryExecutor = null;
            Set<Properties> propertiesSet = this.getProperties(master);
            try {
                queryExecutor = super.getQueryExecutor(master, propertiesSet);
            }
            catch (SQLException e) {
                LOGGER.debug("acquire QueryExecutor failure");
                super.cacheProcess(master, slaves, propertiesSet, null);
                continue;
            }
            LOGGER.debug("Information about the current connected node " + queryExecutor.getSocketAddress());
            if (super.nodeRoleIsMaster(queryExecutor)) continue;
            LOGGER.debug(master + ":The host is degraded to the standby server.");
            super.cacheProcess(master, slaves, propertiesSet, null);
        }
    }

    @Override
    public Map<HostSpec, Set<HostSpec>> getClusterRelationship() {
        return this.CLUSTER_NODE_RELATIONSHIP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addClusterNode(HostSpec hostSpecs, HostSpec ... value) {
        Object object = this.NODE_LOCK;
        synchronized (object) {
            Set hostSpecSet = this.CLUSTER_NODE_RELATIONSHIP.computeIfAbsent(hostSpecs, k -> new HashSet());
            Arrays.stream(value).filter(host -> !host.equals(hostSpecs)).forEach(hostSpecSet::add);
            this.CLUSTER_NODE_RELATIONSHIP.put(hostSpecs, hostSpecSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeClusterNode(HostSpec key, HostSpec newKey, Set<HostSpec> slaves) {
        Object object = this.NODE_LOCK;
        synchronized (object) {
            this.CLUSTER_NODE_RELATIONSHIP.remove(key);
            if (newKey != null) {
                Set<HostSpec> hostSpecSet = this.CLUSTER_NODE_RELATIONSHIP.get(newKey);
                if (hostSpecSet == null) {
                    hostSpecSet = new HashSet<HostSpec>();
                }
                hostSpecSet.addAll(slaves);
                hostSpecSet.remove(newKey);
                this.CLUSTER_NODE_RELATIONSHIP.put(newKey, hostSpecSet);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<HostSpec> get(HostSpec hostSpec) {
        Object object = this.NODE_LOCK;
        synchronized (object) {
            return this.CLUSTER_NODE_RELATIONSHIP.get(hostSpec);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.NODE_LOCK;
        synchronized (object) {
            this.CLUSTER_NODE_RELATIONSHIP.clear();
        }
    }

    static {
        LOGGER = Logger.getLogger(ClusterHeartBeatMaster.class.getName());
    }
}

