/*
 * Decompiled with CFR 0.152.
 */
package org.opengauss.core.v3;

import java.io.IOException;
import java.net.ConnectException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import java.util.UUID;
import javax.net.SocketFactory;
import org.opengauss.PGProperty;
import org.opengauss.QueryCNListUtils;
import org.opengauss.clusterchooser.ClusterStatus;
import org.opengauss.clusterchooser.GlobalClusterStatusTracker;
import org.opengauss.clusterhealthy.ClusterNodeCache;
import org.opengauss.core.ConnectionFactory;
import org.opengauss.core.PGStream;
import org.opengauss.core.QueryExecutor;
import org.opengauss.core.ServerVersion;
import org.opengauss.core.SetupQueryRunner;
import org.opengauss.core.SocketFactoryFactory;
import org.opengauss.core.Utils;
import org.opengauss.core.Version;
import org.opengauss.core.v3.QueryExecutorImpl;
import org.opengauss.gss.MakeGSS;
import org.opengauss.hostchooser.CandidateHost;
import org.opengauss.hostchooser.GlobalHostStatusTracker;
import org.opengauss.hostchooser.HostChooser;
import org.opengauss.hostchooser.HostChooserFactory;
import org.opengauss.hostchooser.HostRequirement;
import org.opengauss.hostchooser.HostStatus;
import org.opengauss.hostchooser.MultiHostChooser;
import org.opengauss.jdbc.SslMode;
import org.opengauss.log.Log;
import org.opengauss.log.Logger;
import org.opengauss.quickautobalance.ConnectionManager;
import org.opengauss.ssl.MakeSSL;
import org.opengauss.util.ClusterSpec;
import org.opengauss.util.GT;
import org.opengauss.util.HostSpec;
import org.opengauss.util.MD5Digest;
import org.opengauss.util.PSQLException;
import org.opengauss.util.PSQLState;
import org.opengauss.util.ServerErrorMessage;

public class ConnectionFactoryImpl
extends ConnectionFactory {
    private static Log LOGGER = Logger.getLogger(ConnectionFactoryImpl.class.getName());
    private static final int AUTH_REQ_OK = 0;
    private static final int AUTH_REQ_KRB4 = 1;
    private static final int AUTH_REQ_KRB5 = 2;
    private static final int AUTH_REQ_PASSWORD = 3;
    private static final int AUTH_REQ_CRYPT = 4;
    private static final int AUTH_REQ_MD5 = 5;
    private static final int AUTH_REQ_SCM = 6;
    private static final int AUTH_REQ_GSS = 7;
    private static final int AUTH_REQ_GSS_CONTINUE = 8;
    private static final int AUTH_REQ_SSPI = 9;
    public String CLIENT_ENCODING = "UTF8";
    public static String USE_BOOLEAN = "false";
    private static final int AUTH_REQ_SHA256 = 10;
    private static final int AUTH_REQ_MD5_SHA256 = 11;
    private static final int AUTH_REQ_SM3 = 13;
    private static final int PLAIN_PASSWORD = 0;
    private static final int MD5_PASSWORD = 1;
    private static final int SHA256_PASSWORD = 2;
    private static final int SM3_PASSWORD = 3;
    private static final int ERROR_PASSWORD = 4;
    private static final int PROTOCOL_VERSION_351 = 351;
    private static final int PROTOCOL_VERSION_350 = 350;
    private int protocolVerion = 351;
    private String connectInfo = "";
    public static final HashMap<String, String> CLIENT_ENCODING_WHITELIST = new HashMap();

    public void setClientEncoding(String client) {
        this.CLIENT_ENCODING = client;
    }

    public static void setStaticUseBoolean(String useBoolean) {
        USE_BOOLEAN = useBoolean;
    }

    public void setUseBooleang(String useBoolean) {
        ConnectionFactoryImpl.setStaticUseBoolean(useBoolean);
    }

    private void setSocketTimeout(PGStream stream, Properties info, PGProperty propKey) throws SQLException, IOException {
        int socketTimeout = Integer.parseInt(propKey.getDefaultValue());
        if (propKey.getInt(info) <= 2147483) {
            socketTimeout = propKey.getInt(info);
        } else {
            LOGGER.debug("integer socketTimeout is too large, it will occur error after multiply by 1000.");
        }
        if (socketTimeout >= 0) {
            stream.getSocket().setSoTimeout(socketTimeout * 1000);
        }
    }

    public PGStream tryConnect(String user, String database, Properties info, SocketFactory socketFactory, HostSpec hostSpec, SslMode sslMode) throws SQLException, IOException {
        int sendBufferSize;
        int connectTimeout = Integer.parseInt(PGProperty.CONNECT_TIMEOUT.getDefaultValue());
        if (PGProperty.CONNECT_TIMEOUT.getInt(info) <= 2147483) {
            connectTimeout = PGProperty.CONNECT_TIMEOUT.getInt(info) * 1000;
        } else {
            LOGGER.debug("integer connectTimeout is too large, it will occur error after multiply by 1000.");
        }
        PGStream newStream = new PGStream(socketFactory, hostSpec, connectTimeout);
        newStream = this.enableSSL(newStream, sslMode, info, connectTimeout);
        this.setSocketTimeout(newStream, info, PGProperty.SOCKET_TIMEOUT_IN_CONNECTING);
        boolean requireTCPKeepAlive = PGProperty.TCP_KEEP_ALIVE.getBoolean(info);
        newStream.getSocket().setKeepAlive(requireTCPKeepAlive);
        int receiveBufferSize = PGProperty.RECEIVE_BUFFER_SIZE.getInt(info);
        if (receiveBufferSize > -1) {
            if (receiveBufferSize > 0) {
                newStream.getSocket().setReceiveBufferSize(receiveBufferSize);
            } else {
                LOGGER.warn("Ignore invalid value for receiveBufferSize: " + receiveBufferSize);
            }
        }
        if ((sendBufferSize = PGProperty.SEND_BUFFER_SIZE.getInt(info)) > -1) {
            if (sendBufferSize > 0) {
                newStream.getSocket().setSendBufferSize(sendBufferSize);
            } else {
                LOGGER.warn("Ignore invalid value for sendBufferSize: " + sendBufferSize);
            }
        }
        List<String[]> paramList = this.getParametersForStartup(user, database, info);
        String protocolProp = info.getProperty("protocolVersion");
        this.protocolVerion = protocolProp != null && !protocolProp.isEmpty() ? Integer.parseInt(protocolProp) : 351;
        this.sendStartupPacket(newStream, paramList);
        this.doAuthentication(newStream, hostSpec.getHost(), user, info);
        this.setSocketTimeout(newStream, info, PGProperty.SOCKET_TIMEOUT);
        return newStream;
    }

    @Override
    public QueryExecutor openConnectionImpl(HostSpec[] hostSpecs, String user, String database, Properties info) throws SQLException {
        HostRequirement targetServerType;
        if (info.getProperty("characterEncoding") != null) {
            if (CLIENT_ENCODING_WHITELIST.containsKey(info.getProperty("characterEncoding").toUpperCase(Locale.ENGLISH))) {
                this.setClientEncoding(info.getProperty("characterEncoding").toUpperCase(Locale.ENGLISH));
            } else {
                LOGGER.warn("unsupported client_encoding: " + info.getProperty("characterEncoding") + ", to ensure correct operation, please use the specified range of client_encoding.");
            }
        }
        if (info.getProperty("use_boolean") != null) {
            this.setUseBooleang(info.getProperty("use_boolean").toUpperCase(Locale.ENGLISH));
        }
        SslMode sslMode = SslMode.of(info);
        String targetServerTypeStr = PGProperty.TARGET_SERVER_TYPE.get(info);
        try {
            targetServerType = HostRequirement.getTargetServerType(targetServerTypeStr);
        }
        catch (IllegalArgumentException ex) {
            throw new PSQLException(GT.tr("Invalid targetServerType value: {0}", targetServerTypeStr), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
        }
        SocketFactory socketFactory = SocketFactoryFactory.getSocketFactory(info);
        Iterator<ClusterSpec> clusterIter = GlobalClusterStatusTracker.getClusterFromHostSpecs(hostSpecs, info);
        HashMap<HostSpec, HostStatus> knownStates = new HashMap<HostSpec, HostStatus>();
        Exception exception = new Exception();
        while (clusterIter.hasNext()) {
            ClusterSpec clusterSpec = clusterIter.next();
            HostSpec[] currentHostSpecs = clusterSpec.getHostSpecs();
            if (currentHostSpecs.length > 1 && targetServerType == HostRequirement.master) {
                ClusterNodeCache.checkHostSpecs(currentHostSpecs);
            }
            HostChooser hostChooser = HostChooserFactory.createHostChooser(currentHostSpecs, targetServerType, info);
            Iterator<CandidateHost> hostIter = hostChooser.iterator();
            boolean isMasterCluster = false;
            boolean isFirstIter = true;
            while (hostIter.hasNext()) {
                CandidateHost candidateHost = hostIter.next();
                HostSpec hostSpec = candidateHost.hostSpec;
                HostStatus knownStatus = (HostStatus)((Object)knownStates.get(hostSpec));
                if (isFirstIter) {
                    isFirstIter = false;
                } else {
                    ConnectionManager.getInstance().incrementCachedCreatingConnectionSize(hostSpec, info);
                }
                if (knownStatus != null && !candidateHost.targetServerType.allowConnectingTo(knownStatus)) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Known status of host " + hostSpec + " is " + (Object)((Object)knownStatus) + ", and required status was " + (Object)((Object)candidateHost.targetServerType) + ". Will try next host");
                    }
                    ConnectionManager.getInstance().decrementCachedCreatingConnectionSize(hostSpec, info);
                    continue;
                }
                this.connectInfo = UUID.randomUUID().toString();
                LOGGER.info("[" + this.connectInfo + "] Try to connect. IP: " + hostSpec.toString());
                PGStream newStream = null;
                try {
                    try {
                        newStream = this.tryConnect(user, database, info, socketFactory, hostSpec, sslMode);
                    }
                    catch (SQLException e) {
                        Exception ex;
                        if (sslMode == SslMode.PREFER && PSQLState.INVALID_AUTHORIZATION_SPECIFICATION.getState().equals(e.getSQLState())) {
                            ex = null;
                            try {
                                newStream = this.tryConnect(user, database, info, socketFactory, hostSpec, SslMode.DISABLE);
                                LOGGER.debug("Downgraded to non-encrypted connection for host " + hostSpec);
                            }
                            catch (SQLException ee) {
                                ex = ee;
                            }
                            catch (IOException ee) {
                                ex = ee;
                            }
                            if (ex != null) {
                                LOGGER.debug("sslMode==PREFER, however non-SSL connection failed as well", ex);
                                throw e;
                            }
                        }
                        if (sslMode == SslMode.ALLOW && PSQLState.INVALID_AUTHORIZATION_SPECIFICATION.getState().equals(e.getSQLState())) {
                            ex = null;
                            try {
                                newStream = this.tryConnect(user, database, info, socketFactory, hostSpec, SslMode.REQUIRE);
                                LOGGER.debug("Upgraded to encrypted connection for host " + hostSpec);
                            }
                            catch (SQLException ee) {
                                ex = ee;
                            }
                            catch (IOException ee) {
                                ex = ee;
                            }
                            if (ex != null) {
                                LOGGER.debug("sslMode==ALLOW, however SSL connection failed as well", ex);
                                throw e;
                            }
                        }
                        throw e;
                    }
                    int cancelSignalTimeout = Integer.parseInt(PGProperty.CANCEL_SIGNAL_TIMEOUT.getDefaultValue());
                    if (PGProperty.CANCEL_SIGNAL_TIMEOUT.getInt(info) <= 2147483) {
                        cancelSignalTimeout = PGProperty.CANCEL_SIGNAL_TIMEOUT.getInt(info) * 1000;
                    } else {
                        LOGGER.debug("integer cancelSignalTimeout is too large, it will occur error after multiply by 1000.");
                    }
                    LOGGER.info("[" + newStream.getSecConnectInfo() + "] Connection is established. ID: " + this.connectInfo);
                    QueryExecutorImpl queryExecutor = new QueryExecutorImpl(newStream, user, database, cancelSignalTimeout, info);
                    queryExecutor.setProtocolVersion(this.protocolVerion);
                    queryExecutor.setClientEncoding(this.CLIENT_ENCODING);
                    if (PGProperty.PRIORITY_SERVERS.get(info) != null) {
                        ClusterStatus currentClusterStatus = this.queryClusterStatus(queryExecutor);
                        GlobalClusterStatusTracker.reportClusterStatus(clusterSpec, currentClusterStatus);
                        if (currentClusterStatus == ClusterStatus.MasterCluster) {
                            isMasterCluster = true;
                            GlobalClusterStatusTracker.reportMasterCluster(info, clusterSpec);
                        }
                    } else {
                        HostStatus hostStatus = HostStatus.ConnectOK;
                        if (candidateHost.targetServerType != HostRequirement.any) {
                            hostStatus = this.isMaster(queryExecutor) ? HostStatus.Master : HostStatus.Secondary;
                            LOGGER.info("Known status of host " + hostSpec + " is " + (Object)((Object)hostStatus));
                        }
                        GlobalHostStatusTracker.reportHostStatus(hostSpec, hostStatus, info);
                        knownStates.put(hostSpec, hostStatus);
                        if (!candidateHost.targetServerType.allowConnectingTo(hostStatus)) {
                            queryExecutor.close();
                            ConnectionManager.getInstance().decrementCachedCreatingConnectionSize(hostSpec, info);
                            continue;
                        }
                        if (info.getProperty("replication") == null) {
                            this.runInitialQueries(queryExecutor, info);
                            String queryGaussdbVersionResult = this.queryGaussdbVersion(queryExecutor);
                            queryExecutor.setGaussdbVersion(queryGaussdbVersionResult);
                            queryExecutor.setCompatibilityMode(this.queryDataBaseDatcompatibility(queryExecutor, database));
                        }
                        if (MultiHostChooser.isUsingAutoLoadBalance(info)) {
                            QueryCNListUtils.runRereshCNListQueryies(queryExecutor, info);
                        }
                        LOGGER.info("Connect complete. ID: " + this.connectInfo);
                        return queryExecutor;
                    }
                    queryExecutor.close();
                    ConnectionManager.getInstance().decrementCachedCreatingConnectionSize(hostSpec, info);
                    break;
                }
                catch (ConnectException cex) {
                    GlobalHostStatusTracker.reportHostStatus(hostSpec, HostStatus.ConnectFail, info);
                    knownStates.put(hostSpec, HostStatus.ConnectFail);
                    if (hostIter.hasNext() || clusterIter.hasNext()) {
                        LOGGER.info("ConnectException occured while connecting to {0}" + hostSpec, cex);
                        exception.addSuppressed(cex);
                        ConnectionManager.getInstance().decrementCachedCreatingConnectionSize(hostSpec, info);
                        continue;
                    }
                    if (exception.getSuppressed().length > 0) {
                        cex.addSuppressed(exception);
                    }
                    ConnectionManager.getInstance().decrementCachedCreatingConnectionSize(hostSpec, info);
                    throw new PSQLException(GT.tr("Connection to {0} refused. Check that the hostname and port are correct and that the postmaster is accepting TCP/IP connections.", hostSpec), PSQLState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)cex);
                }
                catch (IOException ioe) {
                    this.closeStream(newStream);
                    GlobalHostStatusTracker.reportHostStatus(hostSpec, HostStatus.ConnectFail, info);
                    knownStates.put(hostSpec, HostStatus.ConnectFail);
                    if (hostIter.hasNext() || clusterIter.hasNext()) {
                        LOGGER.info("IOException occured while connecting to " + hostSpec, ioe);
                        exception.addSuppressed(ioe);
                        ConnectionManager.getInstance().decrementCachedCreatingConnectionSize(hostSpec, info);
                        continue;
                    }
                    if (exception.getSuppressed().length > 0) {
                        ioe.addSuppressed(exception);
                    }
                    ConnectionManager.getInstance().decrementCachedCreatingConnectionSize(hostSpec, info);
                    throw new PSQLException(GT.tr("The connection attempt failed.", new Object[0]), PSQLState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)ioe);
                }
                catch (SQLException se) {
                    this.closeStream(newStream);
                    GlobalHostStatusTracker.reportHostStatus(hostSpec, HostStatus.ConnectFail, info);
                    knownStates.put(hostSpec, HostStatus.ConnectFail);
                    if (hostIter.hasNext() || clusterIter.hasNext()) {
                        LOGGER.info("SQLException occured while connecting to " + hostSpec, se);
                        exception.addSuppressed(se);
                        ConnectionManager.getInstance().decrementCachedCreatingConnectionSize(hostSpec, info);
                        continue;
                    }
                    if (exception.getSuppressed().length > 0) {
                        se.addSuppressed(exception);
                    }
                    ConnectionManager.getInstance().decrementCachedCreatingConnectionSize(hostSpec, info);
                    throw se;
                }
            }
            if (isMasterCluster) {
                LOGGER.info("Could not find a server with specified targetServerType: " + (Object)((Object)targetServerType) + ". The current server known status is: " + knownStates.entrySet().toString());
                throw new PSQLException(GT.tr("Could not find a server with specified targetServerType: {0}", new Object[]{targetServerType}), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
            }
            GlobalClusterStatusTracker.reportClusterStatus(clusterSpec, ClusterStatus.ConnectFail);
        }
        if (PGProperty.PRIORITY_SERVERS.get(info) != null) {
            LOGGER.info("Could not find production cluster");
            throw new PSQLException(GT.tr("Could not find production cluster", new Object[0]), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
        }
        LOGGER.info("Could not find a server with specified targetServerType: " + (Object)((Object)targetServerType) + ". The current server known status is: " + knownStates.entrySet().toString());
        throw new PSQLException(GT.tr("Could not find a server with specified targetServerType: {0}", new Object[]{targetServerType}), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
    }

    private List<String[]> getParametersForStartup(String user, String database, Properties info) {
        String options;
        String currentSchema;
        ArrayList<String[]> paramList = new ArrayList<String[]>();
        paramList.add(new String[]{"user", user});
        paramList.add(new String[]{"database", database});
        paramList.add(new String[]{"client_encoding", this.CLIENT_ENCODING});
        paramList.add(new String[]{"DateStyle", "ISO"});
        paramList.add(new String[]{"TimeZone", ConnectionFactoryImpl.createPostgresTimeZone()});
        Version assumeVersion = ServerVersion.from(PGProperty.ASSUME_MIN_SERVER_VERSION.get(info));
        if (assumeVersion.getVersionNum() >= ServerVersion.v9_0.getVersionNum()) {
            paramList.add(new String[]{"extra_float_digits", "3"});
            String appName = PGProperty.APPLICATION_NAME.get(info);
            if (appName != null) {
                paramList.add(new String[]{"application_name", appName});
            }
        } else {
            paramList.add(new String[]{"extra_float_digits", "2"});
        }
        String replication = PGProperty.REPLICATION.get(info);
        if (replication != null && assumeVersion.getVersionNum() >= ServerVersion.v9_4.getVersionNum()) {
            paramList.add(new String[]{"replication", replication});
        }
        if ((currentSchema = PGProperty.CURRENT_SCHEMA.get(info)) != null) {
            paramList.add(new String[]{"search_path", currentSchema});
        }
        if (PGProperty.PG_CLIENT_LOGIC.get(info) != null && PGProperty.PG_CLIENT_LOGIC.get(info).equals("1")) {
            paramList.add(new String[]{"enable_full_encryption", "1"});
        }
        if ((options = PGProperty.OPTIONS.get(info)) != null) {
            paramList.add(new String[]{"options", options});
        }
        return paramList;
    }

    private static String createPostgresTimeZone() {
        String start;
        String tz = TimeZone.getDefault().getID();
        if (tz.length() <= 3 || !tz.startsWith("GMT")) {
            return tz;
        }
        char sign = tz.charAt(3);
        switch (sign) {
            case '+': {
                start = "GMT-";
                break;
            }
            case '-': {
                start = "GMT+";
                break;
            }
            default: {
                return tz;
            }
        }
        return start + tz.substring(4);
    }

    private PGStream enableSSL(PGStream pgStream, SslMode sslMode, Properties info, int connectTimeout) throws IOException, PSQLException {
        if (sslMode == SslMode.DISABLE) {
            return pgStream;
        }
        if (sslMode == SslMode.ALLOW) {
            return pgStream;
        }
        LOGGER.trace(" FE=> SSLRequest");
        pgStream.sendInteger4(8);
        pgStream.sendInteger2(1234);
        pgStream.sendInteger2(5679);
        pgStream.flush();
        int beresp = pgStream.receiveChar();
        switch (beresp) {
            case 69: {
                LOGGER.trace(" <=BE SSLError");
                if (sslMode.requireEncryption()) {
                    throw new PSQLException(GT.tr("The server does not support SSL.", new Object[0]), PSQLState.CONNECTION_REJECTED);
                }
                pgStream.close();
                return new PGStream(pgStream.getSocketFactory(), pgStream.getHostSpec(), connectTimeout);
            }
            case 78: {
                LOGGER.trace(" <=BE SSLRefused");
                if (sslMode.requireEncryption()) {
                    throw new PSQLException(GT.tr("The server does not support SSL.", new Object[0]), PSQLState.CONNECTION_REJECTED);
                }
                return pgStream;
            }
            case 83: {
                LOGGER.trace(" <=BE SSLOk");
                MakeSSL.convert(pgStream, info);
                return pgStream;
            }
        }
        throw new PSQLException(GT.tr("An error occured while setting up the SSL connection.", new Object[0]), PSQLState.PROTOCOL_VIOLATION);
    }

    private void sendStartupPacket(PGStream pgStream, List<String[]> params) throws IOException {
        if (LOGGER.isDebugEnabled()) {
            StringBuilder details = new StringBuilder();
            for (int i = 0; i < params.size(); ++i) {
                if (i != 0) {
                    details.append(", ");
                }
                details.append(params.get(i)[0]);
                details.append("=");
                details.append(params.get(i)[1]);
            }
            LOGGER.debug("[" + this.connectInfo + "] FE=> StartupPacket(" + details + ")");
        }
        int length = 8;
        byte[][] encodedParams = new byte[params.size() * 2][];
        for (int i = 0; i < params.size(); ++i) {
            encodedParams[i * 2] = params.get(i)[0].getBytes("UTF-8");
            encodedParams[i * 2 + 1] = params.get(i)[1].getBytes("UTF-8");
            length += encodedParams[i * 2].length + 1 + encodedParams[i * 2 + 1].length + 1;
        }
        pgStream.sendInteger4(++length);
        pgStream.sendInteger2(3);
        if (this.protocolVerion < 350) {
            pgStream.sendInteger2(0);
        } else if (this.protocolVerion == 350) {
            pgStream.sendInteger2(50);
        } else if (this.protocolVerion == 351) {
            pgStream.sendInteger2(51);
        }
        for (byte[] encodedParam : encodedParams) {
            pgStream.send(encodedParam);
            pgStream.sendChar(0);
        }
        pgStream.sendChar(0);
        pgStream.flush();
    }

    private void doAuthentication(PGStream pgStream, String host, String user, Properties info) throws IOException, SQLException {
        String password = PGProperty.PASSWORD.get(info);
        block13: while (true) {
            int beresp = pgStream.receiveChar();
            block0 : switch (beresp) {
                case 69: {
                    int l_elen = pgStream.receiveInteger4();
                    ServerErrorMessage errorMsg = new ServerErrorMessage(pgStream.receiveErrorString(l_elen - 4), pgStream.getConnectInfo());
                    LOGGER.trace("[" + this.connectInfo + "] <=BE ErrorMessage(" + errorMsg + ")");
                    throw new PSQLException(errorMsg);
                }
                case 82: {
                    pgStream.receiveInteger4();
                    int areq = pgStream.receiveInteger4();
                    switch (areq) {
                        case 5: {
                            byte[] md5Salt = pgStream.receive(4);
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("[" + this.connectInfo + "] <=BE AuthenticationReqMD5(salt=" + Utils.toHexString(md5Salt) + ")");
                            }
                            if (password == null) {
                                throw new PSQLException(GT.tr("The server requested password-based authentication, but no password was provided.", new Object[0]), PSQLState.CONNECTION_REJECTED);
                            }
                            byte[] digest = MD5Digest.encode(user.getBytes("UTF-8"), password.getBytes("UTF-8"), md5Salt);
                            pgStream.sendChar(112);
                            pgStream.sendInteger4(4 + digest.length + 1);
                            pgStream.send(digest);
                            pgStream.sendChar(0);
                            pgStream.flush();
                            break block0;
                        }
                        case 11: {
                            LOGGER.trace("AUTH_REQ_MD5_SHA256 ID: " + this.connectInfo);
                            String random64code = pgStream.receiveString(64);
                            byte[] md5Salt = pgStream.receive(4);
                            byte[] digest = MD5Digest.MD5_SHA256encode(password, random64code, md5Salt);
                            pgStream.sendChar(112);
                            pgStream.sendInteger4(4 + digest.length + 1);
                            pgStream.send(digest);
                            pgStream.sendChar(0);
                            pgStream.flush();
                            break block0;
                        }
                        case 13: {
                            byte[] result;
                            LOGGER.trace("[" + this.connectInfo + "] AUTH_REQ_SM3");
                            int passwordStoredMethod = pgStream.receiveInteger4();
                            if (password == null) {
                                throw new PSQLException(GT.tr("The server requested password-based authentication, but no password was provided.", new Object[0]), PSQLState.CONNECTION_REJECTED);
                            }
                            if (passwordStoredMethod == 3) {
                                String random64code = pgStream.receiveString(64);
                                String token = pgStream.receiveString(8);
                                int serverIteration = pgStream.receiveInteger4();
                                result = null;
                                result = MD5Digest.RFC5802Algorithm(password, random64code, token, null, serverIteration, false);
                                if (result == null) {
                                    throw new PSQLException(GT.tr("Invalid username/password,login denied.", new Object[0]), PSQLState.CONNECTION_REJECTED);
                                }
                                pgStream.sendChar(112);
                                pgStream.sendInteger4(4 + result.length + 1);
                                pgStream.send(result);
                                pgStream.sendChar(0);
                                pgStream.flush();
                                break block0;
                            }
                            throw new PSQLException(GT.tr("The password-stored method is not supported, must be md5, sha256 or sm3.", new Object[0]), PSQLState.CONNECTION_REJECTED);
                        }
                        case 10: {
                            byte[] result;
                            LOGGER.trace("[" + this.connectInfo + "] AUTH_REQ_SHA256");
                            int passwordStoredMethod = pgStream.receiveInteger4();
                            if (password == null) {
                                throw new PSQLException(GT.tr("The server requested password-based authentication, but no password was provided.", new Object[0]), PSQLState.CONNECTION_REJECTED);
                            }
                            if (passwordStoredMethod == 0 || passwordStoredMethod == 2) {
                                String random64code = pgStream.receiveString(64);
                                String token = pgStream.receiveString(8);
                                result = null;
                                if (this.protocolVerion < 350) {
                                    String server_signature = pgStream.receiveString(64);
                                    int server_iteration_350 = 2048;
                                    result = MD5Digest.RFC5802Algorithm(password, random64code, token, server_signature, server_iteration_350, true);
                                } else if (this.protocolVerion == 350) {
                                    result = MD5Digest.RFC5802Algorithm(password, random64code, token);
                                } else {
                                    int server_iteration = pgStream.receiveInteger4();
                                    result = MD5Digest.RFC5802Algorithm(password, random64code, token, server_iteration);
                                }
                                if (result == null) {
                                    throw new PSQLException(GT.tr("Invalid username/password,login denied.", new Object[0]), PSQLState.CONNECTION_REJECTED);
                                }
                                pgStream.sendChar(112);
                                pgStream.sendInteger4(4 + result.length + 1);
                                pgStream.send(result);
                                pgStream.sendChar(0);
                                pgStream.flush();
                                break block0;
                            }
                            if (passwordStoredMethod != 1) {
                                throw new PSQLException(GT.tr("The password-stored method is not supported, must be md5, sha256 or sm3.", new Object[0]), PSQLState.CONNECTION_REJECTED);
                            }
                            byte[] md5Salt = pgStream.receive(4);
                            byte[] digest = MD5Digest.SHA256_MD5encode(user.getBytes("UTF-8"), password.getBytes("UTF-8"), md5Salt);
                            pgStream.sendChar(112);
                            pgStream.sendInteger4(4 + digest.length + 1);
                            pgStream.send(digest);
                            pgStream.sendChar(0);
                            pgStream.flush();
                            break block0;
                        }
                        case 3: {
                            LOGGER.debug("[" + this.connectInfo + "] <=BE AuthenticationReqPassword ID: " + this.connectInfo);
                            if (password == null) {
                                throw new PSQLException(GT.tr("The server requested password-based authentication, but no password was provided.", new Object[0]), PSQLState.CONNECTION_REJECTED);
                            }
                            byte[] encodedPassword = password.getBytes("UTF-8");
                            pgStream.sendChar(112);
                            pgStream.sendInteger4(4 + encodedPassword.length + 1);
                            pgStream.send(encodedPassword);
                            pgStream.sendChar(0);
                            pgStream.flush();
                            break block0;
                        }
                        case 7: 
                        case 9: {
                            String kerberosServerHostname;
                            if (areq == 7 && (kerberosServerHostname = info.getProperty("kerberosServerHostname")) != null && kerberosServerHostname.length() != 0) {
                                System.setProperty("kerberosServerHostname", kerberosServerHostname);
                            }
                            MakeGSS.authenticate(pgStream, host, user, password, PGProperty.JAAS_APPLICATION_NAME.get(info), PGProperty.KERBEROS_SERVER_NAME.get(info), PGProperty.USE_SPNEGO.getBoolean(info), PGProperty.JAAS_LOGIN.getBoolean(info));
                            if (!LOGGER.isDebugEnabled()) continue block13;
                            if (areq == 7) {
                                LOGGER.debug("[" + this.connectInfo + "] AUTH_REQ_GSS");
                                break block0;
                            }
                            LOGGER.debug("[" + this.connectInfo + "] AUTH_REQ_SSPI");
                            break block0;
                        }
                        case 0: {
                            LOGGER.debug("[" + this.connectInfo + "] <=BE AuthenticationOk");
                            break block13;
                        }
                        default: {
                            LOGGER.trace("[" + this.connectInfo + "] <=BE AuthenticationReq (unsupported type " + areq + ")");
                            throw new PSQLException(GT.tr("The authentication type {0} is not supported. Check that you have configured the pg_hba.conf file to include the client''s IP address or subnet, and that it is using an authentication scheme supported by the driver.", areq), PSQLState.CONNECTION_REJECTED);
                        }
                    }
                }
                default: {
                    throw new PSQLException(GT.tr("Protocol error.  Session setup failed.", new Object[0]), PSQLState.PROTOCOL_VIOLATION);
                }
            }
        }
    }

    private void runInitialQueries(QueryExecutor queryExecutor, Properties info) throws SQLException {
        String appType;
        String appName;
        String assumeMinServerVersion = PGProperty.ASSUME_MIN_SERVER_VERSION.get(info);
        if (Utils.parseServerVersionStr(assumeMinServerVersion) >= ServerVersion.v9_0.getVersionNum()) {
            return;
        }
        int dbVersion = queryExecutor.getServerVersionNum();
        if (dbVersion >= ServerVersion.v9_0.getVersionNum()) {
            String setSql = "SET extra_float_digits = 3;set client_encoding = '" + this.CLIENT_ENCODING + "';";
            SetupQueryRunner.run(queryExecutor, setSql, false);
        }
        if ((appName = PGProperty.APPLICATION_NAME.get(info)) != null && dbVersion >= ServerVersion.v9_0.getVersionNum()) {
            StringBuilder sql = new StringBuilder();
            sql.append("SET application_name = '");
            Utils.escapeLiteral(sql, appName, queryExecutor.getStandardConformingStrings());
            sql.append("'");
            SetupQueryRunner.run(queryExecutor, sql.toString(), false);
        }
        if ((appType = PGProperty.APPLICATION_TYPE.get(info)) != null && !appType.equals(queryExecutor.getApplicationType())) {
            StringBuilder sql = new StringBuilder();
            sql.append("SET application_type = '");
            Utils.escapeLiteral(sql, appType, queryExecutor.getStandardConformingStrings());
            sql.append("'");
            SetupQueryRunner.run(queryExecutor, sql.toString(), false);
        }
    }

    public boolean isMaster(QueryExecutor queryExecutor) throws SQLException, IOException {
        String localRole = "";
        String dbState = "";
        List<byte[][]> results = SetupQueryRunner.runForList(queryExecutor, "select local_role, db_state from pg_stat_get_stream_replications();", true);
        for (byte[][] result : results) {
            localRole = queryExecutor.getEncoding().decode(result[0]);
            dbState = queryExecutor.getEncoding().decode(result[1]);
        }
        return localRole.equalsIgnoreCase("Primary") && dbState.equalsIgnoreCase("Normal");
    }

    private String queryDataBaseDatcompatibility(QueryExecutor queryExecutor, String database) throws SQLException, IOException {
        byte[][] result = SetupQueryRunner.run(queryExecutor, "select datcompatibility from pg_database where datname='" + database + "';", true);
        String datcompatibility = queryExecutor.getEncoding().decode(result[0]);
        return datcompatibility == null ? "PG" : datcompatibility;
    }

    private String queryGaussdbVersion(QueryExecutor queryExecutor) throws SQLException, IOException {
        byte[][] result = SetupQueryRunner.run(queryExecutor, "select version();", true);
        String version = queryExecutor.getEncoding().decode(result[0]);
        if (version != null && version.contains("GaussDB Kernel")) {
            return "GaussDBKernel";
        }
        if (version != null && version.contains("openGauss")) {
            return "openGauss";
        }
        return "";
    }

    private ClusterStatus queryClusterStatus(QueryExecutor queryExecutor) throws SQLException, IOException {
        byte[][] result = SetupQueryRunner.run(queryExecutor, "select barrier_id from gs_get_local_barrier_status();", true);
        String barrierId = queryExecutor.getEncoding().decode(result[0]);
        if (barrierId != null && !barrierId.equals("")) {
            return ClusterStatus.SecondaryCluster;
        }
        return ClusterStatus.MasterCluster;
    }

    static {
        CLIENT_ENCODING_WHITELIST.put("UTF8", "UTF8");
        CLIENT_ENCODING_WHITELIST.put("UTF-8", "UTF-8");
        CLIENT_ENCODING_WHITELIST.put("GBK", "GBK");
        CLIENT_ENCODING_WHITELIST.put("GB18030", "GB18030");
        CLIENT_ENCODING_WHITELIST.put("LATIN1", "LATIN1");
    }
}

