/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.test;

import java.util.Collection;

public class Assert
extends org.junit.Assert {
    protected Assert() {
    }

    public static void assertInstanceOf(String string, Class<?> clazz, Object object) {
        if (clazz != null && !clazz.isInstance(object)) {
            Assert.fail((String)(string + " Value \"" + object + "\" is of type " + object.getClass().getSimpleName() + " while the expected type was " + clazz.getSimpleName() + '.'));
        }
    }

    public static void assertPositive(String string, int n) {
        if (n < 0) {
            Assert.fail((String)(string + " Value is " + n + '.'));
        }
    }

    public static void assertStrictlyPositive(String string, int n) {
        if (n <= 0) {
            Assert.fail((String)(string + " Value is " + n + '.'));
        }
    }

    public static <T> void assertValidRange(String string, Comparable<T> comparable, Comparable<T> comparable2) {
        if (comparable != null && comparable2 != null && comparable.compareTo(comparable2) > 0) {
            Assert.fail((String)(string + " Range found is [" + comparable + " ... " + comparable2 + "]."));
        }
    }

    public static void assertValidRange(String string, int n, int n2) {
        if (n > n2) {
            Assert.fail((String)(string + " Range found is [" + n + " ... " + n2 + "]."));
        }
    }

    public static void assertValidRange(String string, double d, double d2) {
        if (!(d <= d2)) {
            Assert.fail((String)(string + " Range found is [" + d + " ... " + d2 + "]."));
        }
    }

    public static <T> void assertBetween(String string, Comparable<T> comparable, Comparable<T> comparable2, T t) {
        if (comparable != null && comparable.compareTo(t) > 0) {
            Assert.fail((String)(string + " Value " + t + " is less than " + comparable + '.'));
        }
        if (comparable2 != null && comparable2.compareTo(t) < 0) {
            Assert.fail((String)(string + " Value " + t + " is greater than " + comparable2 + '.'));
        }
    }

    public static void assertBetween(String string, int n, int n2, int n3) {
        if (n3 < n) {
            Assert.fail((String)(string + " Value is " + n3 + " is less than " + n + '.'));
        }
        if (n3 > n2) {
            Assert.fail((String)(string + " Value is " + n3 + " is greater than " + n2 + '.'));
        }
    }

    public static void assertBetween(String string, double d, double d2, double d3) {
        if (d3 < d) {
            Assert.fail((String)(string + " Value is " + d3 + " is less than " + d + '.'));
        }
        if (d3 > d2) {
            Assert.fail((String)(string + " Value is " + d3 + " is greater than " + d2 + '.'));
        }
    }

    public static void assertContains(String string, Collection<?> collection, Object object) {
        if (collection != null && !collection.contains(object)) {
            Assert.fail((String)(string + " Looked for value \"" + object + "\" in a collection of " + collection.size() + "elements."));
        }
    }
}

