/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.test.referencing;

import java.util.Collections;
import java.util.Map;
import org.junit.Assume;
import org.junit.Test;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.test.Assert;
import org.opengis.test.TestCase;
import org.opengis.test.Units;
import org.opengis.test.Validators;
import org.opengis.util.FactoryException;

public abstract class ReferencingTest
extends TestCase {
    private final Units units = Units.getDefault();
    protected final CRSFactory crsFactory;
    protected final CSFactory csFactory;
    protected final DatumFactory datumFactory;

    protected ReferencingTest(CRSFactory cRSFactory, CSFactory cSFactory, DatumFactory datumFactory) {
        this.crsFactory = cRSFactory;
        this.csFactory = cSFactory;
        this.datumFactory = datumFactory;
    }

    private static Map<String, String> createMapWithName(String string) {
        return Collections.singletonMap("name", string);
    }

    @Test
    public void testWGS84() throws FactoryException {
        Assume.assumeNotNull((Object[])new Object[]{this.datumFactory});
        PrimeMeridian primeMeridian = this.datumFactory.createPrimeMeridian(ReferencingTest.createMapWithName("Greenwich"), 0.0, this.units.degree());
        Validators.validate(primeMeridian);
        Ellipsoid ellipsoid = this.datumFactory.createEllipsoid(ReferencingTest.createMapWithName("WGS 84"), 6378137.0, 298.257223563, this.units.metre());
        Validators.validate(ellipsoid);
        GeodeticDatum geodeticDatum = this.datumFactory.createGeodeticDatum(ReferencingTest.createMapWithName("World Geodetic System 1984"), ellipsoid, primeMeridian);
        Validators.validate(geodeticDatum);
        Assume.assumeNotNull((Object[])new Object[]{this.csFactory});
        CoordinateSystemAxis coordinateSystemAxis = this.csFactory.createCoordinateSystemAxis(ReferencingTest.createMapWithName("Geodetic longitude"), "\u03bb", AxisDirection.EAST, this.units.degree());
        Validators.validate(coordinateSystemAxis);
        CoordinateSystemAxis coordinateSystemAxis2 = this.csFactory.createCoordinateSystemAxis(ReferencingTest.createMapWithName("Geodetic latitude"), "\u03c6", AxisDirection.NORTH, this.units.degree());
        Validators.validate(coordinateSystemAxis2);
        CoordinateSystemAxis coordinateSystemAxis3 = this.csFactory.createCoordinateSystemAxis(ReferencingTest.createMapWithName("height"), "h", AxisDirection.UP, this.units.metre());
        Validators.validate(coordinateSystemAxis3);
        EllipsoidalCS ellipsoidalCS = this.csFactory.createEllipsoidalCS(ReferencingTest.createMapWithName("WGS 84"), coordinateSystemAxis2, coordinateSystemAxis, coordinateSystemAxis3);
        Validators.validate(ellipsoidalCS);
        Assume.assumeNotNull((Object[])new Object[]{this.crsFactory});
        GeographicCRS geographicCRS = this.crsFactory.createGeographicCRS(ReferencingTest.createMapWithName("WGS84(DD)"), geodeticDatum, ellipsoidalCS);
        Validators.validate(geographicCRS);
        ellipsoidalCS = geographicCRS.getCoordinateSystem();
        coordinateSystemAxis = ellipsoidalCS.getAxis(1);
        coordinateSystemAxis2 = ellipsoidalCS.getAxis(0);
        coordinateSystemAxis3 = ellipsoidalCS.getAxis(2);
        Assert.assertEquals((Object)"Geodetic latitude", (Object)coordinateSystemAxis2.getName().toString());
        Assert.assertEquals((Object)AxisDirection.NORTH, (Object)coordinateSystemAxis2.getDirection());
        Assert.assertEquals(this.units.degree(), (Object)coordinateSystemAxis2.getUnit());
        Assert.assertEquals((Object)"Geodetic longitude", (Object)coordinateSystemAxis.getName().toString());
        Assert.assertEquals((Object)AxisDirection.EAST, (Object)coordinateSystemAxis.getDirection());
        Assert.assertEquals(this.units.degree(), (Object)coordinateSystemAxis.getUnit());
        Assert.assertEquals((Object)"height", (Object)coordinateSystemAxis3.getName().toString());
        Assert.assertEquals((Object)AxisDirection.UP, (Object)coordinateSystemAxis3.getDirection());
        Assert.assertEquals(this.units.metre(), (Object)coordinateSystemAxis3.getUnit());
        geodeticDatum = geographicCRS.getDatum();
        Assert.assertEquals((Object)"World Geodetic System 1984", (Object)geodeticDatum.getName().toString());
        primeMeridian = geodeticDatum.getPrimeMeridian();
        Assert.assertEquals((double)0.0, (double)primeMeridian.getGreenwichLongitude(), (double)0.0);
        Assert.assertEquals(this.units.degree(), (Object)primeMeridian.getAngularUnit());
    }
}

