/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.tools.analysis.checkstyle;

import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.FileText;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.BiPredicate;
import org.apache.commons.collections.CollectionUtils;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.openhab.tools.analysis.checkstyle.api.AbstractStaticCheck;

public class BuildPropertiesCheck
extends AbstractStaticCheck {
    private static final String MISSING_PROPERTY_MSG = "Missing %s property in the %s file.";
    private static final String MISSING_VALUE_MSG = "Property  %s in the %s file is missing value: ";
    private static final String MISSING_BIN_INCLUDES_PROPERTY_MSG = String.format("Missing %s property in the %s file.", "bin.includes", "build.properties");
    private static final String MISSING_BIN_INCLUDES_VALUE_MSG = String.format("Property  %s in the %s file is missing value: ", "bin.includes", "build.properties");
    private static final String MISSING_OUTPUT_VALUE_MSG = String.format("Property  %s in the %s file is missing value: ", "output..", "build.properties");
    private static final String MISSING_SRC_VALUE_MSG = String.format("Property  %s in the %s file is missing value: ", "source..", "build.properties");
    private static final String EMPTY_FILE_MSG = String.format("Empty %s file", "build.properties");
    private List<String> expectedBinIncludesValues;
    private List<String> possibleOutputValues;
    private List<String> possibleSourceValues;

    public BuildPropertiesCheck() {
        this.setFileExtensions(new String[]{"properties"});
    }

    public void setExpectedBinIncludesValues(String[] binIncludesValues) {
        this.expectedBinIncludesValues = Arrays.asList(binIncludesValues);
    }

    public void setPossibleOutputValues(String[] outputValues) {
        this.possibleOutputValues = Arrays.asList(outputValues);
    }

    public void setPossibleSourceValues(String[] possibleSourceValues) {
        this.possibleSourceValues = new ArrayList<String>(Arrays.asList(possibleSourceValues));
    }

    protected void processFiltered(File file, FileText fileText) throws CheckstyleException {
        String fileName = file.getName();
        if (fileName.equals("build.properties")) {
            if (!this.isEmpty(fileText)) {
                this.processBuildProperties(fileText);
            } else {
                this.log(0, EMPTY_FILE_MSG, new Object[0]);
            }
        }
    }

    private void processBuildProperties(FileText fileText) throws CheckstyleException {
        IBuildEntry sourcePropertyValue;
        List<String> possibleMissingValues;
        IBuild buildPropertiesFile = this.parseBuildProperties(fileText);
        IBuildEntry binIncludesValue = buildPropertiesFile.getEntry("bin.includes");
        if (binIncludesValue != null) {
            List<String> missingValues = this.findMissingValues(binIncludesValue, this.expectedBinIncludesValues, true, (a, b) -> a.containsAll((Collection<?>)b));
            this.logMissingValues(fileText, "bin.includes", missingValues, MISSING_BIN_INCLUDES_VALUE_MSG);
        } else {
            this.log(0, MISSING_BIN_INCLUDES_PROPERTY_MSG, new Object[0]);
        }
        IBuildEntry outputPropertyValue = buildPropertiesFile.getEntry("output..");
        if (outputPropertyValue != null && !(possibleMissingValues = this.findMissingValues(outputPropertyValue, this.possibleOutputValues, false, (a, b) -> CollectionUtils.containsAny((Collection)a, (Collection)b))).isEmpty()) {
            ArrayList<String> valuesToLog = new ArrayList<String>();
            valuesToLog.add("Any of " + this.possibleOutputValues.toString());
            this.logMissingValues(fileText, "output..", valuesToLog, MISSING_OUTPUT_VALUE_MSG);
        }
        if ((sourcePropertyValue = buildPropertiesFile.getEntry("source..")) != null) {
            File bundleBaseDir = fileText.getFile().getParentFile();
            this.removeNonExistingSourceDirs(bundleBaseDir);
            List<String> missingValues = this.findMissingValues(sourcePropertyValue, this.possibleSourceValues, false, (a, b) -> a.containsAll((Collection<?>)b));
            this.logMissingValues(fileText, "source..", missingValues, MISSING_SRC_VALUE_MSG);
        }
    }

    private List<String> findMissingValues(IBuildEntry propertyValue, List<String> expectedPropertyValues, boolean strictSyntax, BiPredicate<List<String>, List<String>> condition) {
        List<String> values = Arrays.asList(propertyValue.getTokens());
        if (!strictSyntax) {
            this.removeSubstringAtEnd(values, "/");
            this.removeSubstringAtEnd(expectedPropertyValues, "/");
        }
        if (expectedPropertyValues != null && values != null && !condition.test(values, expectedPropertyValues)) {
            return this.removeAll(expectedPropertyValues, values);
        }
        return Collections.emptyList();
    }

    private void logMissingValues(FileText fileText, String property, List<String> missingValues, String messsage) {
        for (String missingValue : missingValues) {
            int lineNumber = this.findLineNumberSafe(fileText, property, 0, "Property line number not found.");
            this.log(lineNumber, String.valueOf(messsage) + missingValue, new Object[0]);
        }
    }

    private void removeSubstringAtEnd(List<String> values, String substr) {
        ListIterator<String> iterator = values.listIterator();
        while (iterator.hasNext()) {
            String value = iterator.next();
            if (!value.endsWith(substr)) continue;
            iterator.set(value.substring(0, value.length() - 1));
        }
    }

    private void removeNonExistingSourceDirs(File bundleBaseDir) {
        Iterator<String> iterator = this.possibleSourceValues.iterator();
        while (iterator.hasNext()) {
            String relativePath = iterator.next();
            File file = new File(bundleBaseDir, relativePath);
            if (file.exists()) continue;
            iterator.remove();
        }
    }

    private <T> List<T> removeAll(List<T> first, List<T> second) {
        ArrayList<T> result = new ArrayList<T>(first);
        result.removeAll(second);
        return result;
    }
}

